/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.CoFHCore;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.gui.client.machine.GuiFurnace;
import thermalexpansion.gui.container.machine.ContainerFurnace;
import thermalexpansion.util.crafting.FurnaceManager;

public class TileFurnace
extends TileMachineBase {
    static final int TYPE = BlockMachine.Types.FURNACE.ordinal();
    int outputTracker;

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].numGroup = 3;
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}};
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].allowInsertion = new boolean[]{false, true, false};
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].allowExtraction = new boolean[]{false, true, true};
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].sideTex = new int[]{0, 1, 4};
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        int n = MathHelper.clampI((int)ThermalExpansion.config.get("block.tweak", "Machine.Furnace.BasePower", 20), (int)10, (int)500);
        ThermalExpansion.config.set("block.tweak", "Machine.Furnace.BasePower", n);
        TileMachineBase.defaultEnergyConfig[TileFurnace.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParamsPower(n);
        TileMachineBase.sounds[TileFurnace.TYPE] = CoreUtils.getSoundName((String)"ThermalExpansion", (String)"blockMachineFurnace");
        TileMachineBase.enableSound[TileFurnace.TYPE] = CoFHCore.configClient.get("sound", "Machine.Furnace", true);
        GameRegistry.registerTileEntity(TileFurnace.class, (String)"thermalexpansion.Furnace");
    }

    public TileFurnace() {
        this.inventory = new ItemStack[3];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        FurnaceManager.RecipeFurnace recipeFurnace = FurnaceManager.getRecipe(this.inventory[0]);
        if (recipeFurnace == null || this.energyStorage.getEnergyStored() < recipeFurnace.getEnergy() * this.energyMod / this.processMod) {
            return false;
        }
        ItemStack itemStack = recipeFurnace.getOutput();
        if (itemStack == null) {
            return false;
        }
        if (this.inventory[1] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(itemStack)) {
            return false;
        }
        return this.inventory[1].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        FurnaceManager.RecipeFurnace recipeFurnace = FurnaceManager.getRecipe(this.inventory[0]);
        return recipeFurnace == null ? false : recipeFurnace.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = FurnaceManager.getRecipe(this.inventory[0]).getEnergy();
    }

    @Override
    protected void processFinish() {
        ItemStack itemStack = FurnaceManager.getRecipe(this.inventory[0]).getOutput();
        if (this.inventory[1] == null) {
            this.inventory[1] = itemStack;
        } else {
            this.inventory[1].field_77994_a += itemStack.field_77994_a;
        }
        --this.inventory[0].field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void transferProducts() {
        if (!this.augmentAutoTransfer) {
            return;
        }
        if (this.inventory[1] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 2 || !this.transferItem(1, 4, n)) continue;
            this.outputTracker = n;
            break;
        }
    }

    @Override
    public boolean isItemValid(ItemStack itemStack, int n, int n2) {
        return n == 0 ? FurnaceManager.recipeExists(itemStack) : true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiFurnace(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerFurnace(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.outputTracker = nBTTagCompound.func_74762_e("Tracker");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Tracker", this.outputTracker);
    }
}

