/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.sponge;

import cofh.api.tileentity.ISidedTexture;
import cofh.core.network.ITilePacketHandler;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.sponge.BlockSponge;

public class TileSponge
extends TileTEBase
implements ITilePacketHandler,
ISidedTexture {
    boolean full = false;
    boolean fullOnPlace = false;
    FluidStack fluid;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileSponge.class, (String)"thermalexpansion.Sponge");
    }

    public TileSponge() {
    }

    public TileSponge(int n) {
    }

    public String getName() {
        return "tile.thermalexpansion.sponge." + BlockSponge.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return BlockSponge.Types.BASIC.ordinal();
    }

    public boolean canUpdate() {
        return false;
    }

    public void blockBroken() {
        int n;
        int n2;
        int n3;
        for (n3 = ((TileEntity)this).field_145851_c - 1; n3 <= ((TileEntity)this).field_145851_c + 1; ++n3) {
            for (n2 = ((TileEntity)this).field_145848_d - 1; n2 <= ((TileEntity)this).field_145848_d + 1; ++n2) {
                for (n = ((TileEntity)this).field_145849_e - 1; n <= ((TileEntity)this).field_145849_e + 1; ++n) {
                    Block block = ((TileEntity)this).field_145850_b.func_147439_a(n3, n2, n);
                    if (block == TEBlocks.blockAirBarrier) {
                        ((TileEntity)this).field_145850_b.func_147468_f(n3, n2, n);
                        continue;
                    }
                    if (block != TEBlocks.blockSponge) continue;
                    ((TileEntity)this).field_145850_b.func_147464_a(n3, n2, n, TEBlocks.blockSponge, 1);
                }
            }
        }
        for (n3 = ((TileEntity)this).field_145851_c - 2; n3 <= ((TileEntity)this).field_145851_c + 2; n3 += 4) {
            for (n2 = ((TileEntity)this).field_145848_d - 2; n2 <= ((TileEntity)this).field_145848_d + 2; ++n2) {
                for (n = ((TileEntity)this).field_145849_e - 2; n <= ((TileEntity)this).field_145849_e + 2; ++n) {
                    if (((TileEntity)this).field_145850_b.func_147439_a(n3, n2, n) != TEBlocks.blockSponge) continue;
                    ((TileEntity)this).field_145850_b.func_147464_a(n3, n2, n, TEBlocks.blockSponge, 1);
                }
            }
        }
        for (n3 = ((TileEntity)this).field_145851_c - 2; n3 <= ((TileEntity)this).field_145851_c + 2; ++n3) {
            for (n2 = ((TileEntity)this).field_145848_d - 2; n2 <= ((TileEntity)this).field_145848_d + 2; n2 += 4) {
                for (n = ((TileEntity)this).field_145849_e - 2; n <= ((TileEntity)this).field_145849_e + 2; ++n) {
                    if (((TileEntity)this).field_145850_b.func_147439_a(n3, n2, n) != TEBlocks.blockSponge) continue;
                    ((TileEntity)this).field_145850_b.func_147464_a(n3, n2, n, TEBlocks.blockSponge, 1);
                }
            }
        }
        for (n3 = ((TileEntity)this).field_145851_c - 2; n3 <= ((TileEntity)this).field_145851_c + 2; ++n3) {
            for (n2 = ((TileEntity)this).field_145848_d - 2; n2 <= ((TileEntity)this).field_145848_d + 2; ++n2) {
                for (n = ((TileEntity)this).field_145849_e - 2; n <= ((TileEntity)this).field_145849_e + 2; n += 4) {
                    if (((TileEntity)this).field_145850_b.func_147439_a(n3, n2, n) != TEBlocks.blockSponge) continue;
                    ((TileEntity)this).field_145850_b.func_147464_a(n3, n2, n, TEBlocks.blockSponge, 1);
                }
            }
        }
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public void absorb() {
        this.placeAir();
    }

    public void placeAir() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        if (this.fullOnPlace) {
            return;
        }
        int n = 0;
        for (int i = ((TileEntity)this).field_145851_c - 1; i <= ((TileEntity)this).field_145851_c + 1; ++i) {
            for (int j = ((TileEntity)this).field_145848_d - 1; j <= ((TileEntity)this).field_145848_d + 1; ++j) {
                for (int k = ((TileEntity)this).field_145849_e - 1; k <= ((TileEntity)this).field_145849_e + 1; ++k) {
                    Block block = ((TileEntity)this).field_145850_b.func_147439_a(i, j, k);
                    int n2 = ((TileEntity)this).field_145850_b.func_72805_g(i, j, k);
                    Fluid fluid = FluidHelper.lookupFluidForBlock((Block)block);
                    if (n2 == 0) {
                        if (!this.full && fluid != null && fluid.getTemperature() < 1000) {
                            if (this.fluid == null) {
                                this.fluid = new FluidStack(fluid, 1000);
                                n = 1;
                                ((TileEntity)this).field_145850_b.func_147465_d(i, j, k, TEBlocks.blockAirBarrier, 0, 3);
                                continue;
                            }
                            if (this.fluid.fluidID != fluid.getID()) continue;
                            ++n;
                            ((TileEntity)this).field_145850_b.func_147465_d(i, j, k, TEBlocks.blockAirBarrier, 0, 3);
                            continue;
                        }
                        if (!block.isAir((IBlockAccess)((TileEntity)this).field_145850_b, i, j, k)) continue;
                        ((TileEntity)this).field_145850_b.func_147465_d(i, j, k, TEBlocks.blockAirBarrier, 0, 3);
                        continue;
                    }
                    if (!block.isAir((IBlockAccess)((TileEntity)this).field_145850_b, i, j, k) && !block.func_149688_o().func_76224_d() || fluid != null && fluid.getTemperature() >= 1000) continue;
                    ((TileEntity)this).field_145850_b.func_147465_d(i, j, k, TEBlocks.blockAirBarrier, 0, 3);
                }
            }
        }
        if (this.fluid != null) {
            this.fluid.amount = n * 1000;
            this.full = true;
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluid = fluidStack;
        this.fullOnPlace = true;
        this.full = true;
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.fullOnPlace = nBTTagCompound.func_74767_n("PlaceFull");
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound);
        this.full = this.fluid != null;
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("PlaceFull", this.fullOnPlace);
        if (this.fluid != null) {
            this.fluid.writeToNBT(nBTTagCompound);
        }
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addBool(this.full);
        packetCoFHBase.addFluidStack(this.fluid);
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.full = packetCoFHBase.getBool();
            this.fluid = packetCoFHBase.getFluidStack();
        } else {
            packetCoFHBase.getBool();
            packetCoFHBase.getFluidStack();
        }
    }

    public IIcon getTexture(int n, int n2) {
        return IconRegistry.getIcon((String)"Sponge", (int)(this.full ? this.getType() + 8 : this.getType()));
    }
}

