/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.tank;

import cofh.api.tileentity.ITileInfo;
import cofh.core.network.ITilePacketHandler;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.tank.BlockTank;

public class TileTank
extends TileTEBase
implements IFluidHandler,
ITilePacketHandler,
ITileInfo {
    protected static final int UPDATE_FACTOR = 4;
    public static final int RENDER_LEVELS = 128;
    public static int[] CAPACITY = new int[]{1000, 8000, 32000, 128000, 512000};
    int compareTracker;
    int lastDisplayLevel;
    FluidTankAdv tank;
    boolean cached = false;
    boolean[] adjacentTanks = new boolean[2];
    IFluidHandler[] adjacentHandlers = new IFluidHandler[2];
    public byte mode;
    public byte type;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileTank.class, (String)"thermalexpansion.Tank");
    }

    public TileTank() {
        this.tank = new FluidTankAdv(CAPACITY[1]);
    }

    public TileTank(int n) {
        this.tank = new FluidTankAdv(CAPACITY[n]);
        this.type = (byte)n;
    }

    public String getName() {
        return "tile.thermalexpansion.tank." + BlockTank.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return this.type;
    }

    public int getComparatorInput(int n) {
        return this.compareTracker;
    }

    public int getLightValue() {
        if (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null) {
            return 0;
        }
        int n = this.tank.getFluid().getFluid().getLuminosity();
        if (this.tank.getFluidAmount() <= CAPACITY[this.type] / 4) {
            return n >> 1;
        }
        if (this.tank.getFluidAmount() >= CAPACITY[this.type] * 3 / 4) {
            return n;
        }
        return (n >> 1) + (n - (n >> 1)) * (this.tank.getFluidAmount() - (CAPACITY[this.type] >> 2)) / (CAPACITY[this.type] >> 1);
    }

    public boolean onWrench(EntityPlayer entityPlayer, int n) {
        this.mode = (byte)(this.mode + 1);
        this.mode = (byte)(this.mode % 2);
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers();
    }

    public void onNeighborTileChange(int n, int n2, int n3) {
        super.onNeighborTileChange(n, n2, n3);
        this.updateAdjacentHandlers();
    }

    public void func_145845_h() {
        int n;
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        if (!this.cached) {
            this.onNeighborBlockChange();
        }
        if (this.mode == 1) {
            this.transferFluid();
        }
        if (this.timeCheck() && (n = this.getScaledFluidStored(15)) != this.compareTracker) {
            this.compareTracker = n;
            this.callNeighborTileChange();
        }
        if (((TileEntity)this).field_145850_b.func_82737_E() % 4L == 0L) {
            this.updateRender();
        }
        super.func_145845_h();
    }

    public void func_145843_s() {
        this.cached = false;
        super.func_145843_s();
    }

    protected int getScaledFluidStored(int n) {
        return this.tank.getFluid() == null ? 0 : this.tank.getFluid().amount * n / this.tank.getCapacity();
    }

    protected void transferFluid() {
        if (this.tank.getFluidAmount() <= 0 || this.adjacentHandlers[0] == null) {
            return;
        }
        this.tank.drain(this.adjacentHandlers[0].fill(ForgeDirection.VALID_DIRECTIONS[1], new FluidStack(this.tank.getFluid(), Math.min(1000, this.tank.getFluidAmount())), true), true);
        if (this.tank.getFluidAmount() <= 0) {
            this.updateRender();
        }
    }

    protected void updateAdjacentHandlers() {
        byte by = this.mode;
        TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)0);
        if (FluidHelper.isFluidHandler((TileEntity)tileEntity)) {
            this.adjacentHandlers[0] = (IFluidHandler)tileEntity;
            if (tileEntity instanceof TileTank) {
                this.mode = 1;
                this.adjacentTanks[0] = true;
            } else {
                this.adjacentTanks[0] = false;
            }
        } else {
            this.adjacentHandlers[0] = null;
            this.adjacentTanks[0] = false;
        }
        tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)1);
        if (FluidHelper.isFluidHandler((TileEntity)tileEntity)) {
            this.adjacentHandlers[1] = (IFluidHandler)tileEntity;
            this.adjacentTanks[1] = tileEntity instanceof TileTank;
        } else {
            this.adjacentHandlers[1] = null;
            this.adjacentTanks[1] = false;
        }
        if (by != this.mode) {
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public int getTankCapacity() {
        return this.tank.getCapacity();
    }

    public int getTankFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public void calcLastDisplay() {
        this.lastDisplayLevel = (int)((float)this.tank.getFluidAmount() / (float)CAPACITY[this.type] * 127.0f);
    }

    public void updateRender() {
        int n = 0;
        if (this.tank.getFluidAmount() > 0) {
            n = (int)((float)this.tank.getFluidAmount() / (float)CAPACITY[this.type] * 127.0f);
            if (n == 0) {
                n = 1;
            }
            if (this.lastDisplayLevel == 0) {
                this.lastDisplayLevel = n;
                this.sendUpdatePacket(Side.CLIENT);
                return;
            }
        } else if (this.lastDisplayLevel != 0) {
            this.lastDisplayLevel = 0;
            this.sendUpdatePacket(Side.CLIENT);
        }
        if (n <= this.lastDisplayLevel - 4) {
            this.lastDisplayLevel = n;
            this.sendUpdatePacket(Side.CLIENT);
        } else if (n >= this.lastDisplayLevel + 4) {
            this.lastDisplayLevel = n;
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.type = nBTTagCompound.func_74771_c("Type");
        this.mode = nBTTagCompound.func_74771_c("Mode");
        this.tank = new FluidTankAdv(CAPACITY[this.type]);
        this.tank.readFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Type", this.type);
        nBTTagCompound.func_74774_a("Mode", this.mode);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte(this.type);
        packetCoFHBase.addByte(this.mode);
        packetCoFHBase.addFluidStack(this.tank.getFluid());
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.type = packetCoFHBase.getByte();
        this.mode = packetCoFHBase.getByte();
        this.tank.setFluid(packetCoFHBase.getFluidStack());
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (forgeDirection.ordinal() == 0 && this.mode == 1 && !this.adjacentTanks[0]) {
            return 0;
        }
        if (forgeDirection.ordinal() > 1 && forgeDirection.ordinal() < 6) {
            return 0;
        }
        int n = this.tank.fill(fluidStack, bl);
        if (forgeDirection.ordinal() != 1 && this.adjacentHandlers[1] != null && this.adjacentTanks[1]) {
            if (n == 0) {
                return this.adjacentHandlers[1].fill(ForgeDirection.DOWN, fluidStack, bl);
            }
            if (n != fluidStack.amount) {
                FluidStack fluidStack2 = fluidStack.copy();
                fluidStack2.amount -= n;
                return n + this.adjacentHandlers[1].fill(ForgeDirection.DOWN, fluidStack2, bl);
            }
        }
        return n;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (forgeDirection.ordinal() == 0 && this.mode == 1) {
            return null;
        }
        if (forgeDirection.ordinal() > 1 && forgeDirection.ordinal() < 6) {
            return null;
        }
        return this.tank.drain(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (forgeDirection.ordinal() == 0 && this.mode == 1) {
            return null;
        }
        if (forgeDirection.ordinal() > 1 && forgeDirection.ordinal() < 6) {
            return null;
        }
        return this.tank.drain(n, bl);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return forgeDirection.ordinal() < 2;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return forgeDirection.ordinal() < 1;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public void getTileInfo(List<IChatComponent> list, ForgeDirection forgeDirection, EntityPlayer entityPlayer, boolean bl) {
        if (bl) {
            return;
        }
        if (this.tank.getFluid() != null) {
            list.add((IChatComponent)new ChatComponentText(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.getFluidName((FluidStack)this.tank.getFluid())));
            list.add((IChatComponent)new ChatComponentText(StringHelper.localize((String)"info.cofh.amount") + ": " + this.tank.getFluidAmount() + "/" + this.tank.getCapacity() + " mB"));
        } else {
            list.add((IChatComponent)new ChatComponentText(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty")));
        }
    }

    static {
        String string = "block.tweak";
        TileTank.CAPACITY[4] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Tank.Resonant.Capacity", CAPACITY[4]), (int)(CAPACITY[4] / 8), (int)1000000000);
        TileTank.CAPACITY[3] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Tank.Reinforced.Capacity", CAPACITY[3]), (int)(CAPACITY[3] / 8), (int)CAPACITY[4]);
        TileTank.CAPACITY[2] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Tank.Hardened.Capacity", CAPACITY[2]), (int)(CAPACITY[2] / 8), (int)CAPACITY[3]);
        TileTank.CAPACITY[1] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Tank.Basic.Capacity", CAPACITY[1]), (int)(CAPACITY[1] / 8), (int)CAPACITY[2]);
    }
}

