/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import cofh.core.render.IconRegistry;
import cofh.core.render.RenderUtils;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import thermalexpansion.block.dynamo.BlockDynamo;
import thermalexpansion.block.dynamo.TileDynamoBase;
import thermalexpansion.core.TEProps;

public class RenderDynamo
implements ISimpleBlockRenderingHandler {
    public static final RenderDynamo instance = new RenderDynamo();
    static IIcon textureCoil;
    static IIcon[] textureBase;
    static CCModel[][] modelCoil;
    static CCModel[][] modelBase;
    static CCModel[] modelAnimation;

    public static void initialize() {
        textureCoil = IconRegistry.getIcon((String)"DynamoCoilRedstone");
        for (int i = 0; i < textureBase.length; ++i) {
            RenderDynamo.textureBase[i] = IconRegistry.getIcon((String)"Dynamo", (int)i);
        }
    }

    private static void generateModels() {
        int n;
        double d = 9.765625E-4;
        double d2 = 0.375;
        double d3 = 0.625;
        RenderDynamo.modelCoil[0][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 0.0, -4.0, 8.0, 8.0, 8.0, 0.0, 0.0, 32.0, 32.0, 16.0).computeNormals().shrinkUVs(d);
        RenderDynamo.modelCoil[1][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 0.0, -4.0, 8.0, 8.0, 8.0, 0.0, 16.0, 32.0, 32.0, 16.0).computeNormals().shrinkUVs(d);
        RenderDynamo.modelBase[0][1] = CCModel.quadModel((int)24).generateBox(0, -8.0, -8.0, -8.0, 16.0, 10.0, 16.0, 0.0, 0.0, 64.0, 64.0, 16.0).computeNormals().shrinkUVs(d);
        RenderDynamo.modelBase[1][1] = CCModel.quadModel((int)24).generateBox(0, -8.0, -8.0, -8.0, 16.0, 10.0, 16.0, 0.0, 32.0, 64.0, 64.0, 16.0).computeNormals().shrinkUVs(d);
        RenderDynamo.modelAnimation[0] = CCModel.quadModel((int)16).generateBlock(0, d, d2 - d, d, 1.0 - d, 1.0 - d, 1.0 - d, 3).computeNormals();
        RenderDynamo.modelAnimation[1] = CCModel.quadModel((int)16).generateBlock(0, d, d, d, 1.0 - d, d3 - d, 1.0 - d, 3).computeNormals();
        RenderDynamo.modelAnimation[2] = CCModel.quadModel((int)16).generateBlock(0, d, d, d2 - d, 1.0 - d, 1.0 - d, 1.0 - d, 12).computeNormals();
        RenderDynamo.modelAnimation[3] = CCModel.quadModel((int)16).generateBlock(0, d, d, d, 1.0 - d, 1.0 - d, d3 - d, 12).computeNormals();
        RenderDynamo.modelAnimation[4] = CCModel.quadModel((int)16).generateBlock(0, d2 - d, d, d, 1.0 - d, 1.0 - d, 1.0 - d, 48).computeNormals();
        RenderDynamo.modelAnimation[5] = CCModel.quadModel((int)16).generateBlock(0, d, d, d, d3 - d, 1.0 - d, 1.0 - d, 48).computeNormals();
        for (n = 0; n < modelCoil.length; ++n) {
            CCModel.generateSidedModels((CCModel[])modelCoil[n], (int)1, (Vector3)new Vector3());
        }
        for (n = 0; n < modelBase.length; ++n) {
            CCModel.generateSidedModels((CCModel[])modelBase[n], (int)1, (Vector3)new Vector3());
        }
    }

    public void renderCoil(int n, boolean bl, double d, double d2, double d3) {
        Translation translation = RenderUtils.getRenderVector((double)(d += 0.5), (double)(d2 += 0.5), (double)(d3 += 0.5)).translation();
        if (bl) {
            modelCoil[0][n].render(new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)textureCoil)});
        } else {
            modelCoil[1][n].render(new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)textureCoil)});
        }
    }

    public void renderBase(int n, boolean bl, int n2, double d, double d2, double d3) {
        Translation translation = RenderUtils.getRenderVector((double)(d += 0.5), (double)(d2 += 0.5), (double)(d3 += 0.5)).translation();
        if (bl) {
            modelBase[0][n].render(new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)textureBase[n2])});
        } else {
            modelBase[1][n].render(new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)textureBase[n2])});
        }
    }

    public void renderAnimation(int n, boolean bl, int n2, IIcon iIcon, double d, double d2, double d3) {
        if (bl) {
            modelAnimation[n].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)iIcon));
        }
    }

    public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
        RenderUtils.preItemRender();
        CCRenderState.startDrawing();
        this.renderCoil(1, false, -0.5, -0.5, -0.5);
        this.renderBase(1, false, n, -0.5, -0.5, -0.5);
        CCRenderState.draw();
        RenderUtils.postItemRender();
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (!(tileEntity instanceof TileDynamoBase)) {
            return false;
        }
        TileDynamoBase tileDynamoBase = (TileDynamoBase)tileEntity;
        RenderUtils.preWorldRender((IBlockAccess)iBlockAccess, (int)n, (int)n2, (int)n3);
        this.renderCoil(tileDynamoBase.getFacing(), tileDynamoBase.isActive, n, n2, n3);
        this.renderAnimation(tileDynamoBase.getFacing(), tileDynamoBase.isActive, tileDynamoBase.getType(), tileDynamoBase.getActiveIcon(), n, n2, n3);
        this.renderBase(tileDynamoBase.getFacing(), tileDynamoBase.isActive, tileDynamoBase.getType(), n, n2, n3);
        return true;
    }

    public boolean shouldRender3DInInventory(int n) {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdDynamo;
    }

    static {
        textureBase = new IIcon[BlockDynamo.Types.values().length];
        modelCoil = new CCModel[2][6];
        modelBase = new CCModel[2][6];
        modelAnimation = new CCModel[6];
        TEProps.renderIdDynamo = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        RenderDynamo.generateModels();
    }
}

