/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.lib.inventory.ComparableItemStackSafe;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.item.TEItems;
import thermalexpansion.util.crafting.FurnaceManager;
import thermalfoundation.item.TFItems;

public class SmelterManager {
    public static ItemStack blockSand = new ItemStack((Block)Blocks.field_150354_m);
    private static Map<List, RecipeSmelter> recipeMap = new THashMap();
    private static Set<ComparableItemStackSafe> validationSet = new THashSet();
    private static ComparableItemStackSafe query = new ComparableItemStackSafe(new ItemStack(Blocks.field_150348_b));
    private static ComparableItemStackSafe querySecondary = new ComparableItemStackSafe(new ItemStack(Blocks.field_150348_b));
    private static boolean allowOverwrite = false;
    private static ArrayList<String> blastList = new ArrayList();

    public static boolean isRecipeReversed(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        RecipeSmelter recipeSmelter = recipeMap.get(Arrays.asList(query.set(itemStack), querySecondary.set(itemStack2)));
        return recipeSmelter != null ? false : recipeMap.get(Arrays.asList(querySecondary, query)) != null;
    }

    public static RecipeSmelter getRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null) {
            return null;
        }
        RecipeSmelter recipeSmelter = recipeMap.get(Arrays.asList(query.set(itemStack), querySecondary.set(itemStack2)));
        if (recipeSmelter == null) {
            recipeSmelter = recipeMap.get(Arrays.asList(querySecondary, query));
        }
        if (recipeSmelter == null) {
            return null;
        }
        return recipeSmelter;
    }

    public static boolean recipeExists(ItemStack itemStack, ItemStack itemStack2) {
        return SmelterManager.getRecipe(itemStack, itemStack2) != null;
    }

    public static RecipeSmelter[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeSmelter[0]);
    }

    public static boolean isItemValid(ItemStack itemStack) {
        return itemStack == null ? false : validationSet.contains(query.set(itemStack));
    }

    public static boolean isStandardOre(String string) {
        return ItemHelper.oreNameExists((String)string) && FurnaceManager.recipeExists((ItemStack)OreDictionary.getOres((String)string).get(0));
    }

    public static void addDefaultRecipes() {
        SmelterManager.addTERecipe(4000, new ItemStack(Blocks.field_150450_ax), blockSand, new ItemStack(Blocks.field_150451_bX), TEItems.slagRich, 40);
        SmelterManager.addTERecipe(4000, new ItemStack(Blocks.field_150424_aL, 4), new ItemStack(Blocks.field_150425_aM), new ItemStack(Blocks.field_150385_bj, 2), TFItems.dustSulfur, 25);
        ItemStack itemStack = new ItemStack(TEBlocks.blockGlass, 2, 0);
        SmelterManager.addAlloyRecipe(4000, "dustLead", 1, "dustObsidian", 8, itemStack);
        SmelterManager.addAlloyRecipe(4000, "ingotLead", 1, "dustObsidian", 8, itemStack);
        SmelterManager.addDefaultOreDictionaryRecipe("oreIron", "dustIron", TFItems.ingotIron, TFItems.ingotNickel);
        SmelterManager.addDefaultOreDictionaryRecipe("oreGold", "dustGold", TFItems.ingotGold, null, 10, 75, 25);
        SmelterManager.addDefaultOreDictionaryRecipe("oreCopper", "dustCopper", TFItems.ingotCopper, TFItems.ingotGold);
        SmelterManager.addDefaultOreDictionaryRecipe("oreTin", "dustTin", TFItems.ingotTin, TFItems.ingotIron);
        SmelterManager.addDefaultOreDictionaryRecipe("oreSilver", "dustSilver", TFItems.ingotSilver, TFItems.ingotLead);
        SmelterManager.addDefaultOreDictionaryRecipe("oreLead", "dustLead", TFItems.ingotLead, TFItems.ingotSilver);
        SmelterManager.addDefaultOreDictionaryRecipe("oreNickel", "dustNickel", TFItems.ingotNickel, TFItems.ingotPlatinum, 15, 75, 25);
        SmelterManager.addDefaultOreDictionaryRecipe("orePlatinum", "dustPlatinum", TFItems.ingotPlatinum);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustElectrum", TFItems.ingotElectrum);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustInvar", TFItems.ingotInvar);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustBronze", TFItems.ingotBronze);
        ItemStack itemStack2 = ItemHelper.cloneStack((ItemStack)TFItems.ingotElectrum, (int)2);
        ItemStack itemStack3 = ItemHelper.cloneStack((ItemStack)TFItems.ingotInvar, (int)3);
        ItemStack itemStack4 = ItemHelper.cloneStack((ItemStack)TFItems.ingotBronze, (int)4);
        SmelterManager.addAlloyRecipe(1600, "dustSilver", 1, "dustGold", 1, itemStack2);
        SmelterManager.addAlloyRecipe(2400, "ingotSilver", 1, "ingotGold", 1, itemStack2);
        SmelterManager.addAlloyRecipe(1600, "dustNickel", 1, "dustIron", 2, itemStack3);
        SmelterManager.addAlloyRecipe(2400, "ingotNickel", 1, "ingotIron", 2, itemStack3);
        SmelterManager.addAlloyRecipe(1600, "dustTin", 1, "dustCopper", 3, itemStack4);
        SmelterManager.addAlloyRecipe(2400, "ingotTin", 1, "ingotCopper", 3, itemStack4);
        SmelterManager.addBlastOreRecipe("mithril");
        SmelterManager.addBlastOreRecipe("enderium");
    }

    public static void loadRecipes() {
        int n;
        ItemStack itemStack;
        boolean bl = ThermalExpansion.config.get("tweak.crafting", "Smelter.Steel.Enable", true);
        if (ItemHelper.oreNameExists((String)"ingotSteel") && bl) {
            itemStack = ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotSteel").get(0)), (int)1);
            SmelterManager.addAlloyRecipe(8000, "dustCoal", 2, "dustSteel", 1, itemStack);
            SmelterManager.addAlloyRecipe(8000, "dustCoal", 2, "dustIron", 1, itemStack);
            SmelterManager.addAlloyRecipe(8000, "dustCoal", 2, "ingotIron", 1, itemStack);
            SmelterManager.addAlloyRecipe(8000, "charcoal", 4, "dustSteel", 1, itemStack);
            SmelterManager.addAlloyRecipe(8000, "charcoal", 4, "dustIron", 1, itemStack);
            SmelterManager.addAlloyRecipe(8000, "charcoal", 4, "ingotIron", 1, itemStack);
        }
        itemStack = OreDictionary.getOreNames();
        String string = "";
        for (n = 0; n < ((String[])itemStack).length; ++n) {
            if (itemStack[n].startsWith("ore")) {
                string = itemStack[n].substring(3, itemStack[n].length());
                if (!SmelterManager.isStandardOre((String)itemStack[n])) continue;
                SmelterManager.addDefaultOreDictionaryRecipe(string);
                continue;
            }
            if (!itemStack[n].startsWith("dust")) continue;
            string = itemStack[n].substring(4, itemStack[n].length());
            if (!SmelterManager.isStandardOre((String)itemStack[n])) continue;
            SmelterManager.addDefaultOreDictionaryRecipe(string);
        }
        for (n = 0; n < blastList.size(); ++n) {
            SmelterManager.addBlastOreRecipe(blastList.get(n));
        }
    }

    public static void refreshRecipes() {
        THashMap tHashMap = new THashMap(recipeMap.size());
        THashSet tHashSet = new THashSet();
        for (Map.Entry<List, RecipeSmelter> entry : recipeMap.entrySet()) {
            RecipeSmelter recipeSmelter = entry.getValue();
            ComparableItemStackSafe comparableItemStackSafe = new ComparableItemStackSafe(recipeSmelter.primaryInput);
            ComparableItemStackSafe comparableItemStackSafe2 = new ComparableItemStackSafe(recipeSmelter.secondaryInput);
            tHashMap.put(Arrays.asList(comparableItemStackSafe, comparableItemStackSafe2), recipeSmelter);
            tHashSet.add(comparableItemStackSafe);
            tHashSet.add(comparableItemStackSafe2);
        }
        recipeMap.clear();
        recipeMap = tHashMap;
        validationSet.clear();
        validationSet = tHashSet;
    }

    protected static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n2) {
        if (itemStack == null || itemStack2 == null || n <= 0) {
            return false;
        }
        RecipeSmelter recipeSmelter = new RecipeSmelter(itemStack, itemStack2, itemStack3, itemStack4, n2, n);
        recipeMap.put(Arrays.asList(new ComparableItemStackSafe(itemStack), new ComparableItemStackSafe(itemStack2)), recipeSmelter);
        validationSet.add(new ComparableItemStackSafe(itemStack));
        validationSet.add(new ComparableItemStackSafe(itemStack2));
        return true;
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n2, boolean bl) {
        if (itemStack == null || itemStack2 == null || n <= 0 || !(allowOverwrite & bl) && SmelterManager.recipeExists(itemStack, itemStack2)) {
            return false;
        }
        RecipeSmelter recipeSmelter = new RecipeSmelter(itemStack, itemStack2, itemStack3, itemStack4, n2, n);
        recipeMap.put(Arrays.asList(new ComparableItemStackSafe(itemStack), new ComparableItemStackSafe(itemStack2)), recipeSmelter);
        validationSet.add(new ComparableItemStackSafe(itemStack));
        validationSet.add(new ComparableItemStackSafe(itemStack2));
        return true;
    }

    public static void addDefaultOreDictionaryRecipe(String string, String string2, ItemStack itemStack, ItemStack itemStack2, int n, int n2, int n3) {
        if (itemStack == null) {
            return;
        }
        ItemStack itemStack3 = ItemHelper.cloneStack((ItemStack)itemStack, (int)2);
        if (string != null) {
            SmelterManager.addOreToIngotRecipe(string, itemStack3, ItemHelper.cloneStack((ItemStack)itemStack, (int)3), ItemHelper.cloneStack((ItemStack)itemStack2, (int)1), n, n2);
        }
        if (string2 != null) {
            SmelterManager.addDustToIngotRecipe(string2, itemStack3, n3);
        }
    }

    public static void addDefaultOreDictionaryRecipe(String string) {
        SmelterManager.addDefaultOreDictionaryRecipe(string, "");
    }

    public static void addDefaultOreDictionaryRecipe(String string, String string2) {
        String string3 = "ore" + StringHelper.titleCase((String)string);
        String string4 = "dust" + StringHelper.titleCase((String)string);
        String string5 = "ingot" + StringHelper.titleCase((String)string);
        ArrayList arrayList = OreDictionary.getOres((String)string3);
        ArrayList arrayList2 = OreDictionary.getOres((String)string4);
        ArrayList arrayList3 = OreDictionary.getOres((String)string5);
        ArrayList arrayList4 = new ArrayList();
        if (string2 != "") {
            String string6 = "ingot" + StringHelper.titleCase((String)string2);
            arrayList4 = OreDictionary.getOres((String)string6);
        }
        if (arrayList3.isEmpty()) {
            return;
        }
        if (arrayList.isEmpty()) {
            string3 = null;
        }
        if (arrayList2.isEmpty()) {
            string4 = null;
        }
        if (!arrayList4.isEmpty() && arrayList4.get(0) != null) {
            SmelterManager.addDefaultOreDictionaryRecipe(string3, string4, (ItemStack)arrayList3.get(0), (ItemStack)arrayList4.get(0), 5, 75, 25);
        } else {
            SmelterManager.addDefaultOreDictionaryRecipe(string3, string4, (ItemStack)arrayList3.get(0), null, 5, 75, 25);
        }
    }

    public static void addDefaultOreDictionaryRecipe(String string, String string2, ItemStack itemStack) {
        SmelterManager.addDefaultOreDictionaryRecipe(string, string2, itemStack, null, 5, 75, 25);
    }

    public static void addDefaultOreDictionaryRecipe(String string, String string2, ItemStack itemStack, ItemStack itemStack2) {
        SmelterManager.addDefaultOreDictionaryRecipe(string, string2, itemStack, itemStack2, 5, 75, 25);
    }

    public static void addOreToIngotRecipe(String string, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n, int n2) {
        ArrayList arrayList = OreDictionary.getOres((String)string);
        if (arrayList.size() > 0) {
            ItemStack itemStack4 = (ItemStack)arrayList.get(0);
            SmelterManager.addRecipe(3200, itemStack4, blockSand, itemStack, TEItems.slagRich, n);
            SmelterManager.addRecipe(4000, itemStack4, TEItems.slagRich, itemStack2, TEItems.slag, n2);
            SmelterManager.addRecipe(4000, itemStack4, TFItems.dustPyrotheum, itemStack, TEItems.slagRich, Math.min(60, n * 3));
            if (itemStack3 != null) {
                SmelterManager.addRecipe(4000, itemStack4, TFItems.crystalCinnabar, itemStack2, itemStack3, 100);
            } else {
                SmelterManager.addRecipe(4000, itemStack4, TFItems.crystalCinnabar, itemStack2, TEItems.slagRich, 75);
            }
        }
    }

    public static void addDustToIngotRecipe(String string, ItemStack itemStack, int n) {
        ArrayList arrayList = OreDictionary.getOres((String)string);
        if (arrayList.size() > 0) {
            SmelterManager.addRecipe(800, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList.get(0)), (int)2), blockSand, itemStack, TEItems.slag, n);
        }
    }

    public static void addAlloyRecipe(int n, String string, int n2, String string2, int n3, ItemStack itemStack) {
        ArrayList arrayList = OreDictionary.getOres((String)string);
        ArrayList arrayList2 = OreDictionary.getOres((String)string2);
        if (arrayList.size() > 0 && arrayList2.size() > 0) {
            SmelterManager.addAlloyRecipe(n, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList.get(0)), (int)n2), ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList2.get(0)), (int)n3), itemStack);
        }
    }

    public static void addAlloyRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        SmelterManager.addTERecipe(n, itemStack, itemStack2, itemStack3, null, 0);
    }

    public static void addBlastOreRecipe(String string) {
        String string2 = "ore" + StringHelper.titleCase((String)string);
        String string3 = "dust" + StringHelper.titleCase((String)string);
        String string4 = "ingot" + StringHelper.titleCase((String)string);
        ArrayList arrayList = OreDictionary.getOres((String)string2);
        ArrayList arrayList2 = OreDictionary.getOres((String)string3);
        ArrayList arrayList3 = OreDictionary.getOres((String)string4);
        if (arrayList3.isEmpty()) {
            return;
        }
        if (!arrayList.isEmpty()) {
            SmelterManager.addRecipe(12000, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList.get(0)), (int)1), TFItems.dustPyrotheum, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList3.get(0)), (int)2));
        }
        if (!arrayList2.isEmpty()) {
            SmelterManager.addRecipe(8000, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList2.get(0)), (int)2), TFItems.dustPyrotheum, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList3.get(0)), (int)2));
        }
    }

    public static void addBlastOreName(String string) {
        blastList.add(StringHelper.camelCase((String)string));
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        return SmelterManager.addRecipe(n, itemStack, itemStack2, itemStack3, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, boolean bl) {
        return SmelterManager.addRecipe(n, itemStack, itemStack2, itemStack3, null, 0, bl);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4) {
        return SmelterManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, boolean bl) {
        return SmelterManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, 100, bl);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n2) {
        return SmelterManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, n2, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("tweak.crafting", "Smelter.AllowRecipeOverwrite", false);
        blastList.add("mithril");
        blastList.add("enderium");
        blastList.add("aluminum");
        blastList.add("ardite");
        blastList.add("cobalt");
    }

    public static class RecipeSmelter {
        final ItemStack primaryInput;
        final ItemStack secondaryInput;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        RecipeSmelter(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n, int n2) {
            this.primaryInput = itemStack;
            this.secondaryInput = itemStack2;
            this.primaryOutput = itemStack3;
            this.secondaryOutput = itemStack4;
            this.secondaryChance = n;
            this.energy = n2;
        }

        public ItemStack getPrimaryInput() {
            return this.primaryInput.func_77946_l();
        }

        public ItemStack getSecondaryInput() {
            return this.secondaryInput.func_77946_l();
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput.func_77946_l();
        }

        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput == null) {
                return null;
            }
            return this.secondaryOutput.func_77946_l();
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

