/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.inventory.ComparableItemStackSafe;
import cofh.lib.util.helpers.ItemHelper;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import thermalexpansion.ThermalExpansion;
import thermalfoundation.fluid.TFFluids;
import thermalfoundation.item.TFItems;

public class TransposerManager {
    private static Map<List, RecipeTransposer> recipeMapFill = new THashMap();
    private static Map<ComparableItemStackSafe, RecipeTransposer> recipeMapExtraction = new THashMap();
    private static Set<ComparableItemStackSafe> validationSet = new THashSet();
    private static ComparableItemStack query = new ComparableItemStackSafe(new ItemStack(Blocks.field_150348_b));
    private static boolean allowOverwrite = false;

    public static RecipeTransposer getFillRecipe(ItemStack itemStack, FluidStack fluidStack) {
        return itemStack == null || fluidStack == null ? null : recipeMapFill.get(Arrays.asList(query.set(itemStack).hashCode(), fluidStack.fluidID));
    }

    public static RecipeTransposer getExtractionRecipe(ItemStack itemStack) {
        return itemStack == null ? null : recipeMapExtraction.get(query.set(itemStack));
    }

    public static boolean fillRecipeExists(ItemStack itemStack, FluidStack fluidStack) {
        return TransposerManager.getFillRecipe(itemStack, fluidStack) != null;
    }

    public static boolean extractionRecipeExists(ItemStack itemStack, FluidStack fluidStack) {
        return TransposerManager.getExtractionRecipe(itemStack) != null;
    }

    public static RecipeTransposer[] getFillRecipeList() {
        return recipeMapFill.values().toArray(new RecipeTransposer[0]);
    }

    public static RecipeTransposer[] getExtractionRecipeList() {
        return recipeMapExtraction.values().toArray(new RecipeTransposer[0]);
    }

    public static boolean isItemValid(ItemStack itemStack) {
        return itemStack == null ? false : validationSet.contains(query.set(itemStack));
    }

    public static void addDefaultRecipes() {
        TransposerManager.addFillRecipe(8000, new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150341_Y), new FluidStack(FluidRegistry.WATER, 250), false);
        TransposerManager.addFillRecipe(8000, new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150417_aV, 1, 1), new FluidStack(FluidRegistry.WATER, 250), false);
        TransposerManager.addFillRecipe(8000, new ItemStack(Blocks.field_150322_A), new ItemStack(Blocks.field_150377_bs), new FluidStack(TFFluids.fluidEnder, 250), false);
        TransposerManager.addTEFillRecipe(4000, new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_151065_br), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addTEFillRecipe(4000, new ItemStack(Items.field_151126_ay), ItemHelper.cloneStack((ItemStack)TFItems.dustBlizz, (int)1), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketRedstone, (int)1), new FluidStack(TFFluids.fluidRedstone, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketGlowstone, (int)1), new FluidStack(TFFluids.fluidGlowstone, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketEnder, (int)1), new FluidStack(TFFluids.fluidEnder, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketPyrotheum, (int)1), new FluidStack(TFFluids.fluidPyrotheum, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketCryotheum, (int)1), new FluidStack(TFFluids.fluidCryotheum, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketCoal, (int)1), new FluidStack(TFFluids.fluidCoal, 1000), true);
    }

    public static void loadRecipes() {
        TransposerManager.addFillRecipe(1600, ItemHelper.getOre((String)"oreCinnabar"), ItemHelper.cloneStack((ItemStack)TFItems.crystalCinnabar, (int)1), new FluidStack(TFFluids.fluidCryotheum, 200), false);
        for (FluidContainerRegistry.FluidContainerData fluidContainerData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (FluidContainerRegistry.isBucket((ItemStack)fluidContainerData.emptyContainer)) {
                TransposerManager.addFillRecipe(800, fluidContainerData, true);
                continue;
            }
            TransposerManager.addFillRecipe(1600, fluidContainerData, true);
        }
    }

    public static void refreshRecipes() {
        ComparableItemStackSafe comparableItemStackSafe;
        RecipeTransposer recipeTransposer;
        THashMap tHashMap = new THashMap(recipeMapFill.size());
        THashMap tHashMap2 = new THashMap(recipeMapExtraction.size());
        THashSet tHashSet = new THashSet();
        for (Map.Entry<List, RecipeTransposer> entry : recipeMapFill.entrySet()) {
            recipeTransposer = entry.getValue();
            comparableItemStackSafe = new ComparableItemStackSafe(recipeTransposer.input);
            FluidStack fluidStack = recipeTransposer.fluid.copy();
            tHashMap.put(Arrays.asList(comparableItemStackSafe.hashCode(), fluidStack.fluidID), recipeTransposer);
            tHashSet.add(comparableItemStackSafe);
        }
        for (Map.Entry<List, RecipeTransposer> entry : recipeMapExtraction.entrySet()) {
            recipeTransposer = entry.getValue();
            comparableItemStackSafe = new ComparableItemStackSafe(recipeTransposer.input);
            tHashMap2.put(comparableItemStackSafe, recipeTransposer);
            tHashSet.add(comparableItemStackSafe);
        }
        recipeMapFill.clear();
        recipeMapFill = tHashMap;
        recipeMapExtraction.clear();
        recipeMapExtraction = tHashMap2;
        validationSet.clear();
        validationSet = tHashSet;
    }

    public static boolean addTEFillRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, boolean bl) {
        if (itemStack == null || itemStack2 == null || fluidStack == null || fluidStack.amount <= 0 || n <= 0) {
            return false;
        }
        RecipeTransposer recipeTransposer = new RecipeTransposer(itemStack, itemStack2, fluidStack, n, 100);
        ComparableItemStackSafe comparableItemStackSafe = new ComparableItemStackSafe(itemStack);
        recipeMapFill.put(Arrays.asList(comparableItemStackSafe.hashCode(), fluidStack.fluidID), recipeTransposer);
        validationSet.add(comparableItemStackSafe);
        if (bl) {
            TransposerManager.addTEExtractionRecipe(n, itemStack2, itemStack, fluidStack, 100, false);
        }
        return true;
    }

    public static boolean addTEExtractionRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n2, boolean bl) {
        if (itemStack == null || fluidStack == null || fluidStack.amount <= 0 || n <= 0) {
            return false;
        }
        if (itemStack2 == null && bl) {
            return false;
        }
        if (itemStack2 == null && n2 != 0) {
            return false;
        }
        RecipeTransposer recipeTransposer = new RecipeTransposer(itemStack, itemStack2, fluidStack, n, n2);
        ComparableItemStackSafe comparableItemStackSafe = new ComparableItemStackSafe(itemStack);
        recipeMapExtraction.put(comparableItemStackSafe, recipeTransposer);
        validationSet.add(comparableItemStackSafe);
        if (bl) {
            TransposerManager.addTEFillRecipe(n, itemStack2, itemStack, fluidStack, false);
        }
        return true;
    }

    public static boolean addFillRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, boolean bl, boolean bl2) {
        if (itemStack == null || itemStack2 == null || fluidStack == null || fluidStack.amount <= 0 || n <= 0 || !(allowOverwrite & bl2) && TransposerManager.fillRecipeExists(itemStack, fluidStack)) {
            return false;
        }
        RecipeTransposer recipeTransposer = new RecipeTransposer(itemStack, itemStack2, fluidStack, n, 100);
        recipeMapFill.put(Arrays.asList(new ComparableItemStackSafe(itemStack).hashCode(), fluidStack.fluidID), recipeTransposer);
        validationSet.add(new ComparableItemStackSafe(itemStack));
        if (bl) {
            TransposerManager.addExtractionRecipe(n, itemStack2, itemStack, fluidStack, 100, false, bl2);
        }
        return true;
    }

    public static boolean addExtractionRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n2, boolean bl, boolean bl2) {
        if (itemStack == null || fluidStack == null || fluidStack.amount <= 0 || n <= 0 || !bl2 && TransposerManager.extractionRecipeExists(itemStack, fluidStack)) {
            return false;
        }
        if (itemStack2 == null && bl || itemStack2 == null && n2 != 0) {
            return false;
        }
        RecipeTransposer recipeTransposer = new RecipeTransposer(itemStack, itemStack2, fluidStack, n, n2);
        recipeMapExtraction.put(new ComparableItemStackSafe(itemStack), recipeTransposer);
        validationSet.add(new ComparableItemStackSafe(itemStack));
        if (bl) {
            TransposerManager.addFillRecipe(n, itemStack2, itemStack, fluidStack, false, bl2);
        }
        return true;
    }

    public static boolean addFillRecipe(int n, FluidContainerRegistry.FluidContainerData fluidContainerData, boolean bl) {
        return TransposerManager.addFillRecipe(n, fluidContainerData.emptyContainer, fluidContainerData.filledContainer, fluidContainerData.fluid, bl, false);
    }

    public static boolean addFillRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, boolean bl) {
        return TransposerManager.addFillRecipe(n, itemStack, itemStack2, fluidStack, bl, false);
    }

    public static boolean addExtractionRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n2, boolean bl) {
        return TransposerManager.addExtractionRecipe(n, itemStack, itemStack2, fluidStack, n2, bl, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("tweak.crafting", "Transposer.AllowRecipeOverwrite", false);
    }

    public static class RecipeTransposer {
        final ItemStack input;
        final ItemStack output;
        final FluidStack fluid;
        final int energy;
        final int chance;

        RecipeTransposer(ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n, int n2) {
            this.input = itemStack;
            this.output = itemStack2;
            this.fluid = fluidStack;
            this.energy = n;
            this.chance = n2;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public ItemStack getOutput() {
            if (this.output != null) {
                return this.output.func_77946_l();
            }
            return null;
        }

        public FluidStack getFluid() {
            return this.fluid.copy();
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getChance() {
            return this.chance;
        }
    }
}

