/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion;

import cofh.CoFHCore;
import cofh.core.CoFHProps;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.ConfigHandler;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.StringHelper;
import cofh.mod.BaseMod;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.UpdateManager;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.cell.BlockCell;
import thermalexpansion.block.cell.TileCell;
import thermalexpansion.block.device.TileActivator;
import thermalexpansion.block.device.TileBreaker;
import thermalexpansion.block.device.TileNullifier;
import thermalexpansion.block.device.TileWorkbench;
import thermalexpansion.block.dynamo.TileDynamoBase;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.block.strongbox.TileStrongbox;
import thermalexpansion.core.Proxy;
import thermalexpansion.core.TEProps;
import thermalexpansion.gui.CreativeTabBlocks;
import thermalexpansion.gui.CreativeTabFlorbs;
import thermalexpansion.gui.CreativeTabItems;
import thermalexpansion.gui.CreativeTabTools;
import thermalexpansion.gui.GuiHandler;
import thermalexpansion.item.ItemSatchel;
import thermalexpansion.item.TEItems;
import thermalexpansion.network.PacketTEBase;
import thermalexpansion.plugins.TEPlugins;
import thermalexpansion.util.FMLEventHandler;
import thermalexpansion.util.FuelHandler;
import thermalexpansion.util.IMCHandler;
import thermalexpansion.util.crafting.CrucibleManager;
import thermalexpansion.util.crafting.ExtruderManager;
import thermalexpansion.util.crafting.FurnaceManager;
import thermalexpansion.util.crafting.PrecipitatorManager;
import thermalexpansion.util.crafting.PulverizerManager;
import thermalexpansion.util.crafting.RecipeMachine;
import thermalexpansion.util.crafting.RecipeMachineUpgrade;
import thermalexpansion.util.crafting.SawmillManager;
import thermalexpansion.util.crafting.SmelterManager;
import thermalexpansion.util.crafting.TECraftingHandler;
import thermalexpansion.util.crafting.TransposerManager;

@Mod(modid="ThermalExpansion", name="Thermal Expansion", version="1.7.10R4.0.0B8", dependencies="required-after:ThermalFoundation@[1.7.10R1.0.0RC1,)", guiFactory="thermalexpansion.gui.GuiConfigTEFactory", customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})
public class ThermalExpansion
extends BaseMod {
    public static final String modId = "ThermalExpansion";
    public static final String modName = "Thermal Expansion";
    public static final String version = "1.7.10R4.0.0B8";
    public static final String dependencies = "required-after:ThermalFoundation@[1.7.10R1.0.0RC1,)";
    public static final String releaseURL = "https://raw.github.com/CoFH/ThermalExpansion/master/VERSION";
    public static final String modGuiFactory = "thermalexpansion.gui.GuiConfigTEFactory";
    @Mod.Instance(value="ThermalExpansion")
    public static ThermalExpansion instance;
    @SidedProxy(clientSide="thermalexpansion.core.ProxyClient", serverSide="thermalexpansion.core.Proxy")
    public static Proxy proxy;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final GuiHandler guiHandler;
    public static final CreativeTabs tabBlocks;
    public static final CreativeTabs tabItems;
    public static final CreativeTabs tabTools;
    public static final CreativeTabs tabFlorbs;
    public static File worldGen;
    public static final String worldGenInternal = "assets/thermalexpansion/world/ThermalExpansion-Ores.json";

    public ThermalExpansion() {
        super(log);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        UpdateManager.registerUpdater((UpdateManager)new UpdateManager((IUpdatableMod)this, releaseURL));
        config.setConfiguration(new Configuration(new File(fMLPreInitializationEvent.getModConfigurationDirectory(), "cofh/ThermalExpansion.cfg")));
        FMLEventHandler.initialize();
        TECraftingHandler.initialize();
        RecipeSorter.register((String)"thermalexpansion:machine", RecipeMachine.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:cofh:upgrade");
        RecipeSorter.register((String)"thermalexpansion:machineUpgrade", RecipeMachineUpgrade.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:cofh:upgrade");
        this.cleanConfig(true);
        TEItems.preInit();
        TEBlocks.preInit();
        TEPlugins.preInit();
        this.configOptions();
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent fMLInitializationEvent) {
        TEItems.initialize();
        TEBlocks.initialize();
        TEPlugins.initialize();
        if (TEProps.enableAchievements) {
            // empty if block
        }
        this.loadWorldGeneration();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        PacketTEBase.initialize();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        FurnaceManager.addDefaultRecipes();
        PulverizerManager.addDefaultRecipes();
        SawmillManager.addDefaultRecipes();
        SmelterManager.addDefaultRecipes();
        CrucibleManager.addDefaultRecipes();
        TransposerManager.addDefaultRecipes();
        PrecipitatorManager.addDefaultRecipes();
        ExtruderManager.addDefaultRecipes();
        TEItems.postInit();
        TEBlocks.postInit();
        TEPlugins.postInit();
        proxy.registerEntities();
        proxy.registerRenderInformation();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent fMLLoadCompleteEvent) {
        IMCHandler.instance.handleIMC((List<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)((Object)this)));
        TECraftingHandler.loadRecipes();
        FurnaceManager.loadRecipes();
        PulverizerManager.loadRecipes();
        SawmillManager.loadRecipes();
        SmelterManager.loadRecipes();
        CrucibleManager.loadRecipes();
        TransposerManager.loadRecipes();
        PrecipitatorManager.loadRecipes();
        ExtruderManager.loadRecipes();
        FuelHandler.parseFuels();
        this.cleanConfig(false);
        config.cleanUp(false, true);
        log.info("Load Complete.");
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent iMCEvent) {
        IMCHandler.instance.handleIMC((List<FMLInterModComms.IMCMessage>)iMCEvent.getMessages());
    }

    public void handleConfigSync(PacketCoFHBase packetCoFHBase) {
        FMLEventHandler.instance.handleIdMappingEvent(null);
        TileCell.enableSecurity = packetCoFHBase.getBool();
        TileWorkbench.enableSecurity = packetCoFHBase.getBool();
        TileActivator.enableSecurity = packetCoFHBase.getBool();
        TileBreaker.enableSecurity = packetCoFHBase.getBool();
        TileNullifier.enableSecurity = packetCoFHBase.getBool();
        TileDynamoBase.enableSecurity = packetCoFHBase.getBool();
        for (int i = 0; i < TileMachineBase.enableSecurity.length; ++i) {
            TileMachineBase.enableSecurity[i] = packetCoFHBase.getBool();
        }
        TileStrongbox.enableSecurity = packetCoFHBase.getBool();
        ItemSatchel.enableSecurity = packetCoFHBase.getBool();
        log.info("Receiving Server Configuration...");
    }

    public PacketCoFHBase getConfigSync() {
        PacketCoFHBase packetCoFHBase = PacketTEBase.getPacket(PacketTEBase.PacketTypes.CONFIG_SYNC);
        packetCoFHBase.addBool(TileCell.enableSecurity);
        packetCoFHBase.addBool(TileWorkbench.enableSecurity);
        packetCoFHBase.addBool(TileActivator.enableSecurity);
        packetCoFHBase.addBool(TileBreaker.enableSecurity);
        packetCoFHBase.addBool(TileNullifier.enableSecurity);
        packetCoFHBase.addBool(TileDynamoBase.enableSecurity);
        for (int i = 0; i < TileMachineBase.enableSecurity.length; ++i) {
            packetCoFHBase.addBool(TileMachineBase.enableSecurity[i]);
        }
        packetCoFHBase.addBool(TileStrongbox.enableSecurity);
        packetCoFHBase.addBool(ItemSatchel.enableSecurity);
        return packetCoFHBase;
    }

    public void resetClientConfigs() {
        TileCell.configure();
        TileWorkbench.configure();
        TileActivator.configure();
        TileBreaker.configure();
        TileNullifier.configure();
        TileDynamoBase.configure();
        TileMachineBase.configure();
        TileStrongbox.configure();
        ItemSatchel.configure();
        FMLEventHandler.instance.handleIdMappingEvent(null);
        log.info(StringHelper.localize((String)"Restoring Client Configuration..."));
    }

    void loadWorldGeneration() {
        if (!config.get("world", "GenerateDefaultFiles", true, "If enabled, Thermal Expansion will create default world generation files - if it cannot find existing ones. Only disable this if you know what you are doing.")) {
            return;
        }
        worldGen = new File(CoFHProps.configDir, "/cofh/world/ThermalExpansion-Ores.json");
        if (!worldGen.exists()) {
            try {
                worldGen.createNewFile();
                CoreUtils.copyFileUsingStream((String)worldGenInternal, (File)worldGen);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    void configOptions() {
        boolean bl = false;
        boolean bl2 = true;
        String string = "general";
        String string2 = null;
        TEProps.enableDebugOutput = config.get(string, "EnableDebugOutput", TEProps.enableDebugOutput);
        bl = CoFHCore.configClient.get(string, "ColorBlindTextures", false);
        bl2 = CoFHCore.configClient.get(string, "DrawGUISlotBorders", true);
        string = "holiday";
        string2 = "Set this to true to disable Christmas cheer. Scrooge. :(";
        boolean bl3 = TEProps.holidayChristmas = !config.get(string, "HoHoNo", false, string2);
        if (bl) {
            TEProps.textureGuiCommon = TEProps.PATH_COMMON_CB;
            TEProps.textureGuiAssembler = TEProps.PATH_ASSEMBLER_CB;
            TEProps.textureSelection = "Config_CB_";
            BlockCell.textureSelection = "CellConfig_CB_";
        }
        TEProps.enableGuiBorders = bl2;
    }

    void cleanConfig(boolean bl) {
        if (bl) {
            // empty if block
        }
        String string = "config.thermalexpansion.";
        String[] stringArray = config.getCategoryNames().toArray(new String[config.getCategoryNames().size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            config.getCategory(stringArray[i]).setLanguageKey(string + stringArray[i]).setRequiresMcRestart(true);
        }
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModVersion() {
        return version;
    }

    static {
        log = LogManager.getLogger((String)modId);
        config = new ConfigHandler(version);
        guiHandler = new GuiHandler();
        tabBlocks = new CreativeTabBlocks();
        tabItems = new CreativeTabItems();
        tabTools = new CreativeTabTools();
        tabFlorbs = new CreativeTabFlorbs();
    }
}

