/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.cell;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.RedstoneControlHelper;
import cofh.lib.util.helpers.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileReconfigurable;
import thermalexpansion.block.cell.BlockCell;
import thermalexpansion.gui.client.GuiCell;
import thermalexpansion.gui.container.ContainerTEBase;
import thermalexpansion.util.ReconfigurableHelper;

public class TileCell
extends TileReconfigurable
implements IEnergyHandler {
    public static boolean enableSecurity = true;
    public static int[] MAX_SEND = new int[]{20000, 80, 400, 2000, 10000};
    public static int[] MAX_RECEIVE = new int[]{20000, 80, 400, 2000, 10000};
    public static int[] STORAGE = new int[]{20000, 400000, 2000000, 10000000, 50000000};
    public static final byte[] DEFAULT_SIDES = new byte[]{1, 2, 2, 2, 2, 2};
    int compareTracker;
    byte meterTracker;
    byte outputTracker;
    boolean cached = false;
    IEnergyReceiver[] adjacentHandlers = new IEnergyReceiver[6];
    public int energyReceive;
    public int energySend;
    public byte type;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileCell.class, (String)"thermalexpansion.Cell");
        TileCell.configure();
    }

    public static void configure() {
        String string = "Enable this to allow for Energy Cells to be securable. (Default: true)";
        enableSecurity = ThermalExpansion.config.get("security", "Cell.All.Securable", enableSecurity, string);
    }

    public TileCell() {
        this.energyStorage = new EnergyStorage(STORAGE[1], MAX_RECEIVE[1]);
    }

    public TileCell(int n) {
        this.energyStorage = new EnergyStorage(STORAGE[n], MAX_RECEIVE[n]);
        this.type = (byte)n;
    }

    public String getName() {
        return "tile.thermalexpansion.cell." + BlockCell.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return this.type;
    }

    public int getComparatorInput(int n) {
        return this.compareTracker;
    }

    public int getLightValue() {
        return Math.min(8, this.getScaledEnergyStored(9));
    }

    @Override
    public byte[] getDefaultSides() {
        return (byte[])DEFAULT_SIDES.clone();
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers();
    }

    public void onNeighborTileChange(int n, int n2, int n3) {
        super.onNeighborTileChange(n, n2, n3);
        this.updateAdjacentHandler(n, n2, n3);
    }

    public void func_145845_h() {
        int n;
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        if (!this.cached) {
            this.onNeighborBlockChange();
        }
        if (this.redstoneControlOrDisable()) {
            for (n = this.outputTracker; n < 6 && this.energyStorage.getEnergyStored() > 0; ++n) {
                this.transferEnergy(n);
            }
            for (n = 0; n < this.outputTracker && this.energyStorage.getEnergyStored() > 0; ++n) {
                this.transferEnergy(n);
            }
            this.outputTracker = (byte)(this.outputTracker + 1);
            this.outputTracker = (byte)(this.outputTracker % 6);
        }
        if (this.timeCheck()) {
            n = this.getScaledEnergyStored(15);
            if (this.compareTracker != n) {
                this.compareTracker = n;
                this.callNeighborTileChange();
            }
            if (this.meterTracker != (n = this.getLightValue())) {
                this.meterTracker = (byte)n;
                this.sendUpdatePacket(Side.CLIENT);
            }
        }
    }

    public void func_145843_s() {
        this.cached = false;
        super.func_145843_s();
    }

    protected void transferEnergy(int n) {
        if (this.sideCache[n] != 1) {
            return;
        }
        if (this.adjacentHandlers[n] == null) {
            return;
        }
        this.energyStorage.modifyEnergyStored(-this.adjacentHandlers[n].receiveEnergy(ForgeDirection.VALID_DIRECTIONS[n ^ 1], Math.min(this.energySend, this.energyStorage.getEnergyStored()), false));
    }

    protected void updateAdjacentHandlers() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)i);
            this.adjacentHandlers[i] = EnergyHelper.isEnergyReceiverFromSide((TileEntity)tileEntity, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[i ^ 1]) ? (IEnergyReceiver)tileEntity : null;
        }
        this.cached = true;
    }

    protected void updateAdjacentHandler(int n, int n2, int n3) {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        int n4 = BlockHelper.determineAdjacentSide((TileEntity)this, (int)n, (int)n2, (int)n3);
        TileEntity tileEntity = ((TileEntity)this).field_145850_b.func_147438_o(n, n2, n3);
        this.adjacentHandlers[n4] = EnergyHelper.isEnergyReceiverFromSide((TileEntity)tileEntity, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[n4 ^ 1]) ? (IEnergyReceiver)tileEntity : null;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiCell(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.type = nBTTagCompound.func_74771_c("Type");
        this.outputTracker = nBTTagCompound.func_74771_c("Tracker");
        this.energySend = MathHelper.clampI((int)nBTTagCompound.func_74762_e("Send"), (int)0, (int)MAX_SEND[this.type]);
        this.energyReceive = MathHelper.clampI((int)nBTTagCompound.func_74762_e("Recv"), (int)0, (int)MAX_RECEIVE[this.type]);
        this.energyStorage = new EnergyStorage(STORAGE[this.type], MAX_RECEIVE[this.type]);
        this.energyStorage.readFromNBT(nBTTagCompound);
        this.meterTracker = (byte)Math.min(8, this.getScaledEnergyStored(9));
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Type", this.type);
        nBTTagCompound.func_74774_a("Tracker", this.outputTracker);
        nBTTagCompound.func_74768_a("Send", this.energySend);
        nBTTagCompound.func_74768_a("Recv", this.energyReceive);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addInt(this.energySend);
        packetCoFHBase.addInt(this.energyReceive);
        packetCoFHBase.addInt(this.energyStorage.getEnergyStored());
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addInt(this.energySend);
        packetCoFHBase.addInt(this.energyReceive);
        packetCoFHBase.addInt(this.energyStorage.getEnergyStored());
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addInt(MathHelper.clampI((int)this.energySend, (int)0, (int)MAX_SEND[this.getType()]));
        packetCoFHBase.addInt(MathHelper.clampI((int)this.energyReceive, (int)0, (int)MAX_RECEIVE[this.getType()]));
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.energySend = packetCoFHBase.getInt();
        this.energyReceive = packetCoFHBase.getInt();
        this.energyStorage.setEnergyStored(packetCoFHBase.getInt());
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        this.energySend = packetCoFHBase.getInt();
        this.energyReceive = packetCoFHBase.getInt();
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.energySend = packetCoFHBase.getInt();
            this.energyReceive = packetCoFHBase.getInt();
        } else {
            packetCoFHBase.getInt();
            packetCoFHBase.getInt();
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        if (forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] == 2) {
            return this.energyStorage.receiveEnergy(Math.min(n, this.energyReceive), bl);
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        if (forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] == 1) {
            return this.energyStorage.extractEnergy(Math.min(n, this.energySend), bl);
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.sideCache[forgeDirection.ordinal()] > 0;
    }

    @Override
    public String getDataType() {
        return "tile.thermalexpansion.cell";
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!this.canPlayerAccess(entityPlayer.func_70005_c_())) {
            return;
        }
        this.rsMode = RedstoneControlHelper.getControlFromNBT((NBTTagCompound)nBTTagCompound);
        byte by = ReconfigurableHelper.getFacingFromNBT(nBTTagCompound);
        byte[] byArray = ReconfigurableHelper.getSideCacheFromNBT(nBTTagCompound, this.getDefaultSides());
        this.sideCache[0] = byArray[0];
        this.sideCache[1] = byArray[1];
        this.sideCache[this.facing] = byArray[by];
        this.sideCache[BlockHelper.getLeftSide((int)this.facing)] = byArray[BlockHelper.getLeftSide((int)by)];
        this.sideCache[BlockHelper.getRightSide((int)this.facing)] = byArray[BlockHelper.getRightSide((int)by)];
        this.sideCache[BlockHelper.getOppositeSide((int)this.facing)] = byArray[BlockHelper.getOppositeSide((int)by)];
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] < this.getNumConfig(i)) continue;
            this.sideCache[i] = 0;
        }
        this.energySend = nBTTagCompound.func_74762_e("Send") * MAX_SEND[this.getType()] / 1000;
        this.energyReceive = nBTTagCompound.func_74762_e("Recv") * MAX_RECEIVE[this.getType()] / 1000;
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!this.canPlayerAccess(entityPlayer.func_70005_c_())) {
            return;
        }
        RedstoneControlHelper.setItemStackTagRS((NBTTagCompound)nBTTagCompound, (IRedstoneControl)this);
        ReconfigurableHelper.setItemStackTagReconfig(nBTTagCompound, this);
        nBTTagCompound.func_74768_a("Send", this.energySend * 1000 / MAX_SEND[this.getType()]);
        nBTTagCompound.func_74768_a("Recv", this.energyReceive * 1000 / MAX_RECEIVE[this.getType()]);
    }

    @Override
    public boolean allowYAxisFacing() {
        return false;
    }

    @Override
    public boolean rotateBlock() {
        super.rotateBlock();
        this.updateAdjacentHandlers();
        return true;
    }

    @Override
    public final boolean decrSide(int n) {
        int n2 = n;
        this.sideCache[n2] = (byte)(this.sideCache[n2] + (this.getNumConfig(n) - 1));
        int n3 = n;
        this.sideCache[n3] = (byte)(this.sideCache[n3] % this.getNumConfig(n));
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    @Override
    public final boolean incrSide(int n) {
        int n2 = n;
        this.sideCache[n2] = (byte)(this.sideCache[n2] + 1);
        int n3 = n;
        this.sideCache[n3] = (byte)(this.sideCache[n3] % this.getNumConfig(n));
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    @Override
    public int getNumConfig(int n) {
        return 3;
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 0) {
            return this.type < 2 ? IconRegistry.getIcon((String)"StorageRedstone") : IconRegistry.getIcon((String)"FluidRedstone");
        }
        if (n2 == 1) {
            return IconRegistry.getIcon((String)"Cell", (int)(this.type * 2));
        }
        if (n2 == 2) {
            return IconRegistry.getIcon((String)BlockCell.textureSelection, (int)this.sideCache[n]);
        }
        if (n != this.facing) {
            return IconRegistry.getIcon((String)BlockCell.textureSelection, (int)0);
        }
        int n3 = Math.min(8, this.getScaledEnergyStored(9));
        return IconRegistry.getIcon((String)"CellMeter", (int)n3);
    }

    static {
        String string = "block.tweak";
        TileCell.STORAGE[4] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Resonant.Storage", STORAGE[4]), (int)(STORAGE[4] / 10), (int)1000000000);
        TileCell.STORAGE[3] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Reinforced.Storage", STORAGE[3]), (int)(STORAGE[3] / 10), (int)STORAGE[4]);
        TileCell.STORAGE[2] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Hardened.Storage", STORAGE[2]), (int)(STORAGE[2] / 10), (int)STORAGE[3]);
        TileCell.STORAGE[1] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Basic.Storage", STORAGE[1]), (int)(STORAGE[1] / 10), (int)STORAGE[2]);
        TileCell.MAX_SEND[4] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Resonant.MaxSend", MAX_SEND[4]), (int)(MAX_SEND[4] / 10), (int)(MAX_SEND[4] * 1000));
        TileCell.MAX_SEND[3] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Reinforced.MaxSend", MAX_SEND[3]), (int)(MAX_SEND[3] / 10), (int)(MAX_SEND[3] * 1000));
        TileCell.MAX_SEND[2] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Hardened.MaxSend", MAX_SEND[2]), (int)(MAX_SEND[2] / 10), (int)(MAX_SEND[2] * 1000));
        TileCell.MAX_SEND[1] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Basic.MaxSend", MAX_SEND[1]), (int)(MAX_SEND[1] / 10), (int)(MAX_SEND[1] * 1000));
        TileCell.MAX_RECEIVE[4] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Resonant.MaxReceive", MAX_RECEIVE[4]), (int)(MAX_RECEIVE[4] / 10), (int)(MAX_RECEIVE[4] * 1000));
        TileCell.MAX_RECEIVE[3] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Reinforced.MaxReceive", MAX_RECEIVE[3]), (int)(MAX_RECEIVE[3] / 10), (int)(MAX_RECEIVE[3] * 1000));
        TileCell.MAX_RECEIVE[2] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Hardened.MaxReceive", MAX_RECEIVE[2]), (int)(MAX_RECEIVE[2] / 10), (int)(MAX_RECEIVE[2] * 1000));
        TileCell.MAX_RECEIVE[1] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Basic.MaxReceive", MAX_RECEIVE[1]), (int)(MAX_RECEIVE[1] / 10), (int)(MAX_RECEIVE[1] * 1000));
        TileCell.MAX_SEND[0] = MathHelper.clampI((int)ThermalExpansion.config.get(string, "Cell.Creative.MaxValue", MAX_SEND[0]), (int)(MAX_SEND[0] / 10), (int)(MAX_SEND[0] * 1000));
        TileCell.MAX_RECEIVE[0] = MAX_SEND[0];
        TileCell.STORAGE[0] = MAX_SEND[0];
    }
}

