/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.dynamo;

import cofh.core.network.PacketCoFHBase;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.dynamo.BlockDynamo;
import thermalexpansion.block.dynamo.TileDynamoBase;
import thermalexpansion.gui.client.dynamo.GuiDynamoCompression;
import thermalexpansion.gui.container.ContainerTEBase;

public class TileDynamoCompression
extends TileDynamoBase
implements IFluidHandler {
    static final int TYPE = BlockDynamo.Types.COMPRESSION.ordinal();
    static TObjectIntHashMap<Fluid> fuels = new TObjectIntHashMap();
    static TObjectIntHashMap<Fluid> coolants = new TObjectIntHashMap();
    FluidTankAdv fuelTank = new FluidTankAdv(4000);
    FluidTankAdv coolantTank = new FluidTankAdv(4000);
    FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
    int coolantRF;

    public static void initialize() {
        int n = MathHelper.clampI((int)ThermalExpansion.config.get("block.tweak", "Dynamo.Compression.BasePower", 80), (int)10, (int)160);
        ThermalExpansion.config.set("block.tweak", "Dynamo.Compression.BasePower", n);
        n /= 10;
        TileDynamoBase.defaultEnergyConfig[TileDynamoCompression.TYPE] = new TileTEBase.EnergyConfig();
        TileDynamoBase.defaultEnergyConfig[TYPE].setParamsDefault(n *= 10);
        GameRegistry.registerTileEntity(TileDynamoCompression.class, (String)"thermalexpansion.DynamoCompression");
    }

    public static int getCoolantEnergy(FluidStack fluidStack) {
        return fluidStack == null ? 0 : coolants.get((Object)fluidStack.getFluid());
    }

    public static int getFuelEnergy(FluidStack fluidStack) {
        return fluidStack == null ? 0 : fuels.get((Object)fluidStack.getFluid());
    }

    public static boolean isValidCoolant(FluidStack fluidStack) {
        return fluidStack == null ? false : coolants.containsKey((Object)fluidStack.getFluid());
    }

    public static boolean isValidFuel(FluidStack fluidStack) {
        return fluidStack == null ? false : fuels.containsKey((Object)fluidStack.getFluid());
    }

    public static boolean registerCoolant(Fluid fluid, int n) {
        if (fluid == null || n < 10000) {
            return false;
        }
        coolants.put((Object)fluid, n / 20);
        return true;
    }

    public static boolean registerFuel(Fluid fluid, int n) {
        if (fluid == null || n < 10000) {
            return false;
        }
        fuels.put((Object)fluid, n / 20);
        return true;
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canGenerate() {
        if (this.fuelRF > 0) {
            return this.coolantRF > 0 || this.coolantTank.getFluidAmount() >= 50;
        }
        if (this.coolantRF > 0) {
            return this.fuelTank.getFluidAmount() >= 50;
        }
        return this.fuelTank.getFluidAmount() >= 50 && this.coolantTank.getFluidAmount() >= 50;
    }

    @Override
    protected void generate() {
        if (this.fuelRF <= 0) {
            this.fuelRF = TileDynamoCompression.getFuelEnergy(this.fuelTank.getFluid()) * this.fuelMod / 1000;
            this.fuelTank.drain(50, true);
        }
        if (this.coolantRF <= 0) {
            this.coolantRF = TileDynamoCompression.getCoolantEnergy(this.coolantTank.getFluid()) * this.fuelMod / 1000;
            this.coolantTank.drain(50, true);
        }
        int n = this.calcEnergy() * this.energyMod;
        this.energyStorage.modifyEnergyStored(n);
        this.fuelRF -= n;
        this.coolantRF -= n;
    }

    @Override
    public IIcon getActiveIcon() {
        return this.renderFluid.getFluid().getIcon(this.renderFluid);
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiDynamoCompression(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public FluidTankAdv getTank(int n) {
        if (n == 0) {
            return this.fuelTank;
        }
        return this.coolantTank;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.coolantRF = nBTTagCompound.func_74762_e("Coolant");
        this.fuelTank.readFromNBT(nBTTagCompound.func_74775_l("FuelTank"));
        this.coolantTank.readFromNBT(nBTTagCompound.func_74775_l("CoolantTank"));
        if (!TileDynamoCompression.isValidFuel(this.fuelTank.getFluid())) {
            this.fuelTank.setFluid(null);
        }
        if (!TileDynamoCompression.isValidCoolant(this.coolantTank.getFluid())) {
            this.coolantTank.setFluid(null);
        }
        if (this.fuelTank.getFluid() != null) {
            this.renderFluid = this.fuelTank.getFluid();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Coolant", this.coolantRF);
        nBTTagCompound.func_74782_a("FuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        nBTTagCompound.func_74782_a("CoolantTank", (NBTBase)this.coolantTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addFluidStack(this.fuelTank.getFluid());
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addFluidStack(this.fuelTank.getFluid());
        packetCoFHBase.addFluidStack(this.coolantTank.getFluid());
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.fuelTank.setFluid(packetCoFHBase.getFluidStack());
        this.coolantTank.setFluid(packetCoFHBase.getFluidStack());
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.renderFluid = packetCoFHBase.getFluidStack();
        if (this.renderFluid == null) {
            this.renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
        }
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || forgeDirection.ordinal() == this.facing && !this.augmentCoilDuct) {
            return 0;
        }
        if (TileDynamoCompression.isValidFuel(fluidStack)) {
            return this.fuelTank.fill(fluidStack, bl);
        }
        if (TileDynamoCompression.isValidCoolant(fluidStack)) {
            return this.coolantTank.fill(fluidStack, bl);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || !this.augmentCoilDuct) {
            return null;
        }
        if (TileDynamoCompression.isValidFuel(fluidStack)) {
            return this.fuelTank.drain(fluidStack.amount, bl);
        }
        if (TileDynamoCompression.isValidCoolant(fluidStack)) {
            return this.coolantTank.drain(fluidStack.amount, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (!this.augmentCoilDuct) {
            return null;
        }
        return this.fuelTank.drain(n, bl);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.fuelTank.getInfo(), this.coolantTank.getInfo()};
    }
}

