/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.api.core.ICustomInventory;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.gui.client.machine.GuiPrecipitator;
import thermalexpansion.gui.container.machine.ContainerPrecipitator;

public class TilePrecipitator
extends TileMachineBase
implements ICustomInventory,
IFluidHandler {
    static final int TYPE = BlockMachine.Types.PRECIPITATOR.ordinal();
    static int[] processWater = new int[]{500, 500, 1000};
    static int[] processEnergy = new int[]{800, 800, 1600};
    static ItemStack[] processItems = new ItemStack[3];
    int outputTracker;
    byte curSelection;
    byte prevSelection;
    FluidStack renderFluid = new FluidStack(FluidRegistry.WATER, 0);
    FluidTankAdv tank = new FluidTankAdv(4000);

    public static void initialize() {
        TilePrecipitator.processItems[0] = new ItemStack(Items.field_151126_ay, 4, 0);
        TilePrecipitator.processItems[1] = new ItemStack(Blocks.field_150433_aE);
        TilePrecipitator.processItems[2] = new ItemStack(Blocks.field_150432_aD);
        TileMachineBase.defaultSideConfig[TilePrecipitator.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TilePrecipitator.TYPE].numGroup = 3;
        TileMachineBase.defaultSideConfig[TilePrecipitator.TYPE].slotGroups = new int[][]{new int[0], new int[0], {0}};
        TileMachineBase.defaultSideConfig[TilePrecipitator.TYPE].allowInsertion = new boolean[]{false, true, false};
        TileMachineBase.defaultSideConfig[TilePrecipitator.TYPE].allowExtraction = new boolean[]{false, false, true};
        TileMachineBase.defaultSideConfig[TilePrecipitator.TYPE].sideTex = new int[]{0, 1, 4};
        TileMachineBase.defaultSideConfig[TilePrecipitator.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        int n = MathHelper.clampI((int)ThermalExpansion.config.get("block.tweak", "Machine.Precipitator.BasePower", 20), (int)10, (int)500);
        ThermalExpansion.config.set("block.tweak", "Machine.Precipitator.BasePower", n);
        TileMachineBase.defaultEnergyConfig[TilePrecipitator.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParamsPower(n);
        GameRegistry.registerTileEntity(TilePrecipitator.class, (String)"thermalexpansion.Precipitator");
    }

    public TilePrecipitator() {
        this.inventory = new ItemStack[2];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.energyStorage.getEnergyStored() < processEnergy[this.curSelection] || this.tank.getFluidAmount() < processWater[this.curSelection]) {
            return false;
        }
        if (this.inventory[0] == null) {
            return true;
        }
        if (!this.inventory[0].func_77969_a(processItems[this.curSelection])) {
            return false;
        }
        return this.inventory[0].field_77994_a + TilePrecipitator.processItems[this.curSelection].field_77994_a <= processItems[this.prevSelection].func_77976_d();
    }

    @Override
    protected boolean canFinish() {
        return this.processRem <= 0;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = processEnergy[this.curSelection];
        this.prevSelection = this.curSelection;
    }

    @Override
    protected void processFinish() {
        if (this.inventory[0] == null) {
            this.inventory[0] = processItems[this.prevSelection].func_77946_l();
        } else {
            this.inventory[0].field_77994_a += TilePrecipitator.processItems[this.prevSelection].field_77994_a;
        }
        this.tank.drain(processWater[this.prevSelection], true);
        this.prevSelection = this.curSelection;
    }

    @Override
    protected void transferProducts() {
        if (!this.augmentAutoTransfer) {
            return;
        }
        if (this.inventory[0] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 2 || !this.transferItem(0, 4, n)) continue;
            this.outputTracker = n;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiPrecipitator(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerPrecipitator(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public FluidTankAdv getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public int getCurSelection() {
        return this.curSelection;
    }

    public int getPrevSelection() {
        return this.prevSelection;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.outputTracker = nBTTagCompound.func_74762_e("Tracker");
        this.prevSelection = nBTTagCompound.func_74771_c("Prev");
        this.curSelection = nBTTagCompound.func_74771_c("Sel");
        this.tank.readFromNBT(nBTTagCompound);
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Tracker", this.outputTracker);
        nBTTagCompound.func_74774_a("Prev", this.prevSelection);
        nBTTagCompound.func_74774_a("Sel", this.curSelection);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addFluidStack(this.renderFluid);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addByte(this.curSelection);
        packetCoFHBase.addByte(this.prevSelection);
        if (this.tank.getFluid() == null) {
            packetCoFHBase.addFluidStack(this.renderFluid);
        } else {
            packetCoFHBase.addFluidStack(this.tank.getFluid());
        }
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getFluidPacket() {
        PacketCoFHBase packetCoFHBase = super.getFluidPacket();
        packetCoFHBase.addFluidStack(this.renderFluid);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addByte(this.curSelection);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.curSelection = packetCoFHBase.getByte();
        this.prevSelection = packetCoFHBase.getByte();
        this.tank.setFluid(packetCoFHBase.getFluidStack());
    }

    @Override
    protected void handleFluidPacket(PacketCoFHBase packetCoFHBase) {
        super.handleFluidPacket(packetCoFHBase);
        this.renderFluid = packetCoFHBase.getFluidStack();
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        this.curSelection = packetCoFHBase.getByte();
        if (!this.isActive) {
            this.prevSelection = this.curSelection;
        }
    }

    public void setMode(int n) {
        byte by = this.curSelection;
        this.curSelection = (byte)n;
        this.sendModePacket();
        this.curSelection = by;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.renderFluid = packetCoFHBase.getFluidStack();
        } else {
            packetCoFHBase.getFluidStack();
        }
    }

    public ItemStack[] getInventorySlots(int n) {
        return processItems;
    }

    public int getSlotStackLimit(int n) {
        return 64;
    }

    public void onSlotUpdate() {
        this.func_70296_d();
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (forgeDirection != ForgeDirection.UNKNOWN && this.sideCache[forgeDirection.ordinal()] != 1) {
            return 0;
        }
        if (fluidStack.getFluid() != FluidRegistry.WATER) {
            return 0;
        }
        return this.tank.fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

