/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.plate;

import cofh.core.network.PacketCoFHBase;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.plate.BlockPlate;
import thermalexpansion.block.plate.TilePlateBase;

public class TilePlateSignal
extends TilePlateBase {
    byte distance = (byte)16;
    byte intensity = (byte)15;
    byte activationTime = (byte)15;
    byte collided = 0;

    public static void initialize() {
        GameRegistry.registerTileEntity(TilePlateSignal.class, (String)"cofh.thermalexpansion.PlateSignal");
    }

    public TilePlateSignal() {
        super(BlockPlate.Types.SIGNAL);
    }

    public void blockBroken() {
        this.removeSignal();
        super.blockBroken();
    }

    @Override
    public void rotated() {
        this.removeSignal();
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    private void removeSignal() {
        int n;
        int n2;
        int[] nArray = this.getVector(this.distance);
        int n3 = nArray[0];
        if (((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c + n3, ((TileEntity)this).field_145848_d + (n2 = nArray[1]), ((TileEntity)this).field_145849_e + (n = nArray[2])).equals(TEBlocks.blockAirSignal)) {
            ((TileEntity)this).field_145850_b.func_147465_d(((TileEntity)this).field_145851_c + n3, ((TileEntity)this).field_145848_d + n2, ((TileEntity)this).field_145849_e + n, Blocks.field_150350_a, 0, 3);
        }
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    public void func_145845_h() {
        if (this.collided > 0) {
            this.markChunkDirty();
            this.collided = (byte)(this.collided - 1);
            if (this.collided == 0) {
                this.removeSignal();
            }
        }
    }

    @Override
    public void onEntityCollidedWithBlock(Entity entity) {
        int n;
        int n2;
        int[] nArray;
        int n3;
        if (((TileEntity)this).field_145850_b.field_72995_K || !(entity instanceof EntityLivingBase)) {
            return;
        }
        if (this.collided > 0) {
            this.collided = this.activationTime;
            if (((TileEntity)this).field_145850_b.func_82737_E() % 10L != 0L) {
                return;
            }
        }
        if (((TileEntity)this).field_145850_b.func_147437_c(((TileEntity)this).field_145851_c + (n3 = (nArray = this.getVector(this.distance))[0]), ((TileEntity)this).field_145848_d + (n2 = nArray[1]), ((TileEntity)this).field_145849_e + (n = nArray[2]))) {
            if (((TileEntity)this).field_145850_b.func_147465_d(((TileEntity)this).field_145851_c + n3, ((TileEntity)this).field_145848_d + n2, ((TileEntity)this).field_145849_e + n, TEBlocks.blockAirSignal, (int)this.intensity, 3)) {
                this.markChunkDirty();
                ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            }
            this.collided = this.activationTime;
        }
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte(this.distance);
        packetCoFHBase.addByte(this.intensity);
        packetCoFHBase.addByte(this.activationTime);
        packetCoFHBase.addByte(this.collided);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addByte(this.distance);
        packetCoFHBase.addByte(this.intensity);
        packetCoFHBase.addByte(this.activationTime);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.distance = packetCoFHBase.getByte();
        this.intensity = packetCoFHBase.getByte();
        this.activationTime = packetCoFHBase.getByte();
        this.collided = packetCoFHBase.getByte();
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.distance = packetCoFHBase.getByte();
            this.intensity = packetCoFHBase.getByte();
            this.activationTime = packetCoFHBase.getByte();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.distance = nBTTagCompound.func_74771_c("Dist");
        this.intensity = nBTTagCompound.func_74771_c("Int");
        this.activationTime = nBTTagCompound.func_74771_c("Act");
        this.collided = nBTTagCompound.func_74771_c("Col");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Dist", this.distance);
        nBTTagCompound.func_74774_a("Int", this.intensity);
        nBTTagCompound.func_74774_a("Act", this.activationTime);
        nBTTagCompound.func_74774_a("Col", this.collided);
    }
}

