/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion;

import cofh.core.CoFHProps;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.ConfigHandler;
import cofh.lib.util.helpers.StringHelper;
import cofh.mod.BaseMod;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.UpdateManager;
import cofh.thermalexpansion.block.TEBlocks;
import cofh.thermalexpansion.block.cell.BlockCell;
import cofh.thermalexpansion.block.cell.TileCell;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileActivator;
import cofh.thermalexpansion.block.device.TileBreaker;
import cofh.thermalexpansion.block.device.TileNullifier;
import cofh.thermalexpansion.block.device.TileWorkbench;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.block.strongbox.TileStrongbox;
import cofh.thermalexpansion.core.Proxy;
import cofh.thermalexpansion.core.TEAchievements;
import cofh.thermalexpansion.core.TEProps;
import cofh.thermalexpansion.gui.GuiHandler;
import cofh.thermalexpansion.gui.TECreativeTab;
import cofh.thermalexpansion.gui.TECreativeTabFlorbs;
import cofh.thermalexpansion.item.ItemSatchel;
import cofh.thermalexpansion.item.TEItems;
import cofh.thermalexpansion.network.PacketTEBase;
import cofh.thermalexpansion.plugins.TEPlugins;
import cofh.thermalexpansion.plugins.nei.handlers.NEIRecipeWrapper;
import cofh.thermalexpansion.util.FMLEventHandler;
import cofh.thermalexpansion.util.FuelHandler;
import cofh.thermalexpansion.util.IMCHandler;
import cofh.thermalexpansion.util.crafting.ChargerManager;
import cofh.thermalexpansion.util.crafting.CrucibleManager;
import cofh.thermalexpansion.util.crafting.ExtruderManager;
import cofh.thermalexpansion.util.crafting.FurnaceManager;
import cofh.thermalexpansion.util.crafting.InsolatorManager;
import cofh.thermalexpansion.util.crafting.PrecipitatorManager;
import cofh.thermalexpansion.util.crafting.PulverizerManager;
import cofh.thermalexpansion.util.crafting.RecipeMachine;
import cofh.thermalexpansion.util.crafting.RecipeMachineUpgrade;
import cofh.thermalexpansion.util.crafting.RecipeStyle;
import cofh.thermalexpansion.util.crafting.SawmillManager;
import cofh.thermalexpansion.util.crafting.SmelterManager;
import cofh.thermalexpansion.util.crafting.TECraftingHandler;
import cofh.thermalexpansion.util.crafting.TECraftingParser;
import cofh.thermalexpansion.util.crafting.TransposerManager;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ThermalExpansion", name="Thermal Expansion", version="1.7.10R4.0.1", dependencies="required-after:CoFHCore@[1.7.10R3.0.2,);required-after:ThermalFoundation@[1.7.10R1.0.0,)", guiFactory="cofh.thermalexpansion.gui.GuiConfigTEFactory", customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})
public class ThermalExpansion
extends BaseMod {
    public static final String modId = "ThermalExpansion";
    public static final String modName = "Thermal Expansion";
    public static final String version = "1.7.10R4.0.1";
    public static final String dependencies = "required-after:CoFHCore@[1.7.10R3.0.2,);required-after:ThermalFoundation@[1.7.10R1.0.0,)";
    public static final String releaseURL = "https://raw.github.com/CoFH/Version/master/ThermalExpansion";
    public static final String modGuiFactory = "cofh.thermalexpansion.gui.GuiConfigTEFactory";
    @Mod.Instance(value="ThermalExpansion")
    public static ThermalExpansion instance;
    @SidedProxy(clientSide="cofh.thermalexpansion.core.ProxyClient", serverSide="cofh.thermalexpansion.core.Proxy")
    public static Proxy proxy;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final ConfigHandler configClient;
    public static final GuiHandler guiHandler;
    public static CreativeTabs tabCommon;
    public static CreativeTabs tabBlocks;
    public static CreativeTabs tabItems;
    public static CreativeTabs tabTools;
    public static CreativeTabs tabFlorbs;

    public ThermalExpansion() {
        super(log);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        UpdateManager.registerUpdater((UpdateManager)new UpdateManager((IUpdatableMod)this, releaseURL, "http://teamcofh.com/downloads/"));
        config.setConfiguration(new Configuration(new File(fMLPreInitializationEvent.getModConfigurationDirectory(), "cofh/thermalexpansion/common.cfg"), true));
        configClient.setConfiguration(new Configuration(new File(fMLPreInitializationEvent.getModConfigurationDirectory(), "cofh/thermalexpansion/client.cfg"), true));
        FMLEventHandler.initialize();
        TECraftingHandler.initialize();
        TECraftingParser.initialize();
        RecipeSorter.register((String)"thermalexpansion:machine", RecipeMachine.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:cofh:upgrade");
        RecipeSorter.register((String)"thermalexpansion:machineUpgrade", RecipeMachineUpgrade.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:cofh:upgrade");
        RecipeSorter.register((String)"thermalexpansion:style", RecipeStyle.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"thermalexpansion:NEIWrapper", NEIRecipeWrapper.class, (RecipeSorter.Category)RecipeSorter.Category.UNKNOWN, (String)"after:forge:shapedore");
        this.cleanConfig(true);
        this.configOptions();
        TEItems.preInit();
        TEBlocks.preInit();
        TEPlugins.preInit();
        try {
            TECraftingParser.parseCraftingFiles();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent fMLInitializationEvent) {
        TEItems.initialize();
        TEBlocks.initialize();
        TEPlugins.initialize();
        if (TEProps.enableAchievements) {
            TEAchievements.initialize();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        PacketTEBase.initialize();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        FurnaceManager.addDefaultRecipes();
        PulverizerManager.addDefaultRecipes();
        SawmillManager.addDefaultRecipes();
        SmelterManager.addDefaultRecipes();
        CrucibleManager.addDefaultRecipes();
        TransposerManager.addDefaultRecipes();
        PrecipitatorManager.addDefaultRecipes();
        ExtruderManager.addDefaultRecipes();
        ChargerManager.addDefaultRecipes();
        InsolatorManager.addDefaultRecipes();
        TEItems.postInit();
        TEBlocks.postInit();
        TEPlugins.postInit();
        proxy.registerEntities();
        proxy.registerRenderInformation();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent fMLLoadCompleteEvent) {
        IMCHandler.instance.handleIMC((List<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)((Object)this)));
        TECraftingHandler.loadRecipes();
        FurnaceManager.loadRecipes();
        PulverizerManager.loadRecipes();
        SawmillManager.loadRecipes();
        SmelterManager.loadRecipes();
        CrucibleManager.loadRecipes();
        TransposerManager.loadRecipes();
        PrecipitatorManager.loadRecipes();
        ExtruderManager.loadRecipes();
        ChargerManager.loadRecipes();
        InsolatorManager.loadRecipes();
        FuelHandler.parseFuels();
        TEPlugins.loadComplete();
        this.cleanConfig(false);
        config.cleanUp(false, true);
        configClient.cleanUp(false, true);
        log.info("Load Complete.");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartedEvent fMLServerStartedEvent) {
        this.handleIdMapping();
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent iMCEvent) {
        IMCHandler.instance.handleIMC((List<FMLInterModComms.IMCMessage>)iMCEvent.getMessages());
    }

    public void handleConfigSync(PacketCoFHBase packetCoFHBase) {
        this.handleIdMapping();
        TileCell.enableSecurity = packetCoFHBase.getBool();
        TileWorkbench.enableSecurity = packetCoFHBase.getBool();
        TileActivator.enableSecurity = packetCoFHBase.getBool();
        TileBreaker.enableSecurity = packetCoFHBase.getBool();
        TileNullifier.enableSecurity = packetCoFHBase.getBool();
        TileDynamoBase.enableSecurity = packetCoFHBase.getBool();
        for (int i = 0; i < TileMachineBase.enableSecurity.length; ++i) {
            TileMachineBase.enableSecurity[i] = packetCoFHBase.getBool();
        }
        TileStrongbox.enableSecurity = packetCoFHBase.getBool();
        ItemSatchel.enableSecurity = packetCoFHBase.getBool();
        log.info("Receiving Server Configuration...");
    }

    public PacketCoFHBase getConfigSync() {
        PacketCoFHBase packetCoFHBase = PacketTEBase.getPacket(PacketTEBase.PacketTypes.CONFIG_SYNC);
        packetCoFHBase.addBool(TileCell.enableSecurity);
        packetCoFHBase.addBool(TileWorkbench.enableSecurity);
        packetCoFHBase.addBool(TileActivator.enableSecurity);
        packetCoFHBase.addBool(TileBreaker.enableSecurity);
        packetCoFHBase.addBool(TileNullifier.enableSecurity);
        packetCoFHBase.addBool(TileDynamoBase.enableSecurity);
        for (int i = 0; i < TileMachineBase.enableSecurity.length; ++i) {
            packetCoFHBase.addBool(TileMachineBase.enableSecurity[i]);
        }
        packetCoFHBase.addBool(TileStrongbox.enableSecurity);
        packetCoFHBase.addBool(ItemSatchel.enableSecurity);
        return packetCoFHBase;
    }

    public synchronized void handleIdMapping() {
        FurnaceManager.refreshRecipes();
        PulverizerManager.refreshRecipes();
        SawmillManager.refreshRecipes();
        SmelterManager.refreshRecipes();
        CrucibleManager.refreshRecipes();
        TransposerManager.refreshRecipes();
        PrecipitatorManager.refreshRecipes();
        ExtruderManager.refreshRecipes();
        ChargerManager.refreshRecipes();
        InsolatorManager.refreshRecipes();
        BlockDevice.refreshItemStacks();
        BlockDynamo.refreshItemStacks();
        BlockMachine.refreshItemStacks();
    }

    public void resetClientConfigs() {
        TileCell.configure();
        TileWorkbench.configure();
        TileActivator.configure();
        TileBreaker.configure();
        TileNullifier.configure();
        TileDynamoBase.configure();
        TileMachineBase.configure();
        TileStrongbox.configure();
        ItemSatchel.configure();
        this.handleIdMapping();
        log.info(StringHelper.localize((String)"Restoring Client Configuration..."));
    }

    void configOptions() {
        String string = "Holiday";
        String string2 = "Set this to true to disable Christmas cheer. Scrooge. :(";
        boolean bl = TEProps.holidayChristmas = !config.get(string, "HoHoNo", false, string2);
        if (CoFHProps.enableColorBlindTextures) {
            TEProps.textureGuiCommon = TEProps.PATH_COMMON_CB;
            TEProps.textureGuiAssembler = TEProps.PATH_ASSEMBLER_CB;
            TEProps.textureSelection = "Config_CB_";
            BlockCell.textureSelection = "CellConfig_CB_";
        }
        String string3 = config.get(string = "General", "UseIngots", false, string2 = "If enabled, ingots are used instead of gears in many default recipes.") ? "ingot" : "gear";
        for (String string4 : Arrays.asList("Iron", "Gold", "Copper", "Tin", "Silver", "Lead", "Nickel", "Platinum", "Mithril", "Electrum", "Invar", "Bronze", "Signalum", "Lumium", "Enderium")) {
            String string5 = "thermalexpansion:machine";
            ArrayList arrayList = OreDictionary.getOres((String)(string3 + string4));
            for (int i = 0; i < arrayList.size(); ++i) {
                OreDictionary.registerOre((String)(string5 + string4), (ItemStack)((ItemStack)arrayList.get(i)));
            }
        }
        string = "Interface.CreativeTab";
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        string2 = "Set to TRUE to put Thermal Expansion Blocks under a general \"Thermal Expansion\" Creative Tab.";
        bl2 = configClient.get(string, "BlocksInCommonTab", bl2);
        string2 = "Set to TRUE to put Thermal Expansion Items under a general \"Thermal Expansion\" Creative Tab.";
        bl3 = configClient.get(string, "ItemsInCommonTab", bl3);
        string2 = "Set to TRUE to put Thermal Expansion Tools under a general \"Thermal Expansion\" Creative Tab.";
        bl4 = configClient.get(string, "ToolsInCommonTab", bl4);
        string2 = "Set to TRUE to put Thermal Expansion Florbs under a general \"Thermal Expansion\" Creative Tab.";
        bl5 = configClient.get(string, "FlorbsInCommonTab", bl5);
        if (bl2 || bl3 || bl4 || bl5) {
            tabCommon = new TECreativeTab();
        }
        tabBlocks = bl2 ? tabCommon : new TECreativeTab("Blocks"){};
        tabItems = bl3 ? tabCommon : new TECreativeTab("Items"){

            @Override
            protected ItemStack getStack() {
                return TEItems.powerCoilElectrum;
            }
        };
        tabTools = bl4 ? tabCommon : new TECreativeTab("Tools"){

            @Override
            protected ItemStack getStack() {
                return TEItems.toolWrench;
            }
        };
        tabFlorbs = bl5 ? tabCommon : new TECreativeTabFlorbs();
    }

    void cleanConfig(boolean bl) {
        int n;
        if (bl) {
            config.renameCategory("security", "Security");
            config.removeCategory("world");
            config.removeCategory("World");
        }
        String string = "config.thermalexpansion.";
        String[] stringArray = config.getCategoryNames().toArray(new String[config.getCategoryNames().size()]);
        for (n = 0; n < stringArray.length; ++n) {
            config.getCategory(stringArray[n]).setLanguageKey(string + stringArray[n]).setRequiresMcRestart(true);
        }
        stringArray = configClient.getCategoryNames().toArray(new String[configClient.getCategoryNames().size()]);
        for (n = 0; n < stringArray.length; ++n) {
            configClient.getCategory(stringArray[n]).setLanguageKey(string + stringArray[n]).setRequiresMcRestart(true);
        }
    }

    @Mod.EventHandler
    public void missingMappings(FMLMissingMappingsEvent fMLMissingMappingsEvent) {
        List list = fMLMissingMappingsEvent.get();
        if (list.size() > 0) {
            for (FMLMissingMappingsEvent.MissingMapping missingMapping : list) {
                String string = missingMapping.name;
                if (string.indexOf(58) >= 0) {
                    string = string.substring(string.indexOf(58) + 1);
                }
                switch (missingMapping.type) {
                    case ITEM: {
                        if (string.indexOf("tool.") != 0 && string.indexOf("armor.") != 0) break;
                        Item item = GameRegistry.findItem((String)"ThermalFoundation", (String)string);
                        if (item != null) {
                            missingMapping.remap(item);
                            break;
                        }
                        missingMapping.warn();
                    }
                }
            }
        }
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModVersion() {
        return version;
    }

    static {
        log = LogManager.getLogger((String)modId);
        config = new ConfigHandler(version);
        configClient = new ConfigHandler(version);
        guiHandler = new GuiHandler();
        tabBlocks = tabCommon = null;
        tabItems = tabCommon;
        tabTools = tabCommon;
        tabFlorbs = tabCommon;
    }
}

