/*
 * Decompiled with CFR 0.152.
 */
package thermalfoundation;

import cofh.core.CoFHProps;
import cofh.core.util.ConfigHandler;
import cofh.mod.BaseMod;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.UpdateManager;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thermalfoundation.block.TFBlocks;
import thermalfoundation.core.Proxy;
import thermalfoundation.fluid.TFFluids;
import thermalfoundation.gui.GuiHandler;
import thermalfoundation.gui.TFCreativeTab;
import thermalfoundation.item.TFItems;
import thermalfoundation.util.LexiconManager;

@Mod(modid="ThermalFoundation", name="Thermal Foundation", version="1.7.10R1.0.0B3", dependencies="required-after:CoFHCore@[1.7.10R3.0.0B4,)", canBeDeactivated=false)
public class ThermalFoundation
extends BaseMod {
    public static final String modId = "ThermalFoundation";
    public static final String modName = "Thermal Foundation";
    public static final String version = "1.7.10R1.0.0B3";
    public static final String dependencies = "required-after:CoFHCore@[1.7.10R3.0.0B4,)";
    public static final String releaseURL = "https://raw.github.com/CoFH/ThermalFoundation/master/VERSION";
    @Mod.Instance(value="ThermalFoundation")
    public static ThermalFoundation instance;
    @SidedProxy(clientSide="thermalfoundation.core.ProxyClient", serverSide="thermalfoundation.core.Proxy")
    public static Proxy proxy;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final GuiHandler guiHandler;
    public static final CreativeTabs tab;

    public ThermalFoundation() {
        super(log);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        UpdateManager.registerUpdater((UpdateManager)new UpdateManager((IUpdatableMod)this, releaseURL));
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/ThermalFoundation.cfg")));
        TFFluids.preInit();
        TFItems.preInit();
        TFBlocks.preInit();
        LexiconManager.preInit();
        config.save();
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent fMLInitializationEvent) {
        TFFluids.initialize();
        TFItems.initialize();
        TFBlocks.initialize();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        TFFluids.postInit();
        TFItems.postInit();
        TFBlocks.postInit();
        proxy.registerEntities();
        proxy.registerRenderInformation();
        config.cleanUp(false, true);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent fMLLoadCompleteEvent) {
        LexiconManager.generateList();
        LexiconManager.addAllListedOres();
        this.cleanConfig(false);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent fMLServerStartingEvent) {
        TFFluids.registerDispenserHandlers();
    }

    void cleanConfig(boolean bl) {
        if (bl) {
            // empty if block
        }
        String string = "config.thermalfoundation.";
        String[] stringArray = config.getCategoryNames().toArray(new String[config.getCategoryNames().size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            config.getCategory(stringArray[i]).setLanguageKey(string + stringArray[i]).setRequiresMcRestart(true);
        }
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModVersion() {
        return version;
    }

    static {
        log = LogManager.getLogger((String)modId);
        config = new ConfigHandler(version);
        guiHandler = new GuiHandler();
        tab = new TFCreativeTab();
    }
}

