/*
 * Decompiled with CFR 0.152.
 */
package thermalfoundation.entity.monster;

import cofh.core.entity.EntitySelectorInRangeByType;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import thermalfoundation.ThermalFoundation;
import thermalfoundation.entity.projectile.EntityBlizzBall;
import thermalfoundation.entity.projectile.EntityBlizzSlowball;
import thermalfoundation.item.TFItems;

public class EntityBlizz
extends EntityMob {
    public static int entityId = -1;
    protected float heightOffset = 0.5f;
    protected int heightOffsetUpdateTime;
    protected int firingState;
    public static final String SOUND_AMBIENT = CoreUtils.getSoundName((String)"ThermalFoundation", (String)"mobBlizzAmbient");
    public static final String SOUND_ATTACK = CoreUtils.getSoundName((String)"ThermalFoundation", (String)"mobBlizzAttack");
    public static final String[] SOUND_LIVING = new String[]{CoreUtils.getSoundName((String)"ThermalFoundation", (String)"mobBlizzBreathe0"), CoreUtils.getSoundName((String)"ThermalFoundation", (String)"mobBlizzBreathe1"), CoreUtils.getSoundName((String)"ThermalFoundation", (String)"mobBlizzBreathe2")};
    protected static final int SOUND_AMBIENT_FREQUENCY = 200;

    public static void initialize() {
        try {
            entityId = EntityRegistry.findGlobalUniqueEntityId();
        }
        catch (Exception exception) {
            ThermalFoundation.log.error("Error - No Global Entity IDs remaining. This is REALLY bad. Using a mod-specific ID instead.", (Throwable)exception);
            entityId = CoreUtils.getEntityId();
        }
        try {
            EntityRegistry.registerGlobalEntityID(EntityBlizz.class, (String)"Blizz", (int)entityId, (int)14744575, (int)7071487);
        }
        catch (Exception exception) {
            ThermalFoundation.log.error("Another mod is improperly using the Entity Registry. This is REALLY bad. Using a mod-specific ID instead.", (Throwable)exception);
            entityId = CoreUtils.getEntityId();
            EntityRegistry.registerGlobalEntityID(EntityBlizz.class, (String)"Blizz", (int)entityId, (int)14744575, (int)7071487);
        }
        List<BiomeGenBase> list = Arrays.asList(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.END, BiomeDictionary.Type.SNOWY});
        for (BiomeGenBase biomeGenBase : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL)) {
            if (biomeGenBase.func_76736_e() || list.contains(biomeGenBase)) continue;
            arrayList.clear();
            arrayList.addAll(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biomeGenBase)));
            arrayList.removeAll(arrayList2);
            if (arrayList.size() != 0) continue;
            list.add(biomeGenBase);
        }
        arrayList.clear();
        EntityRegistry.addSpawn(EntityBlizz.class, (int)4, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])list.toArray(new BiomeGenBase[0]));
    }

    public EntityBlizz(World world) {
        super(world);
        ((EntityLiving)this).field_70728_aV = 10;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        ((Entity)this).field_70180_af.func_75682_a(16, (Object)new Byte(0));
    }

    protected String func_70639_aQ() {
        return SOUND_LIVING[((Entity)this).field_70146_Z.nextInt(3)];
    }

    protected String func_70621_aR() {
        return "mob.blaze.hit";
    }

    protected String func_70673_aS() {
        return "mob.blaze.death";
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float f) {
        return 0xF000F0;
    }

    public float func_70013_c(float f) {
        return 2.0f;
    }

    public void func_70636_d() {
        if (ServerHelper.isServerWorld((World)((Entity)this).field_70170_p)) {
            Entity entity;
            --this.heightOffsetUpdateTime;
            if (this.heightOffsetUpdateTime <= 0) {
                this.heightOffsetUpdateTime = 100;
                this.heightOffset = 0.5f + (float)((Entity)this).field_70146_Z.nextGaussian() * 3.0f;
            }
            if ((entity = this.func_70777_m()) != null && entity.field_70163_u + (double)entity.func_70047_e() > ((Entity)this).field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
                ((Entity)this).field_70181_x += ((double)0.3f - ((Entity)this).field_70181_x) * (double)0.3f;
            }
        }
        if (((Entity)this).field_70146_Z.nextInt(200) == 0) {
            ((Entity)this).field_70170_p.func_72908_a(((Entity)this).field_70165_t + 0.5, ((Entity)this).field_70163_u + 0.5, ((Entity)this).field_70161_v + 0.5, SOUND_AMBIENT, ((Entity)this).field_70146_Z.nextFloat() * 0.3f + 0.4f, ((Entity)this).field_70146_Z.nextFloat() * 0.3f + 0.4f);
        }
        if (!((Entity)this).field_70122_E && ((Entity)this).field_70181_x < 0.0) {
            ((Entity)this).field_70181_x *= 0.6;
        }
        for (int i = 0; i < 2; ++i) {
            ((Entity)this).field_70170_p.func_72869_a("snowballpoof", ((Entity)this).field_70165_t + (((Entity)this).field_70146_Z.nextDouble() - 0.5) * (double)((Entity)this).field_70130_N, ((Entity)this).field_70163_u + ((Entity)this).field_70146_Z.nextDouble() * ((double)((Entity)this).field_70131_O * 0.2), ((Entity)this).field_70161_v + (((Entity)this).field_70146_Z.nextDouble() - 0.5) * (double)((Entity)this).field_70130_N, 0.0, 0.0, 0.0);
        }
        super.func_70636_d();
    }

    protected Entity func_70782_k() {
        EntityPlayer entityPlayer = ((Entity)this).field_70170_p.func_72856_b((Entity)this, 16.0);
        if (entityPlayer != null && this.func_70685_l((Entity)entityPlayer)) {
            return entityPlayer;
        }
        return this.getClosestVictim(16.0);
    }

    public Entity getClosestVictim(double d) {
        EntitySelectorInRangeByType entitySelectorInRangeByType;
        AxisAlignedBB axisAlignedBB = AxisAlignedBB.func_72330_a((double)(((Entity)this).field_70165_t - d), (double)(((Entity)this).field_70163_u - d), (double)(((Entity)this).field_70161_v - d), (double)(((Entity)this).field_70165_t + d), (double)(((Entity)this).field_70163_u + d), (double)(((Entity)this).field_70161_v + d));
        List list = ((Entity)this).field_70170_p.func_94576_a((Entity)this, axisAlignedBB, (IEntitySelector)(entitySelectorInRangeByType = new EntitySelectorInRangeByType((Entity)this, d, new Class[]{EntityBlaze.class, EntityAnimal.class})));
        if (list.isEmpty()) {
            return null;
        }
        Entity entity = null;
        boolean bl = false;
        double d2 = Double.MAX_VALUE;
        for (Entity entity2 : list) {
            boolean bl2 = entity2 instanceof EntityBlaze;
            if (bl && !bl2) continue;
            double d3 = this.func_70068_e(entity2);
            if ((!bl2 || bl) && !(d3 < d2)) continue;
            d2 = d3;
            entity = entity2;
            bl |= bl2;
        }
        return entity;
    }

    protected void func_70785_a(Entity entity, float f) {
        if (((EntityLivingBase)this).field_70724_aR <= 0 && f < 2.0f && entity.field_70121_D.field_72337_e > ((Entity)this).field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < ((Entity)this).field_70121_D.field_72337_e) {
            ((EntityLivingBase)this).field_70724_aR = 20;
            this.func_70652_k(entity);
        } else if (f < 30.0f) {
            double d = entity.field_70165_t - ((Entity)this).field_70165_t;
            double d2 = entity.field_70161_v - ((Entity)this).field_70161_v;
            if (((EntityLivingBase)this).field_70724_aR == 0) {
                if (entity instanceof EntityBlizz || entity.isCreatureType(EnumCreatureType.creature, false)) {
                    EntityBlizzBall entityBlizzBall = new EntityBlizzBall(((Entity)this).field_70170_p, (EntityLivingBase)this);
                    double d3 = entity.field_70163_u + (double)entity.func_70047_e() - (double)1.1f - ((Entity)entityBlizzBall).field_70163_u;
                    float f2 = MathHelper.func_76133_a((double)(d * d + d2 * d2)) * 0.2f;
                    entityBlizzBall.func_70186_c(d, d3 + (double)f2, d2, 1.6f, 12.0f);
                    this.func_85030_a("random.bow", 1.0f, 1.0f / (((Entity)this).field_70146_Z.nextFloat() * 0.4f + 0.8f));
                    ((Entity)this).field_70170_p.func_72838_d((Entity)entityBlizzBall);
                    this.func_70784_b(null);
                    ((EntityLivingBase)this).field_70724_aR = 80;
                    this.firingState = 0;
                    this.setInAttackMode(false);
                } else {
                    ++this.firingState;
                    if (this.firingState == 1) {
                        ((EntityLivingBase)this).field_70724_aR = 60;
                        this.setInAttackMode(true);
                    } else if (this.firingState <= 5) {
                        ((EntityLivingBase)this).field_70724_aR = 6;
                    } else {
                        ((EntityLivingBase)this).field_70724_aR = 80;
                        this.firingState = 0;
                        this.setInAttackMode(false);
                    }
                    if (this.firingState > 1) {
                        EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                        double d4 = entityLivingBase.field_70121_D.field_72338_b + (double)(entityLivingBase.field_70131_O / 2.0f) - (((Entity)this).field_70163_u + (double)(((Entity)this).field_70131_O / 2.0f));
                        EntityBlizzSlowball entityBlizzSlowball = new EntityBlizzSlowball(((Entity)this).field_70170_p, (EntityLivingBase)this);
                        ((Entity)entityBlizzSlowball).field_70163_u = ((Entity)this).field_70163_u + (double)(((Entity)this).field_70131_O / 2.0f) + 0.5;
                        this.func_85030_a(SOUND_ATTACK, 2.0f, (((Entity)this).field_70146_Z.nextFloat() - ((Entity)this).field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                        ((Entity)this).field_70170_p.func_72838_d((Entity)entityBlizzSlowball);
                    }
                }
            }
            ((Entity)this).field_70177_z = (float)(Math.atan2(d2, d) * 180.0 / Math.PI) - 90.0f;
            ((EntityCreature)this).field_70787_b = true;
        }
    }

    protected void func_70069_a(float f) {
    }

    protected Item func_146068_u() {
        return Items.field_151126_ay;
    }

    protected void func_70628_a(boolean bl, int n) {
        if (bl) {
            int n2;
            int n3 = ((Entity)this).field_70146_Z.nextInt(4 + n);
            for (n2 = 0; n2 < n3; ++n2) {
                this.func_145779_a(this.func_146068_u(), 1);
            }
            n3 = ((Entity)this).field_70146_Z.nextInt(2 + n);
            for (n2 = 0; n2 < n3; ++n2) {
                this.func_70099_a(ItemHelper.cloneStack((ItemStack)TFItems.rodBlizz, (int)1), 0.0f);
            }
        }
    }

    public boolean isInAttackMode() {
        return (((Entity)this).field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setInAttackMode(boolean bl) {
        byte by = ((Entity)this).field_70180_af.func_75683_a(16);
        by = bl ? (byte)(by | 1) : (byte)(by & 0xFFFFFFFE);
        ((Entity)this).field_70180_af.func_75692_b(16, (Object)by);
    }

    public boolean func_70601_bi() {
        int n;
        int n2;
        int n3 = MathHelper.func_76128_c((double)((Entity)this).field_70165_t);
        Block block = ((Entity)this).field_70170_p.func_147439_a(n3, (n2 = MathHelper.func_76128_c((double)((Entity)this).field_70121_D.field_72338_b)) - 1, n = MathHelper.func_76128_c((double)((Entity)this).field_70161_v));
        if (block == Blocks.field_150433_aE || block == Blocks.field_150432_aD || block == Blocks.field_150431_aC || block == Blocks.field_150348_b && super.func_70814_o()) {
            return super.func_70601_bi();
        }
        return false;
    }

    protected boolean func_70814_o() {
        return true;
    }
}

