/*
 * Decompiled with CFR 0.152.
 */
package thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidInteractive;
import cofh.core.util.CoreUtils;
import cofh.lib.util.BlockWrapper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import thermalfoundation.ThermalFoundation;
import thermalfoundation.block.TFBlocks;
import thermalfoundation.fluid.TFFluids;

public class BlockFluidMana
extends BlockFluidInteractive {
    public static final int LEVELS = 6;
    public static final Material materialFluidMana = new MaterialLiquid(MapColor.field_151678_z);
    private static boolean effect = true;

    public BlockFluidMana() {
        super("thermalfoundation", TFFluids.fluidMana, materialFluidMana, "mana");
        this.setQuantaPerBlock(6);
        this.setTickRate(20);
        this.func_149711_c(2000.0f);
        this.func_149713_g(2);
        this.setParticleColor(0.2f, 0.0f, 0.4f);
        this.addInteraction(Blocks.field_150346_d, 0, (Block)Blocks.field_150349_c);
        this.addInteraction(Blocks.field_150346_d, 1, Blocks.field_150346_d, 2);
        this.addInteraction(Blocks.field_150359_w, (Block)Blocks.field_150354_m);
        this.addInteraction(TFBlocks.blockOre, 2, TFBlocks.blockOre, 6);
        this.addInteraction(TFBlocks.blockOre, 3, Blocks.field_150352_o);
        this.addInteraction(TFBlocks.blockStorage, 2, TFBlocks.blockStorage, 6);
        this.addInteraction(TFBlocks.blockStorage, 3, Blocks.field_150340_R);
    }

    public boolean preInit() {
        String string = "tweak";
        String string2 = "Enable this for Fluid Mana to do...things.";
        effect = ThermalFoundation.config.get(string, "Fluid.Mana.Effect", true, string2);
        GameRegistry.registerBlock((Block)this, (String)"FluidMana");
        return true;
    }

    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
        if (!effect) {
            return;
        }
        if (world.func_82737_E() % 4L == 0L) {
            int n4;
            int n5;
            if (MathHelper.RANDOM.nextInt(100) != 0) {
                return;
            }
            int n6 = n - 8 + world.field_73012_v.nextInt(17);
            if (!world.func_147439_a(n6, n5 = n2 + world.field_73012_v.nextInt(8), n4 = n3 - 8 + world.field_73012_v.nextInt(17)).func_149688_o().func_76220_a()) {
                if (entity instanceof EntityLivingBase) {
                    CoreUtils.teleportEntityTo((EntityLivingBase)((EntityLivingBase)entity), (double)n6, (double)n5, (double)n4);
                } else {
                    entity.func_70107_b((double)n6, (double)n5, (double)n4);
                    entity.field_70170_p.func_72908_a((double)n6, (double)n5, (double)n4, "mob.endermen.portal", 1.0f, 1.0f);
                    entity.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
                }
            }
        }
    }

    public int func_149709_b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return effect ? 15 : 0;
    }

    public int getLightValue(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return TFFluids.fluidMana.getLuminosity();
    }

    public void func_149674_a(World world, int n, int n2, int n3, Random random) {
        if (effect) {
            this.checkForInteraction(world, n, n2, n3);
        }
        if (world.func_72805_g(n, n2, n3) == 0) {
            Block block = world.func_147439_a(n, n2 + ((BlockFluidBase)this).densityDir, n3);
            int n4 = world.func_72805_g(n, n2 + ((BlockFluidBase)this).densityDir, n3);
            if (block == this && n4 != 0) {
                world.func_147465_d(n, n2 + ((BlockFluidBase)this).densityDir, n3, (Block)this, 0, 3);
                world.func_147468_f(n, n2, n3);
                return;
            }
        }
        super.func_149674_a(world, n, n2, n3, random);
    }

    protected void checkForInteraction(World world, int n, int n2, int n3) {
        if (world.func_147439_a(n, n2, n3) != this) {
            return;
        }
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        int n7 = -1;
        for (int i = 0; i < 6; ++i) {
            n4 = n + BlockHelper.SIDE_COORD_MOD[i][0];
            n5 = n2 + BlockHelper.SIDE_COORD_MOD[i][1];
            n6 = n3 + BlockHelper.SIDE_COORD_MOD[i][2];
            this.interactWithBlock(world, n4, n5, n6);
            this.interactWithBlock(world, n4 += BlockHelper.SIDE_COORD_MOD[i][0], n5, n6 += BlockHelper.SIDE_COORD_MOD[i][2]);
        }
        this.interactWithBlock(world, n - 1, n2, n3 - 1);
        this.interactWithBlock(world, n - 1, n2, n3 + 1);
        this.interactWithBlock(world, n + 1, n2, n3 - 1);
        this.interactWithBlock(world, n + 1, n2, n3 + 1);
    }

    protected void interactWithBlock(World world, int n, int n2, int n3) {
        Block block = world.func_147439_a(n, n2, n3);
        if (block == Blocks.field_150350_a || block == this) {
            return;
        }
        int n4 = world.func_72805_g(n, n2, n3);
        if (this.hasInteraction(block, n4)) {
            BlockWrapper blockWrapper = this.getInteraction(block, n4);
            world.func_147465_d(n, n2, n3, blockWrapper.block, blockWrapper.metadata, 3);
        } else if (world.isSideSolid(n, n2, n3, ForgeDirection.UP) && world.func_147437_c(n, n2 + 1, n3)) {
            if (MathHelper.RANDOM.nextInt(2) == 0) {
                world.func_147465_d(n, n2 + 1, n3, Blocks.field_150431_aC, 0, 3);
            } else {
                world.func_147465_d(n, n2 + 1, n3, (Block)Blocks.field_150480_ab, 0, 3);
            }
        }
    }

    protected void triggerInteractionEffects(World world, int n, int n2, int n3) {
        if (MathHelper.RANDOM.nextInt(10) == 0) {
            world.func_72908_a((double)((float)n + 0.5f), (double)((float)n2 + 0.5f), (double)((float)n3 + 0.5f), "random.orb", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        }
        for (int i = 0; i < 4; ++i) {
            world.func_72869_a("enchantmenttable", (double)n + Math.random(), (double)n2 + 1.2, (double)n3 + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

