/*
 * Decompiled with CFR 0.152.
 */
package thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidCoFHBase;
import cofh.lib.util.helpers.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import org.apache.logging.log4j.Level;
import thermalfoundation.ThermalFoundation;
import thermalfoundation.fluid.TFFluids;

public class BlockFluidGlowstone
extends BlockFluidCoFHBase {
    public static final int LEVELS = 6;
    public static final Material materialFluidGlowstone = new MaterialLiquid(MapColor.field_151673_t);
    private static boolean effect = true;
    private static boolean enableSourceCondense = true;
    private static boolean enableSourceFloat = true;
    private static int maxGlowstoneHeight = 120;

    public BlockFluidGlowstone() {
        super("thermalfoundation", TFFluids.fluidGlowstone, materialFluidGlowstone, "glowstone");
        this.setQuantaPerBlock(6);
        this.setTickRate(20);
        this.func_149711_c(1.0f);
        this.func_149713_g(0);
        this.setParticleColor(1.0f, 0.9f, 0.05f);
    }

    public boolean preInit() {
        GameRegistry.registerBlock((Block)this, (String)"FluidGlowstone");
        String string = "tweak";
        String string2 = "Enable this for Fluid Glowstone to do...something.";
        effect = ThermalFoundation.config.get(string, "Fluid.Glowstone.Effect", true, string2);
        string2 = "Enable this for Fluid Glowstone Source blocks to condense back into solid Glowstone above a given y-value.";
        enableSourceCondense = ThermalFoundation.config.get(string, "Fluid.Glowstone.Condense", enableSourceCondense, string2);
        string2 = "Enable this for Fluid Glowstone Source blocks to gradually float upwards.";
        enableSourceFloat = ThermalFoundation.config.get(string, "Fluid.Glowstone.Float", enableSourceFloat, string2);
        int n = maxGlowstoneHeight;
        string2 = "This adjusts the y-value where Fluid Glowstone will *always* condense, if that is enabled. It will also condense above 80% of this value, if it cannot flow.";
        n = ThermalFoundation.config.get(string, "Fluid.Glowstone.MaxHeight", maxGlowstoneHeight, string2);
        if (n >= maxGlowstoneHeight) {
            maxGlowstoneHeight = n;
        } else {
            ThermalFoundation.log.log(Level.INFO, "'Fluid.Glowstone.MaxHeight' config value is out of acceptable range. Using default: " + maxGlowstoneHeight + ".");
        }
        return true;
    }

    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
        if (!effect) {
            return;
        }
        if (entity instanceof EntityLivingBase && entity.field_70181_x < -0.2) {
            entity.field_70181_x *= 0.5;
            entity.field_70143_R = entity.field_70143_R > 20.0f ? 20.0f : (float)((double)entity.field_70143_R * 0.95);
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (world.func_82737_E() % 8L == 0L && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70662_br()) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 120, 0));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 120, 0));
        }
    }

    public int getLightValue(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return TFFluids.fluidGlowstone.getLuminosity();
    }

    public void func_149674_a(World world, int n, int n2, int n3, Random random) {
        if (world.func_72805_g(n, n2, n3) == 0) {
            if (random.nextInt(3) == 0) {
                if (this.shouldSourceBlockCondense(world, n, n2, n3)) {
                    world.func_147449_b(n, n2, n3, Blocks.field_150426_aN);
                    return;
                }
                if (this.shouldSourceBlockFloat(world, n, n2, n3)) {
                    world.func_147465_d(n, n2 + ((BlockFluidBase)this).densityDir, n3, (Block)this, 0, 3);
                    world.func_147468_f(n, n2, n3);
                    return;
                }
            }
        } else if (n2 + ((BlockFluidBase)this).densityDir > maxGlowstoneHeight) {
            int n4 = ((BlockFluidBase)this).quantaPerBlock - world.func_72805_g(n, n2, n3);
            int n5 = -101;
            int n6 = n2 - ((BlockFluidBase)this).densityDir;
            if (world.func_147439_a(n, n6, n3) == this || world.func_147439_a(n - 1, n6, n3) == this || world.func_147439_a(n + 1, n6, n3) == this || world.func_147439_a(n, n6, n3 - 1) == this || world.func_147439_a(n, n6, n3 + 1) == this) {
                n5 = ((BlockFluidBase)this).quantaPerBlock - 1;
            } else {
                int n7 = -100;
                n7 = this.getLargerQuanta((IBlockAccess)world, n - 1, n2, n3, n7);
                n7 = this.getLargerQuanta((IBlockAccess)world, n + 1, n2, n3, n7);
                n7 = this.getLargerQuanta((IBlockAccess)world, n, n2, n3 - 1, n7);
                n7 = this.getLargerQuanta((IBlockAccess)world, n, n2, n3 + 1, n7);
                n5 = n7 - 1;
            }
            if (n5 != n4) {
                n4 = n5;
                if (n5 <= 0) {
                    world.func_147468_f(n, n2, n3);
                } else {
                    world.func_72921_c(n, n2, n3, ((BlockFluidBase)this).quantaPerBlock - n5, 3);
                    world.func_147464_a(n, n2, n3, (Block)this, ((BlockFluidBase)this).tickRate);
                    world.func_147459_d(n, n2, n3, (Block)this);
                }
            }
            return;
        }
        super.func_149674_a(world, n, n2, n3, random);
    }

    protected boolean shouldSourceBlockCondense(World world, int n, int n2, int n3) {
        return enableSourceCondense && (n2 + ((BlockFluidBase)this).densityDir > maxGlowstoneHeight || n2 + ((BlockFluidBase)this).densityDir > world.func_72800_K() || (float)(n2 + ((BlockFluidBase)this).densityDir) > (float)maxGlowstoneHeight * 0.8f && !this.canDisplace((IBlockAccess)world, n, n2 + ((BlockFluidBase)this).densityDir, n3));
    }

    protected boolean shouldSourceBlockFloat(World world, int n, int n2, int n3) {
        return enableSourceFloat && world.func_147439_a(n, n2 + ((BlockFluidBase)this).densityDir, n3) == this && world.func_72805_g(n, n2 + ((BlockFluidBase)this).densityDir, n3) != 0;
    }
}

