/*
 * Decompiled with CFR 0.152.
 */
package thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidInteractive;
import cofh.lib.util.BlockWrapper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import thermalfoundation.ThermalFoundation;
import thermalfoundation.fluid.TFFluids;

public class BlockFluidPyrotheum
extends BlockFluidInteractive {
    public static final int LEVELS = 5;
    public static final Material materialFluidPyrotheum = new MaterialLiquid(MapColor.field_151656_f);
    private static boolean effect = true;
    private static boolean enableSourceFall = true;

    public BlockFluidPyrotheum() {
        super("thermalfoundation", TFFluids.fluidPyrotheum, Material.field_151587_i, "pyrotheum");
        this.setQuantaPerBlock(5);
        this.setTickRate(25);
        this.func_149711_c(1000.0f);
        this.func_149713_g(1);
        this.setParticleColor(1.0f, 0.7f, 0.15f);
    }

    public boolean preInit() {
        GameRegistry.registerBlock((Block)this, (String)"FluidPyrotheum");
        this.addInteraction(Blocks.field_150347_e, Blocks.field_150348_b);
        this.addInteraction((Block)Blocks.field_150349_c, Blocks.field_150346_d);
        this.addInteraction((Block)Blocks.field_150354_m, Blocks.field_150359_w);
        this.addInteraction(Blocks.field_150355_j, Blocks.field_150348_b);
        this.addInteraction((Block)Blocks.field_150358_i, Blocks.field_150348_b);
        this.addInteraction(Blocks.field_150435_aG, Blocks.field_150405_ch);
        this.addInteraction(Blocks.field_150432_aD, Blocks.field_150348_b);
        this.addInteraction(Blocks.field_150433_aE, Blocks.field_150350_a);
        this.addInteraction(Blocks.field_150431_aC, Blocks.field_150350_a);
        for (int i = 0; i < 8; ++i) {
            this.addInteraction(Blocks.field_150446_ar, i, Blocks.field_150390_bg, i);
        }
        String string = "tweak";
        String string2 = "Enable this for Fluid Pyrotheum to be worse than lava.";
        effect = ThermalFoundation.config.get(string, "Fluid.Pyrotheum.Effect", true, string2);
        string2 = "Enable this for Fluid Pyrotheum Source blocks to gradually fall downwards.";
        enableSourceFall = ThermalFoundation.config.get(string, "Fluid.Pyrotheum.Fall", enableSourceFall, string2);
        return true;
    }

    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
        if (!effect) {
            return;
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (!(entity instanceof EntityPlayer) && entity instanceof EntityCreeper) {
            world.func_72876_a(entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 6.0f, entity.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
            entity.func_70106_y();
        }
    }

    public int getLightValue(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return TFFluids.fluidPyrotheum.getLuminosity();
    }

    public int getFireSpreadSpeed(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return effect ? 800 : 0;
    }

    public int getFlammability(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return 0;
    }

    public boolean isFlammable(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return effect && forgeDirection.ordinal() > ForgeDirection.UP.ordinal() && iBlockAccess.func_147439_a(n, n2 - 1, n3) != this;
    }

    public boolean isFireSource(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return effect;
    }

    public void func_149674_a(World world, int n, int n2, int n3, Random random) {
        if (effect) {
            this.checkForInteraction(world, n, n2, n3);
        }
        if (world.func_72805_g(n, n2, n3) == 0) {
            Block block = world.func_147439_a(n, n2 + ((BlockFluidBase)this).densityDir, n3);
            int n4 = world.func_72805_g(n, n2 + ((BlockFluidBase)this).densityDir, n3);
            if (block == this && n4 != 0 || block.isFlammable((IBlockAccess)world, n, n2 + ((BlockFluidBase)this).densityDir, n3, ForgeDirection.UP)) {
                world.func_147465_d(n, n2 + ((BlockFluidBase)this).densityDir, n3, (Block)this, 0, 3);
                world.func_147468_f(n, n2, n3);
                return;
            }
        }
        super.func_149674_a(world, n, n2, n3, random);
    }

    protected void checkForInteraction(World world, int n, int n2, int n3) {
        if (world.func_147439_a(n, n2, n3) != this) {
            return;
        }
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        for (int i = 0; i < 6; ++i) {
            n4 = n + BlockHelper.SIDE_COORD_MOD[i][0];
            n5 = n2 + BlockHelper.SIDE_COORD_MOD[i][1];
            n6 = n3 + BlockHelper.SIDE_COORD_MOD[i][2];
            this.interactWithBlock(world, n4, n5, n6);
            this.interactWithBlock(world, n4 += BlockHelper.SIDE_COORD_MOD[i][0], n5, n6 += BlockHelper.SIDE_COORD_MOD[i][2]);
        }
        this.interactWithBlock(world, n - 1, n2, n3 - 1);
        this.interactWithBlock(world, n - 1, n2, n3 + 1);
        this.interactWithBlock(world, n + 1, n2, n3 - 1);
        this.interactWithBlock(world, n + 1, n2, n3 + 1);
    }

    protected void interactWithBlock(World world, int n, int n2, int n3) {
        Block block = world.func_147439_a(n, n2, n3);
        if (block == Blocks.field_150350_a || block == this) {
            return;
        }
        int n4 = world.func_72805_g(n, n2, n3);
        if (this.hasInteraction(block, n4)) {
            BlockWrapper blockWrapper = this.getInteraction(block, n4);
            world.func_147465_d(n, n2, n3, blockWrapper.block, blockWrapper.metadata, 3);
            this.triggerInteractionEffects(world, n, n2, n3);
        } else if (block.isFlammable((IBlockAccess)world, n, n2, n3, ForgeDirection.UP)) {
            world.func_147449_b(n, n2, n3, (Block)Blocks.field_150480_ab);
        } else if (world.isSideSolid(n, n2, n3, ForgeDirection.UP) && world.func_147437_c(n, n2 + 1, n3)) {
            world.func_147465_d(n, n2 + 1, n3, (Block)Blocks.field_150480_ab, 0, 3);
        }
    }

    protected void triggerInteractionEffects(World world, int n, int n2, int n3) {
        if (MathHelper.RANDOM.nextInt(10) == 0) {
            world.func_72908_a((double)((float)n + 0.5f), (double)((float)n2 + 0.5f), (double)((float)n3 + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        }
        for (int i = 0; i < 4; ++i) {
            world.func_72869_a("largesmoke", (double)n + Math.random(), (double)n2 + 1.2, (double)n3 + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

