/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.weaponry;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.IAmmo;

public abstract class AmmoItem
extends ToolCore
implements IAmmo {
    public AmmoItem(int baseDamage, String name) {
        super(baseDamage);
        this.func_77637_a(TConstructRegistry.weaponryTab);
    }

    @Override
    public int getAmmoCount(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        return tags.func_74762_e("Ammo");
    }

    @Override
    public int getMaxAmmo(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        return this.getMaxAmmo(tags);
    }

    @Override
    public int getMaxAmmo(NBTTagCompound tags) {
        float dur = tags.func_74762_e("TotalDurability");
        return Math.max(1, (int)Math.ceil(dur * this.getAmmoModifier()));
    }

    @Override
    public int addAmmo(int toAdd, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return toAdd;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        int oldCount = tags.func_74762_e("Ammo");
        int newCount = Math.min(oldCount + toAdd, this.getMaxAmmo(stack));
        tags.func_74768_a("Ammo", newCount);
        return toAdd - (newCount - oldCount);
    }

    @Override
    public int consumeAmmo(int toUse, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return toUse;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        int oldCount = tags.func_74762_e("Ammo");
        int newCount = Math.max(oldCount - toUse, 0);
        tags.func_74768_a("Ammo", newCount);
        return toUse - (oldCount - newCount);
    }

    @Override
    public void setAmmo(int count, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        tags.func_74768_a("Ammo", count);
    }

    public float getAmmoModifier() {
        return 0.1f;
    }

    public boolean pickupAmmo(ItemStack stack, ItemStack candidate, EntityPlayer player) {
        if (stack.func_77973_b() == null || !stack.func_77942_o() || !(stack.func_77973_b() instanceof IAmmo)) {
            return false;
        }
        if (candidate != null && this.testIfAmmoMatches(stack, candidate)) {
            IAmmo pickedup = (IAmmo)stack.func_77973_b();
            IAmmo ininventory = (IAmmo)candidate.func_77973_b();
            ininventory.addAmmo(pickedup.getAmmoCount(stack), candidate);
            return true;
        }
        for (ItemStack invItem : player.field_71071_by.field_70462_a) {
            if (!this.testIfAmmoMatches(stack, invItem)) continue;
            IAmmo pickedup = (IAmmo)stack.func_77973_b();
            IAmmo ininventory = (IAmmo)invItem.func_77973_b();
            ininventory.addAmmo(pickedup.getAmmoCount(stack), invItem);
            return true;
        }
        return false;
    }

    private boolean testIfAmmoMatches(ItemStack reference, ItemStack candidate) {
        if (candidate == null) {
            return false;
        }
        if (!candidate.func_77942_o() || !candidate.func_77978_p().func_74764_b("InfiTool")) {
            return false;
        }
        ItemStack testsubject = candidate.func_77946_l();
        testsubject.func_77978_p().func_74775_l("InfiTool").func_74768_a("Ammo", this.getAmmoCount(reference));
        return ItemStack.func_77989_b((ItemStack)reference, (ItemStack)testsubject);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return false;
    }
}

