/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.weaponry;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import tconstruct.client.TProxyClient;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.util.TextureHelper;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.library.weaponry.IAccuracy;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.library.weaponry.IWindup;
import tconstruct.weaponry.client.CrosshairType;

public abstract class ProjectileWeapon
extends ToolCore
implements IAccuracy,
IWindup {
    public HashMap<Integer, IIcon[]> animationHeadIcons = new HashMap();
    public HashMap<Integer, IIcon[]> animationHandleIcons = new HashMap();
    public HashMap<Integer, IIcon[]> animationAccessoryIcons = new HashMap();
    public HashMap<Integer, IIcon[]> animationExtraIcons = new HashMap();
    public HashMap<Integer, IIcon[]> animationEffectIcons = new HashMap();

    public ProjectileWeapon(int baseDamage, String name) {
        super(baseDamage);
        this.func_77637_a(TConstructRegistry.weaponryTab);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CrosshairType getCrosshairType() {
        return CrosshairType.SQUARE;
    }

    @Override
    public boolean zoomOnWindup(ItemStack itemStack) {
        return false;
    }

    @Override
    public float getZoom(ItemStack itemStack) {
        return 1.0f;
    }

    public abstract ItemStack searchForAmmo(EntityPlayer var1, ItemStack var2);

    protected abstract Entity createProjectile(ItemStack var1, World var2, EntityPlayer var3, float var4, float var5, float var6);

    @Override
    public abstract float minAccuracy(ItemStack var1);

    @Override
    public abstract float maxAccuracy(ItemStack var1);

    public float getAccuracy(ItemStack itemStack, EntityPlayer player) {
        return this.getAccuracy(itemStack, this.func_77626_a(itemStack) - player.func_71052_bv());
    }

    @Override
    public float getAccuracy(ItemStack itemStack, int time) {
        float dif = this.minAccuracy(itemStack) - this.maxAccuracy(itemStack);
        return this.minAccuracy(itemStack) - dif * this.getWindupProgress(itemStack, time);
    }

    @Override
    public int getWindupTime(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return 1;
        }
        NBTTagCompound toolTag = itemStack.func_77978_p().func_74775_l("InfiTool");
        return toolTag.func_74762_e("DrawSpeed");
    }

    @Override
    public float getWindupProgress(ItemStack itemStack, EntityPlayer player) {
        if (player.field_71071_by.func_70448_g() != itemStack) {
            return 0.0f;
        }
        if (player.func_71011_bu() == null) {
            return 0.0f;
        }
        return this.getWindupProgress(itemStack, this.func_77626_a(itemStack) - player.func_71052_bv());
    }

    public float getWindupProgress(ItemStack itemStack, int timeInUse) {
        float time = timeInUse;
        float windup = this.getWindupTime(itemStack);
        if (time > windup) {
            return 1.0f;
        }
        return time / windup;
    }

    public float getProjectileSpeed(ItemStack itemStack) {
        NBTTagCompound toolTag = itemStack.func_77978_p().func_74775_l("InfiTool");
        return toolTag.func_74760_g("FlightSpeed");
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.none;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if ((float)this.getWindupTime(stack) == 0.0f) {
            return stack;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.getBaseTagName()) && stack.func_77978_p().func_74775_l(this.getBaseTagName()).func_74767_n("Broken")) {
            return stack;
        }
        if (this.searchForAmmo(player, stack) != null) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public void func_77615_a(ItemStack weapon, World world, EntityPlayer player, int useRemaining) {
        int time = this.func_77626_a(weapon) - useRemaining;
        ArrowLooseEvent event = new ArrowLooseEvent(player, weapon, time);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        time = event.charge;
        ItemStack ammo = this.searchForAmmo(player, weapon);
        if (ammo == null) {
            return;
        }
        NBTTagCompound toolTag = weapon.func_77978_p().func_74775_l("InfiTool");
        float projectileSpeed = this.getProjectileSpeed(weapon);
        float windup = this.getWindupProgress(weapon, time);
        float accuracy = this.getAccuracy(weapon, time);
        if (windup < this.getMinWindupProgress(weapon)) {
            return;
        }
        Entity projectile = this.createProjectile(ammo, world, player, projectileSpeed *= windup, accuracy, windup);
        int reinforced = 0;
        if (toolTag.func_74764_b("Unbreaking")) {
            reinforced = toolTag.func_74762_e("Unbreaking");
        }
        if (this.random.nextInt(10) < 10 - reinforced) {
            AbilityHelper.damageTool(weapon, 1, (EntityLivingBase)player, false);
        }
        this.playFiringSound(world, player, weapon, ammo, projectileSpeed, accuracy);
        if (!player.field_71075_bZ.field_75098_d) {
            if (ammo.func_77973_b() instanceof IAmmo) {
                ((IAmmo)ammo.func_77973_b()).consumeAmmo(1, ammo);
            } else {
                player.field_71071_by.func_146026_a(ammo.func_77973_b());
            }
        }
        if (!world.field_72995_K) {
            world.func_72838_d(projectile);
        }
    }

    public abstract void playFiringSound(World var1, EntityPlayer var2, ItemStack var3, ItemStack var4, float var5, float var6);

    protected boolean animateLayer(int renderPass) {
        return false;
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags == null || renderPass > 10) {
            return super.getIcon(stack, renderPass, player, usingItem, useRemaining);
        }
        if (renderPass >= this.getPartAmount()) {
            String effect = "Effect" + (1 + renderPass - this.getPartAmount());
            if (tags.func_74764_b(effect)) {
                int index = tags.func_74762_e(effect);
                if (this.animationEffectIcons.get(index) != null) {
                    return this.getCorrectAnimationIcon(this.animationEffectIcons, index, this.getWindupProgress(usingItem, this.func_77626_a(usingItem) - useRemaining));
                }
                return (IIcon)this.effectIcons.get(index);
            }
            return super.getIcon(stack, renderPass, player, usingItem, useRemaining);
        }
        if (!this.animateLayer(renderPass)) {
            return super.getIcon(stack, renderPass, player, usingItem, useRemaining);
        }
        if (usingItem == null || stack != usingItem || !stack.func_77942_o()) {
            return super.getIcon(stack, renderPass, player, usingItem, useRemaining);
        }
        float progress = this.getWindupProgress(usingItem, this.func_77626_a(usingItem) - useRemaining);
        switch (renderPass) {
            case 0: {
                return this.getCorrectAnimationIcon(this.animationHandleIcons, tags.func_74762_e("RenderHandle"), progress);
            }
            case 1: {
                return this.getCorrectAnimationIcon(this.animationHeadIcons, tags.func_74762_e("RenderHead"), progress);
            }
            case 2: {
                return this.getCorrectAnimationIcon(this.animationAccessoryIcons, tags.func_74762_e("RenderAccessory"), progress);
            }
            case 3: {
                return this.getCorrectAnimationIcon(this.animationExtraIcons, tags.func_74762_e("RenderExtra"), progress);
            }
        }
        return emptyIcon;
    }

    protected IIcon getCorrectAnimationIcon(Map<Integer, IIcon[]> icons, int id, float progress) {
        float count = icons.get(-1).length - 1;
        int step = Math.round(progress * count);
        if (icons.containsKey(id)) {
            return icons.get(id)[step];
        }
        return icons.get(-1)[step];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            String effect;
            tags = stack.func_77978_p().func_74775_l("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    if (tags.func_74767_n("Broken")) {
                        return this.getCorrectIcon(this.brokenIcons, tags.func_74762_e("RenderHandle"));
                    }
                    return this.getCorrectIcon(this.handleIcons, tags.func_74762_e("RenderHandle"));
                }
                if (renderPass == 1) {
                    return this.getCorrectIcon(this.headIcons, tags.func_74762_e("RenderHead"));
                }
                if (renderPass == 2) {
                    return this.getCorrectIcon(this.accessoryIcons, tags.func_74762_e("RenderAccessory"));
                }
                if (renderPass == 3) {
                    return this.getCorrectIcon(this.extraIcons, tags.func_74762_e("RenderExtra"));
                }
            } else if (renderPass <= 10 && tags.func_74764_b(effect = "Effect" + (1 + renderPass - this.getPartAmount()))) {
                return (IIcon)this.effectIcons.get(tags.func_74762_e(effect));
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    @Override
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.addAnimationIcons(this.headStrings, this.animationHeadIcons, iconRegister, this.getIconSuffix(0));
        this.addAnimationIcons(this.handleStrings, this.animationHandleIcons, iconRegister, this.getIconSuffix(2));
        this.addAnimationIcons(this.accessoryStrings, this.animationAccessoryIcons, iconRegister, this.getIconSuffix(3));
        this.addAnimationIcons(this.extraStrings, this.animationExtraIcons, iconRegister, this.getIconSuffix(4));
        int count = 0;
        if (this.animationHeadIcons.get(-1) != null) {
            count = Math.max(count, this.animationHeadIcons.get(-1).length);
        }
        if (this.animationHandleIcons.get(-1) != null) {
            count = Math.max(count, this.animationHandleIcons.get(-1).length);
        }
        if (this.animationAccessoryIcons.get(-1) != null) {
            count = Math.max(count, this.animationAccessoryIcons.get(-1).length);
        }
        if (this.animationExtraIcons.get(-1) != null) {
            count = Math.max(count, this.animationExtraIcons.get(-1).length);
        }
        for (Map.Entry entry : this.effectStrings.entrySet()) {
            IIcon[] anims = new IIcon[count];
            boolean empty = true;
            for (int i = 0; i < count; ++i) {
                String tex = (String)entry.getValue() + "_" + (i + 1);
                if (!TextureHelper.itemTextureExists(tex)) continue;
                anims[i] = iconRegister.func_94245_a(tex);
                empty = false;
            }
            if (empty) continue;
            this.animationEffectIcons.put((Integer)entry.getKey(), anims);
        }
        IIcon[] anims = new IIcon[count];
        for (int i = 0; i < count; ++i) {
            anims[i] = blankSprite;
        }
        this.animationEffectIcons.put(-1, anims);
    }

    private void addAnimationIcons(HashMap<Integer, String> textures, HashMap<Integer, IIcon[]> icons, IIconRegister iconRegister, String standard) {
        icons.clear();
        if (standard == null || standard.isEmpty()) {
            return;
        }
        int count = 1;
        standard = this.getDefaultTexturePath() + "/" + standard;
        while (TextureHelper.itemTextureExists(standard + "_" + count)) {
            ++count;
        }
        IIcon[] anims = new IIcon[--count];
        for (int i = 0; i < count; ++i) {
            anims[i] = iconRegister.func_94245_a(standard + "_" + (i + 1));
        }
        icons.put(-1, anims);
        for (Map.Entry<Integer, String> entry : textures.entrySet()) {
            anims = new IIcon[count];
            boolean empty = true;
            for (int i = 0; i < count; ++i) {
                String tex = entry.getValue() + "_" + (i + 1);
                if (!TextureHelper.itemTextureExists(tex)) continue;
                anims[i] = iconRegister.func_94245_a(tex);
                empty = false;
            }
            if (empty) continue;
            icons.put(entry.getKey(), anims);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        float damage;
        super.func_77624_a(stack, player, list, par4);
        if (!stack.func_77942_o()) {
            return;
        }
        ItemStack currentAmmo = this.searchForAmmo(player, stack);
        if (currentAmmo == null) {
            return;
        }
        if (currentAmmo.func_77973_b() == Items.field_151032_g) {
            damage = 2.0f;
        } else if (currentAmmo.func_77973_b() instanceof AmmoItem && currentAmmo.func_77942_o()) {
            damage = currentAmmo.func_77978_p().func_74775_l("InfiTool").func_74762_e("Attack");
        } else {
            return;
        }
        damage *= this.getProjectileSpeed(stack);
        list.remove(list.size() - 1);
        list.add(currentAmmo.func_82833_r());
        list.add(StatCollector.func_74838_a((String)"attribute.name.ammo.maxAttackDamage") + ": " + TProxyClient.df.format(damage /= 2.0f));
    }
}

