/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.component;

import java.util.ArrayList;
import mantle.world.CoordTuple;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tconstruct.library.component.LogicComponent;
import tconstruct.library.component.MultiFluidTank;
import tconstruct.library.crafting.Smeltery;
import tconstruct.smeltery.component.SmelteryScan;
import tconstruct.smeltery.logic.AdaptiveSmelteryLogic;

public class SmelteryComponent
extends LogicComponent {
    final AdaptiveSmelteryLogic master;
    final SmelteryScan structure;
    final MultiFluidTank multitank;
    int maxTemp;
    public int fuelTicks;
    public int fuelGague;
    public int fuelAmount;
    boolean inUse;
    public int[] activeTemps = new int[0];
    public int[] meltingTemps = new int[0];
    CoordTuple activeLavaTank;

    public SmelteryComponent(AdaptiveSmelteryLogic inventory, SmelteryScan structure, MultiFluidTank multitank, int maxTemp) {
        this.master = inventory;
        this.structure = structure;
        this.multitank = multitank;
        this.maxTemp = maxTemp;
    }

    public void update() {
        if (this.activeTemps.length == 0) {
            this.inUse = false;
        }
        this.updateFuelGague();
    }

    public void adjustSize(int size, boolean forceAdjust) {
        if (size != this.activeTemps.length || forceAdjust) {
            int[] tempActive = this.activeTemps;
            this.activeTemps = new int[size];
            int activeLength = tempActive.length > this.activeTemps.length ? this.activeTemps.length : tempActive.length;
            System.arraycopy(tempActive, 0, this.activeTemps, 0, activeLength);
            int[] tempMelting = this.meltingTemps;
            this.meltingTemps = new int[size];
            int meltingLength = tempMelting.length > this.meltingTemps.length ? this.meltingTemps.length : tempMelting.length;
            System.arraycopy(tempMelting, 0, this.meltingTemps, 0, meltingLength);
            if (this.activeTemps.length > 0 && this.activeTemps.length > tempActive.length) {
                for (int i = tempActive.length; i < this.activeTemps.length; ++i) {
                    this.activeTemps[i] = 20;
                    this.meltingTemps[i] = 20;
                }
            }
        }
    }

    public void updateTemperatures() {
        this.inUse = true;
        for (int i = 0; i < this.meltingTemps.length; ++i) {
            this.meltingTemps[i] = Smeltery.getLiquifyTemperature(this.master.func_70301_a(i));
        }
    }

    public void heatItems() {
        if (this.fuelTicks > 0) {
            boolean hasUse = false;
            for (int i = 0; i < this.meltingTemps.length; ++i) {
                --this.fuelTicks;
                if (this.fuelTicks <= 0) break;
                ItemStack slot = this.master.func_70301_a(i);
                if (this.meltingTemps[i] > 20 && slot != null) {
                    FluidStack result;
                    hasUse = true;
                    if (this.activeTemps[i] < this.maxTemp && this.activeTemps[i] < this.meltingTemps[i]) {
                        int n = i;
                        this.activeTemps[n] = this.activeTemps[n] + 1;
                        continue;
                    }
                    if (this.activeTemps[i] < this.meltingTemps[i] || this.world.field_72995_K || (result = this.getResultFor(slot)) == null || !this.multitank.addFluidToTank(result, false)) continue;
                    this.master.func_70299_a(i, null);
                    this.activeTemps[i] = 20;
                    ArrayList alloys = Smeltery.mixMetals(this.multitank.fluidlist);
                    for (int al = 0; al < alloys.size(); ++al) {
                        FluidStack liquid = (FluidStack)alloys.get(al);
                        this.multitank.addFluidToTank(liquid, true);
                    }
                    this.master.func_70296_d();
                    this.master.setUpdateFluids();
                    continue;
                }
                this.activeTemps[i] = 20;
            }
            this.inUse = hasUse;
        }
    }

    void updateFuelGague() {
        if (this.activeLavaTank == null || this.fuelTicks > 0 || this.structure.lavaTanks.size() < 1) {
            return;
        }
        if (!this.world.func_72899_e(this.activeLavaTank.x, this.activeLavaTank.y, this.activeLavaTank.z)) {
            this.fuelAmount = 0;
            this.fuelGague = 0;
            return;
        }
        TileEntity tankContainer = this.world.func_147438_o(this.activeLavaTank.x, this.activeLavaTank.y, this.activeLavaTank.z);
        if (tankContainer == null) {
            this.fuelAmount = 0;
            this.fuelGague = 0;
            return;
        }
        if (tankContainer instanceof IFluidHandler && this.inUse) {
            FluidStack liquid = ((IFluidHandler)tankContainer).drain(ForgeDirection.DOWN, this.drainFuelAmount(), false);
            if (liquid != null && liquid.getFluid().getBlock() == Blocks.field_150353_l) {
                liquid = ((IFluidHandler)tankContainer).drain(ForgeDirection.DOWN, this.drainFuelAmount(), true);
                this.fuelTicks += liquid.amount * 15;
                FluidTankInfo[] info = ((IFluidHandler)tankContainer).getTankInfo(ForgeDirection.DOWN);
                liquid = info[0].fluid;
                int capacity = info[0].capacity;
                if (liquid != null) {
                    this.fuelAmount = liquid.amount;
                    this.fuelGague = liquid.amount * 52 / capacity;
                } else {
                    this.fuelAmount = 0;
                    this.fuelGague = 0;
                }
            } else {
                boolean foundTank = false;
                int iter = 0;
                while (!foundTank) {
                    FluidStack newliquid;
                    CoordTuple possibleTank = this.structure.lavaTanks.get(iter);
                    TileEntity newTankContainer = this.world.func_147438_o(possibleTank.x, possibleTank.y, possibleTank.z);
                    if (newTankContainer instanceof IFluidHandler && (newliquid = ((IFluidHandler)newTankContainer).drain(ForgeDirection.UNKNOWN, this.drainFuelAmount(), false)) != null && newliquid.getFluid().getBlock() == Blocks.field_150353_l && newliquid.amount > 0) {
                        foundTank = true;
                        this.setActiveLavaTank(possibleTank);
                        iter = this.structure.lavaTanks.size();
                        FluidTankInfo[] info = ((IFluidHandler)tankContainer).getTankInfo(ForgeDirection.DOWN);
                        liquid = info[0].fluid;
                        int capacity = info[0].capacity;
                        if (liquid != null) {
                            this.fuelAmount = liquid.amount;
                            this.fuelGague = liquid.amount * 52 / capacity;
                        } else {
                            this.fuelAmount = 0;
                            this.fuelGague = 0;
                        }
                    }
                    if (++iter < this.structure.lavaTanks.size()) continue;
                    foundTank = true;
                }
            }
        }
    }

    public void setActiveLavaTank(CoordTuple coord) {
        this.activeLavaTank = coord;
    }

    private int drainFuelAmount() {
        if (this.activeTemps.length == 0) {
            return 0;
        }
        int amount = this.activeTemps.length / 3;
        if (amount < 150) {
            amount = 150;
        }
        return amount;
    }

    public FluidStack getResultFor(ItemStack stack) {
        return Smeltery.getSmelteryResult(stack);
    }

    public int getInternalTemperature() {
        return this.maxTemp;
    }

    public int getTempForSlot(int slot) {
        return this.activeTemps[slot];
    }

    public int getMeltingPointForSlot(int slot) {
        return this.meltingTemps[slot];
    }

    public int getScaledFuelGague(int scale) {
        int ret = this.fuelGague * scale / 52;
        if (ret < 1) {
            ret = 1;
        }
        return ret;
    }

    @Override
    public void readNetworkNBT(NBTTagCompound tags) {
        this.activeTemps = tags.func_74759_k("Temperature");
        this.meltingTemps = tags.func_74759_k("Melting");
        this.fuelAmount = tags.func_74762_e("Fuel");
        int[] tank = tags.func_74759_k("LavaTank");
        if (tank.length > 0) {
            this.activeLavaTank = new CoordTuple((double)tank[0], (double)tank[1], (double)tank[2]);
        }
    }

    @Override
    public void writeNetworkNBT(NBTTagCompound tags) {
        tags.func_74783_a("Temperature", this.activeTemps);
        tags.func_74783_a("Melting", this.meltingTemps);
        tags.func_74768_a("Fuel", this.fuelAmount);
        if (this.activeLavaTank != null) {
            tags.func_74783_a("LavaTank", new int[]{this.activeLavaTank.x, this.activeLavaTank.y, this.activeLavaTank.z});
        }
    }
}

