/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.component;

import java.util.ArrayList;
import mantle.blocks.iface.IServantLogic;
import mantle.world.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import tconstruct.library.component.TankLayerScan;
import tconstruct.smeltery.TinkerSmeltery;

public class SmelteryScan
extends TankLayerScan {
    public ArrayList<CoordTuple> lavaTanks = new ArrayList();

    public SmelteryScan(TileEntity te, Block ... id) {
        super(te, id);
    }

    @Override
    public void checkValidStructure() {
        this.lavaTanks.clear();
        super.checkValidStructure();
    }

    @Override
    protected boolean checkAir(int x, int y, int z) {
        Block block = this.world.func_147439_a(x, y, z);
        return block == null || this.world.func_147437_c(x, y, z) || block == TinkerSmeltery.tankAir;
    }

    @Override
    protected boolean checkServant(int x, int y, int z) {
        Block block = this.world.func_147439_a(x, y, z);
        if (block == null || this.world.func_147437_c(x, y, z) || !this.isValidBlock(x, y, z)) {
            return false;
        }
        if (!block.hasTileEntity(this.world.func_72805_g(x, y, z))) {
            return false;
        }
        TileEntity be = this.world.func_147438_o(x, y, z);
        if (be instanceof IServantLogic) {
            boolean ret = ((IServantLogic)be).setPotentialMaster(this.imaster, this.world, x, y, z);
            if (ret && block == TinkerSmeltery.lavaTank) {
                this.lavaTanks.add(new CoordTuple((double)x, (double)y, (double)z));
            }
            return ret;
        }
        return false;
    }

    @Override
    protected void finalizeStructure() {
        super.finalizeStructure();
        if (this.lavaTanks.size() < 1) {
            this.completeStructure = false;
        } else {
            for (CoordTuple coord : this.airCoords) {
                if (this.world.func_147439_a(coord.x, coord.y, coord.z) == TinkerSmeltery.tankAir) continue;
                this.world.func_147449_b(coord.x, coord.y, coord.z, TinkerSmeltery.tankAir);
                IServantLogic servant = (IServantLogic)this.world.func_147438_o(coord.x, coord.y, coord.z);
                servant.verifyMaster(this.imaster, this.world, this.master.field_145851_c, this.master.field_145848_d, this.master.field_145849_e);
            }
        }
    }

    @Override
    protected void invalidateStructure() {
        super.invalidateStructure();
        for (CoordTuple coord : this.airCoords) {
            TileEntity servant = this.world.func_147438_o(coord.x, coord.y, coord.z);
            if (!(servant instanceof IServantLogic)) continue;
            ((IServantLogic)servant).invalidateMaster(this.imaster, this.world, this.master.field_145851_c, this.master.field_145848_d, this.master.field_145849_e);
        }
    }

    @Override
    protected void invalidateBlocksAbove(int height) {
        for (CoordTuple coord : this.airCoords) {
            TileEntity servant;
            if (coord.y < height || !((servant = this.world.func_147438_o(coord.x, coord.y, coord.z)) instanceof IServantLogic)) continue;
            ((IServantLogic)servant).invalidateMaster(this.imaster, this.world, this.master.field_145851_c, this.master.field_145848_d, this.master.field_145849_e);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        for (CoordTuple coord : this.airCoords) {
            TileEntity te = this.world.func_147438_o(coord.x, coord.y, coord.z);
            if (te == null || !(te instanceof IServantLogic)) continue;
            ((IServantLogic)te).invalidateMaster(this.imaster, this.world, this.master.field_145851_c, this.master.field_145848_d, this.master.field_145849_e);
        }
    }

    @Override
    public void readNetworkNBT(NBTTagCompound tags) {
        super.readNetworkNBT(tags);
        NBTTagList tanks = tags.func_150295_c("Tanks", 10);
        if (tanks != null) {
            this.lavaTanks.clear();
            for (int i = 0; i < tanks.func_74745_c(); ++i) {
                int[] coord = tanks.func_150306_c(i);
                this.layerAirCoords.add(new CoordTuple((double)coord[0], (double)coord[1], (double)coord[2]));
            }
        }
    }

    @Override
    public void writeNetworkNBT(NBTTagCompound tags) {
        super.writeNetworkNBT(tags);
        NBTTagList tanks = new NBTTagList();
        for (CoordTuple coord : this.lavaTanks) {
            tanks.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{coord.x, coord.y, coord.z}));
        }
        tags.func_74782_a("Tanks", (NBTBase)tanks);
    }
}

