/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.HarvestLevels;
import tconstruct.tools.gui.ToolStationGuiHelper;
import tconstruct.tools.logic.CraftingStationLogic;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class CraftingStationGui
extends GuiContainer
implements INEIGuiHandler {
    public boolean active;
    public String toolName;
    public GuiTextField text;
    public String title;
    public String body = "";
    CraftingStationLogic logic;
    public static final int CHEST_WIDTH = 116;
    private int craftingLeft = 0;
    private int craftingTop = 0;
    private int craftingTextLeft = 0;
    private int descLeft = 0;
    private int descTop = 0;
    private int descTextLeft = 0;
    private int chestLeft = 0;
    private int chestTop = 0;
    private static final ResourceLocation background = new ResourceLocation("tinker", "textures/gui/tinkertable.png");
    private static final ResourceLocation description = new ResourceLocation("tinker", "textures/gui/description.png");
    private static final ResourceLocation icons = new ResourceLocation("tinker", "textures/gui/icons.png");
    private static final ResourceLocation chest = new ResourceLocation("tinker", "textures/gui/chestside.png");

    public CraftingStationGui(InventoryPlayer inventory, CraftingStationLogic logic, World world, int x, int y, int z) {
        super(logic.getGuiContainer(inventory, world, x, y, z));
        this.logic = logic;
        this.title = "\u00a7n" + StatCollector.func_74838_a((String)"gui.toolforge1");
        this.body = StatCollector.func_74838_a((String)"gui.toolforge2");
        this.toolName = "";
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.craftingLeft = this.field_147003_i;
        this.craftingTop = this.field_147009_r;
        if (this.logic.tinkerTable) {
            this.descLeft = this.field_147003_i + 176;
            this.descTop = this.craftingTop;
        }
        if (this.logic.chest != null) {
            this.field_146999_f += 116;
            this.field_147003_i -= 116;
            this.chestLeft = this.field_147003_i;
            this.chestTop = this.craftingTop;
            if (this.logic.doubleChest != null) {
                this.field_147000_g = 187;
            }
        }
        this.craftingTextLeft = this.craftingLeft - this.field_147003_i;
        this.descTextLeft = this.descLeft - this.field_147003_i;
    }

    protected void func_146979_b(int par1, int par2) {
        if (this.logic.chest != null) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)((IInventory)this.logic.chest.get()).func_145825_b()), 8, 6, 0x202020);
        }
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)(this.logic.tinkerTable ? "crafters.TinkerTable" : this.logic.getInvName())), this.craftingTextLeft + 8, 6, 0x202020);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), this.craftingTextLeft + 8, 72, 0x202020);
        if (this.logic.tinkerTable) {
            if (this.logic.isStackInSlot(0)) {
                this.drawToolStats(this.logic.func_70301_a(0));
            } else if (this.logic.isStackInSlot(5)) {
                if (!(this.logic.isStackInSlot(1) || this.logic.isStackInSlot(2) || this.logic.isStackInSlot(3) || this.logic.isStackInSlot(4) || this.logic.isStackInSlot(6) || this.logic.isStackInSlot(7) || this.logic.isStackInSlot(8) || this.logic.isStackInSlot(9))) {
                    this.drawToolStats(this.logic.func_70301_a(5));
                } else {
                    this.drawToolInformation();
                }
            } else {
                this.drawToolInformation();
            }
        }
    }

    void drawToolStats(ItemStack stack) {
        ToolMaterial material;
        int matID;
        if (stack.func_77973_b() instanceof IModifyable) {
            ToolStationGuiHelper.drawToolStats(stack, this.descTextLeft + 10, 0);
        }
        if ((matID = PatternBuilder.instance.getPartID(stack)) != Short.MAX_VALUE && matID > 0 && (material = TConstructRegistry.getMaterial(matID)) != null) {
            this.drawMaterialStats(material);
        }
    }

    protected void drawMaterialStats(ToolMaterial materialEnum) {
        String heart;
        int baseX = this.descTextLeft + 8;
        int baseY = 8;
        String centerTitle = "\u00a7n" + materialEnum.localizedName();
        this.func_73732_a(this.field_146289_q, centerTitle, baseX + 55, 8, 0xFFFFFF);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.partcrafter4") + materialEnum.durability(), baseX, 24, 0xFFFFFF);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.partcrafter5") + materialEnum.handleDurability() + "x", baseX, 35, 0xFFFFFF);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.partcrafter6") + (float)materialEnum.toolSpeed() / 100.0f, baseX, 46, 0xFFFFFF);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.partcrafter7") + HarvestLevels.getHarvestLevelName(materialEnum.harvestLevel()), baseX, 57, 0xFFFFFF);
        int attack = materialEnum.attack();
        String string = heart = attack == 2 ? StatCollector.func_74838_a((String)"gui.partcrafter8") : StatCollector.func_74838_a((String)"gui.partcrafter9");
        if (attack % 2 == 0) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.partcrafter10") + attack / 2 + heart, baseX, 68, 0xFFFFFF);
        } else {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.partcrafter10") + (float)attack / 2.0f + heart, baseX, 68, 0xFFFFFF);
        }
    }

    void drawToolInformation() {
        int offsetX = this.descTextLeft + 63;
        this.func_73732_a(this.field_146289_q, this.title, offsetX, 8, 0xFFFFFF);
        this.field_146289_q.func_78279_b(this.body, offsetX - 56, 24, 115, 0xFFFFFF);
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.craftingLeft, this.craftingTop, 0, 0, 176, 166);
        if (this.active) {
            this.func_73729_b(this.craftingLeft + 62, this.craftingTop, 0, 166, 112, 22);
        }
        this.field_146297_k.func_110434_K().func_110577_a(icons);
        if (this.logic.tinkerTable && !this.logic.isStackInSlot(5)) {
            this.func_73729_b(this.craftingLeft + 47, this.craftingTop + 33, 0, 233, 18, 18);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(icons);
        if (this.logic.chest != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(chest);
            if (this.logic.doubleChest == null) {
                this.func_73729_b(this.chestLeft, this.chestTop, 0, 0, 122, 114);
            } else {
                this.func_73729_b(this.chestLeft, this.chestTop, 125, 0, 122, 187);
            }
        }
        if (this.logic.tinkerTable) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(description);
            this.func_73729_b(this.descLeft, this.descTop, 0, 0, 126, 172);
        }
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        currentVisibility.showWidgets = this.field_146294_l - this.field_146999_f >= 107;
        if (this.field_147003_i < 58) {
            currentVisibility.showStateButtons = false;
        }
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        if (y + h - 4 < this.field_147009_r || y + 4 > this.field_147009_r + this.field_147000_g) {
            return false;
        }
        return x + 4 <= this.field_147003_i + this.field_146999_f + (this.logic.tinkerTable ? 126 : 0);
    }

    public boolean hasChest() {
        return this.logic.chest != null;
    }
}

