/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import mantle.common.network.AbstractPacket;
import mantle.common.network.PacketUpdateTE;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.TConstruct;
import tconstruct.smeltery.logic.SmelteryLogic;

public class SmelteryPacket
extends AbstractPacket {
    int dimension;
    int x;
    int y;
    int z;
    int fluidID;
    boolean isShiftPressed;

    public SmelteryPacket() {
    }

    public SmelteryPacket(int dimension, int x, int y, int z, boolean isShiftPressed, int fluidID) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.isShiftPressed = isShiftPressed;
        this.fluidID = fluidID;
    }

    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dimension);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeBoolean(this.isShiftPressed);
        buffer.writeInt(this.fluidID);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dimension = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.isShiftPressed = buffer.readBoolean();
        this.fluidID = buffer.readInt();
    }

    public void handleClientSide(EntityPlayer player) {
    }

    public void handleServerSide(EntityPlayer player) {
        World world = player.field_70170_p;
        TileEntity te = world.func_147438_o(this.x, this.y, this.z);
        if (te instanceof SmelteryLogic) {
            FluidStack temp = null;
            for (FluidStack liquid : ((SmelteryLogic)te).moltenMetal) {
                if (liquid.fluidID != this.fluidID) continue;
                temp = liquid;
            }
            if (temp != null) {
                ((SmelteryLogic)te).moltenMetal.remove(temp);
                if (this.isShiftPressed) {
                    ((SmelteryLogic)te).moltenMetal.add(temp);
                } else {
                    ((SmelteryLogic)te).moltenMetal.add(0, temp);
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            te.func_145841_b(data);
            TConstruct.packetPipeline.sendToDimension((AbstractPacket)new PacketUpdateTE(this.x, this.y, this.z, data), this.dimension);
        }
    }
}

