/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.ammo;

import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.DualMaterialToolPart;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.FletchlingLeafMaterial;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.weaponry.TinkerWeaponry;

public class BoltAmmo
extends AmmoItem {
    public BoltAmmo() {
        super(0, "Bolts");
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_bolt_head";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "_bolt_shaft";
            }
            case 3: {
                return "_bolt_fletching";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_bolt_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "bolt";
    }

    @Override
    public void registerPartPaths(int index, String[] location) {
        this.headStrings.put(index, location[0]);
        this.handleStrings.put(index, location[2]);
    }

    @Override
    public void registerAlternatePartPaths(int index, String[] location) {
        this.accessoryStrings.put(index, location[3]);
    }

    @Override
    public Item getHeadItem() {
        return TinkerWeaponry.partBolt;
    }

    @Override
    public Item getHandleItem() {
        return TinkerWeaponry.partBolt;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerWeaponry.fletching;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"ammo", "projectile", "weapon"};
    }

    @Override
    public void buildTool(int id, String name, List list) {
        ItemStack handleStack;
        if (TConstructRegistry.getArrowMaterial(id) == null) {
            return;
        }
        ItemStack headStack = DualMaterialToolPart.createDualMaterial(this.getHeadItem(), id, 2);
        ItemStack tool = ToolBuilder.instance.buildTool(headStack, handleStack = new ItemStack(this.getAccessoryItem(), 1, 0), null, null, "");
        if (tool != null) {
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            list.add(tool);
        }
    }

    @Override
    protected int getDefaultColor(int renderPass, int materialID) {
        if (renderPass != 2) {
            return super.getDefaultColor(renderPass, materialID);
        }
        CustomMaterial mat = TConstructRegistry.getCustomMaterial(materialID, FletchingMaterial.class);
        if (mat == null) {
            mat = TConstructRegistry.getCustomMaterial(materialID, FletchlingLeafMaterial.class);
        }
        if (mat == null) {
            return 0xFFFFFF;
        }
        return mat.color;
    }

    @Override
    public String getAbilityNameForType(int type, int part) {
        if (part >= 2) {
            return "";
        }
        return super.getAbilityNameForType(type, part);
    }
}

