/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeClearing;
import twilightforest.biomes.TFBiomeDarkForest;
import twilightforest.biomes.TFBiomeDarkForestCenter;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.biomes.TFBiomeDeepMushrooms;
import twilightforest.biomes.TFBiomeEnchantedForest;
import twilightforest.biomes.TFBiomeFireSwamp;
import twilightforest.biomes.TFBiomeFireflyForest;
import twilightforest.biomes.TFBiomeGlacier;
import twilightforest.biomes.TFBiomeHighlands;
import twilightforest.biomes.TFBiomeHighlandsCenter;
import twilightforest.biomes.TFBiomeMushrooms;
import twilightforest.biomes.TFBiomeOakSavanna;
import twilightforest.biomes.TFBiomeSnow;
import twilightforest.biomes.TFBiomeStream;
import twilightforest.biomes.TFBiomeSwamp;
import twilightforest.biomes.TFBiomeThornlands;
import twilightforest.biomes.TFBiomeTwilightForest;
import twilightforest.biomes.TFBiomeTwilightForestVariant;
import twilightforest.biomes.TFBiomeTwilightLake;
import twilightforest.entity.EntityTFKobold;
import twilightforest.entity.passive.EntityTFBighorn;
import twilightforest.entity.passive.EntityTFBoar;
import twilightforest.entity.passive.EntityTFBunny;
import twilightforest.entity.passive.EntityTFDeer;
import twilightforest.entity.passive.EntityTFMobileFirefly;
import twilightforest.entity.passive.EntityTFRaven;
import twilightforest.entity.passive.EntityTFSquirrel;
import twilightforest.entity.passive.EntityTFTinyBird;

public abstract class TFBiomeBase
extends BiomeGenBase {
    public static final BiomeGenBase tfLake;
    public static final BiomeGenBase twilightForest;
    public static final BiomeGenBase twilightForest2;
    public static final BiomeGenBase highlands;
    public static final BiomeGenBase mushrooms;
    public static final BiomeGenBase tfSwamp;
    public static final BiomeGenBase stream;
    public static final BiomeGenBase tfSnow;
    public static final BiomeGenBase glacier;
    public static final BiomeGenBase clearing;
    public static final BiomeGenBase oakSavanna;
    public static final BiomeGenBase fireflyForest;
    public static final BiomeGenBase deepMushrooms;
    public static final BiomeGenBase darkForest;
    public static final BiomeGenBase enchantedForest;
    public static final BiomeGenBase fireSwamp;
    public static final BiomeGenBase darkForestCenter;
    public static final BiomeGenBase highlandsCenter;
    public static final BiomeGenBase thornlands;
    protected WorldGenBigMushroom bigMushroomGen = new WorldGenBigMushroom();
    protected WorldGenForest birchGen = new WorldGenForest(false, false);
    protected List<BiomeGenBase.SpawnListEntry> undergroundMonsterList;

    public TFBiomeBase(int i) {
        super(i);
        this.field_76758_O = null;
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76762_K.clear();
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityTFBighorn.class, 12, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityTFBoar.class, 10, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityChicken.class, 10, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityTFDeer.class, 15, 4, 5));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityWolf.class, 5, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityTFTinyBird.class, 15, 4, 8));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityTFSquirrel.class, 10, 2, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityTFBunny.class, 10, 4, 5));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityTFRaven.class, 10, 1, 2));
        this.undergroundMonsterList = new ArrayList<BiomeGenBase.SpawnListEntry>();
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntitySpider.class, 10, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityZombie.class, 10, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 10, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityCreeper.class, 1, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntitySlime.class, 10, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 1, 1, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityTFKobold.class, 10, 4, 8));
        this.field_82914_M.add(new BiomeGenBase.SpawnListEntry(EntityTFMobileFirefly.class, 10, 8, 8));
        this.getTFBiomeDecorator().setTreesPerChunk(10);
        this.getTFBiomeDecorator().setGrassPerChunk(2);
    }

    public TFBiomeBase setColor(int par1) {
        return (TFBiomeBase)super.func_76739_b(par1);
    }

    public float func_76741_f() {
        return 0.12f;
    }

    public BiomeDecorator func_76729_a() {
        return new TFBiomeDecorator();
    }

    protected TFBiomeDecorator getTFBiomeDecorator() {
        return (TFBiomeDecorator)this.field_76760_I;
    }

    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(5) == 0) {
            return this.birchGen;
        }
        if (random.nextInt(10) == 0) {
            return new WorldGenBigTree(false);
        }
        return this.field_76757_N;
    }

    public WorldGenerator func_76730_b(Random par1Random) {
        if (par1Random.nextInt(4) == 0) {
            return new WorldGenTallGrass((Block)Blocks.field_150329_H, 2);
        }
        return new WorldGenTallGrass((Block)Blocks.field_150329_H, 1);
    }

    public static boolean assignBlankBiomeIds() {
        boolean assigned = false;
        boolean[] usedIDs = new boolean[BiomeGenBase.func_150565_n().length];
        TFBiomeBase.checkUsedIDs(usedIDs);
        TwilightForestMod.idBiomeLake = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeLake);
        TwilightForestMod.idBiomeTwilightForest = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeTwilightForest);
        TwilightForestMod.idBiomeTwilightForestVariant = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeTwilightForestVariant);
        TwilightForestMod.idBiomeHighlands = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeHighlands);
        TwilightForestMod.idBiomeMushrooms = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeMushrooms);
        TwilightForestMod.idBiomeSwamp = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeSwamp);
        TwilightForestMod.idBiomeStream = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeStream);
        TwilightForestMod.idBiomeSnowfield = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeSnowfield);
        TwilightForestMod.idBiomeGlacier = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeGlacier);
        TwilightForestMod.idBiomeClearing = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeClearing);
        TwilightForestMod.idBiomeOakSavanna = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeOakSavanna);
        TwilightForestMod.idBiomeFireflyForest = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeFireflyForest);
        TwilightForestMod.idBiomeDeepMushrooms = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeDeepMushrooms);
        TwilightForestMod.idBiomeDarkForestCenter = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeDarkForestCenter);
        TwilightForestMod.idBiomeHighlandsCenter = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeHighlandsCenter);
        TwilightForestMod.idBiomeDarkForest = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeDarkForest);
        TwilightForestMod.idBiomeEnchantedForest = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeEnchantedForest);
        TwilightForestMod.idBiomeFireSwamp = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeFireSwamp);
        TwilightForestMod.idBiomeThornlands = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeThornlands);
        return assigned;
    }

    private static void checkUsedIDs(boolean[] usedIDs) {
        for (int i = 0; i < usedIDs.length; ++i) {
            usedIDs[i] = BiomeGenBase.func_150565_n()[i] != null;
        }
    }

    private static int assignIdIfNeeded(boolean[] usedIDs, int biomeID) {
        if (biomeID == -1) {
            biomeID = TFBiomeBase.findNextOpenBiomeId(usedIDs);
            TwilightForestMod.hasAssignedBiomeID = true;
        }
        return biomeID;
    }

    private static int findNextOpenBiomeId(boolean[] usedIDs) {
        for (int i = 0; i < 256; ++i) {
            if (usedIDs[i]) continue;
            usedIDs[i] = true;
            return i;
        }
        FMLLog.warning((String)"[TwilightForest] Could not find open biome ID.  Edit the Twilight Forest config to give all biomes unique IDs.", (Object[])new Object[0]);
        return -1;
    }

    public static boolean areThereBiomeIdConflicts() {
        boolean conflict = TwilightForestMod.hasBiomeIdConflicts;
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeLake);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeTwilightForest);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeTwilightForestVariant);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeHighlands);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeMushrooms);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeSwamp);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeStream);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeSnowfield);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeGlacier);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeClearing);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeOakSavanna);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeFireflyForest);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeDeepMushrooms);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeDarkForestCenter);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeHighlandsCenter);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeDarkForest);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeEnchantedForest);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeFireSwamp);
        if (conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeThornlands)) {
            FMLLog.warning((String)"[TwilightForest] Biome ID conflict detected.  Edit the Twilight Forest config to give all biomes unique IDs.", (Object[])new Object[0]);
        }
        TwilightForestMod.hasBiomeIdConflicts |= conflict;
        return conflict;
    }

    public static boolean isConflictAtBiomeID(int id) {
        BiomeGenBase biomeAt = BiomeGenBase.func_150568_d((int)id);
        if (biomeAt == null || biomeAt instanceof TFBiomeBase) {
            return false;
        }
        FMLLog.warning((String)"[TwilightForest] Biome ID conflict.  Biome ID %d contains a biome named %s, but Twilight Forest is set to use that ID.", (Object[])new Object[]{id, biomeAt.field_76791_y});
        return true;
    }

    public static void registerWithBiomeDictionary() {
        BiomeDictionary.registerBiomeType((BiomeGenBase)tfLake, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OCEAN});
        BiomeDictionary.registerBiomeType((BiomeGenBase)twilightForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)twilightForest2, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE});
        BiomeDictionary.registerBiomeType((BiomeGenBase)highlands, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.CONIFEROUS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)mushrooms, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM});
        BiomeDictionary.registerBiomeType((BiomeGenBase)tfSwamp, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET});
        BiomeDictionary.registerBiomeType((BiomeGenBase)stream, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER});
        BiomeDictionary.registerBiomeType((BiomeGenBase)tfSnow, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)glacier, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.registerBiomeType((BiomeGenBase)clearing, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE});
        BiomeDictionary.registerBiomeType((BiomeGenBase)oakSavanna, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPARSE});
        BiomeDictionary.registerBiomeType((BiomeGenBase)fireflyForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH});
        BiomeDictionary.registerBiomeType((BiomeGenBase)deepMushrooms, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM});
        BiomeDictionary.registerBiomeType((BiomeGenBase)darkForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.registerBiomeType((BiomeGenBase)enchantedForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.registerBiomeType((BiomeGenBase)fireSwamp, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HOT});
        BiomeDictionary.registerBiomeType((BiomeGenBase)darkForestCenter, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.registerBiomeType((BiomeGenBase)highlandsCenter, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MESA, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.registerBiomeType((BiomeGenBase)thornlands, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND});
    }

    public void func_150573_a(World world, Random rand, Block[] blockStorage, byte[] metaStorage, int x, int z, double stoneNoise) {
        this.genTwilightBiomeTerrain(world, rand, blockStorage, metaStorage, x, z, stoneNoise);
    }

    public void genTwilightBiomeTerrain(World world, Random rand, Block[] blockStorage, byte[] metaStorage, int x, int z, double stoneNoise) {
        Block topBlock = this.field_76752_A;
        byte topMeta = (byte)(this.field_150604_aj & 0xFF);
        Block fillerBlock = this.field_76753_B;
        byte fillerMeta = (byte)(this.field_76754_C & 0xFF);
        int currentFillerDepth = -1;
        int maxFillerDepth = (int)(stoneNoise / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int maskX = x & 0xF;
        int maskZ = z & 0xF;
        int worldHeight = blockStorage.length / 256;
        int seaLevel = 32;
        for (int y = 255; y >= 0; --y) {
            int index = (maskZ * 16 + maskX) * worldHeight + y;
            if (y <= 0 + rand.nextInt(5)) {
                blockStorage[index] = Blocks.field_150357_h;
                continue;
            }
            Block currentBlock = blockStorage[index];
            if (currentBlock == null || currentBlock.func_149688_o() == Material.field_151579_a || currentBlock != Blocks.field_150348_b) continue;
            if (this.getStoneReplacementBlock() != null) {
                blockStorage[index] = this.getStoneReplacementBlock();
                metaStorage[index] = this.getStoneReplacementMeta();
            }
            if (currentFillerDepth == -1) {
                if (maxFillerDepth <= 0) {
                    topBlock = null;
                    topMeta = 0;
                    fillerBlock = Blocks.field_150348_b;
                    fillerMeta = 0;
                } else if (y >= seaLevel - 5 && y <= seaLevel) {
                    topBlock = this.field_76752_A;
                    topMeta = (byte)(this.field_150604_aj & 0xFF);
                    fillerBlock = this.field_76753_B;
                    fillerMeta = (byte)(this.field_76754_C & 0xFF);
                }
                if (y < seaLevel - 1 && (topBlock == null || topBlock.func_149688_o() == Material.field_151579_a)) {
                    if (this.func_150564_a(x, y, z) < 0.15f) {
                        topBlock = Blocks.field_150432_aD;
                        topMeta = 0;
                    } else {
                        topBlock = Blocks.field_150355_j;
                        topMeta = 0;
                    }
                }
                currentFillerDepth = maxFillerDepth;
                if (y >= seaLevel - 2) {
                    blockStorage[index] = topBlock;
                    metaStorage[index] = topMeta;
                    continue;
                }
                if (y < seaLevel - 8 - maxFillerDepth) {
                    topBlock = null;
                    fillerBlock = Blocks.field_150348_b;
                    fillerMeta = 0;
                    blockStorage[index] = Blocks.field_150351_n;
                    continue;
                }
                blockStorage[index] = fillerBlock;
                metaStorage[index] = fillerMeta;
                continue;
            }
            if (currentFillerDepth <= 0) continue;
            blockStorage[index] = fillerBlock;
            metaStorage[index] = fillerMeta;
            if (--currentFillerDepth != 0 || fillerBlock != Blocks.field_150354_m) continue;
            currentFillerDepth = rand.nextInt(4) + Math.max(0, y - (seaLevel - 1));
            fillerBlock = Blocks.field_150322_A;
            fillerMeta = 0;
        }
    }

    public Block getStoneReplacementBlock() {
        return null;
    }

    public byte getStoneReplacementMeta() {
        return 0;
    }

    public boolean doesPlayerHaveRequiredAchievement(EntityPlayer player) {
        if (this.getRequiredAchievement() != null && player instanceof EntityPlayerMP && ((EntityPlayerMP)player).func_147099_x() != null) {
            StatisticsFile stats = ((EntityPlayerMP)player).func_147099_x();
            return stats.func_77443_a(this.getRequiredAchievement());
        }
        if (this.getRequiredAchievement() != null && player instanceof EntityClientPlayerMP && ((EntityClientPlayerMP)player).func_146107_m() != null) {
            StatFileWriter stats = ((EntityClientPlayerMP)player).func_146107_m();
            return stats.func_77443_a(this.getRequiredAchievement());
        }
        return true;
    }

    protected Achievement getRequiredAchievement() {
        return null;
    }

    public void enforceProgession(EntityPlayer player, World world) {
    }

    public List<BiomeGenBase.SpawnListEntry> getUndergroundSpawnableList() {
        return this.undergroundMonsterList;
    }

    static {
        TFBiomeBase.assignBlankBiomeIds();
        TFBiomeBase.areThereBiomeIdConflicts();
        tfLake = new TFBiomeTwilightLake(TwilightForestMod.idBiomeLake).setColor(255).func_76735_a("Twilight Lake").func_150570_a(field_150592_d);
        twilightForest = new TFBiomeTwilightForest(TwilightForestMod.idBiomeTwilightForest).setColor(21760).func_76735_a("Twilight Forest");
        twilightForest2 = new TFBiomeTwilightForestVariant(TwilightForestMod.idBiomeTwilightForestVariant).setColor(21794).func_76735_a("Dense Twilight Forest").func_150570_a(field_150590_f);
        highlands = new TFBiomeHighlands(TwilightForestMod.idBiomeHighlands).setColor(0x556644).func_76735_a("Twilight Highlands").func_150570_a(new BiomeGenBase.Height(3.5f, 0.05f));
        mushrooms = new TFBiomeMushrooms(TwilightForestMod.idBiomeMushrooms).setColor(0x226622).func_76735_a("Mushroom Forest");
        tfSwamp = new TFBiomeSwamp(TwilightForestMod.idBiomeSwamp).setColor(0x334422).func_76735_a("Twilight Swamp").func_150570_a(new BiomeGenBase.Height(-0.125f, 0.125f));
        stream = new TFBiomeStream(TwilightForestMod.idBiomeStream).setColor(3298231).func_76735_a("Twilight Stream").func_150570_a(field_150594_b);
        tfSnow = new TFBiomeSnow(TwilightForestMod.idBiomeSnowfield).setColor(0xCCFFFF).func_76735_a("Snowy Forest").func_150570_a(field_150590_f);
        glacier = new TFBiomeGlacier(TwilightForestMod.idBiomeGlacier).setColor(0x7777BB).func_76735_a("Twilight Glacier");
        clearing = new TFBiomeClearing(TwilightForestMod.idBiomeClearing).setColor(3447604).func_76735_a("Twilight Clearing").func_150570_a(field_150593_e);
        oakSavanna = new TFBiomeOakSavanna(TwilightForestMod.idBiomeOakSavanna).setColor(0x446622).func_76735_a("Oak Savanna").func_150570_a(field_150590_f);
        fireflyForest = new TFBiomeFireflyForest(TwilightForestMod.idBiomeFireflyForest).setColor(26163).func_76735_a("Firefly Forest").func_150570_a(field_150593_e);
        deepMushrooms = new TFBiomeDeepMushrooms(TwilightForestMod.idBiomeDeepMushrooms).setColor(0x663322).func_76735_a("Deep Mushroom Forest").func_150570_a(field_150593_e);
        darkForest = new TFBiomeDarkForest(TwilightForestMod.idBiomeDarkForest).setColor(13073).func_76735_a("Dark Forest").func_150570_a(field_150593_e);
        enchantedForest = new TFBiomeEnchantedForest(TwilightForestMod.idBiomeEnchantedForest).setColor(0x115566).func_76735_a("Enchanted Forest");
        fireSwamp = new TFBiomeFireSwamp(TwilightForestMod.idBiomeFireSwamp).setColor(4334362).func_76735_a("Fire Swamp").func_150570_a(field_150596_a);
        darkForestCenter = new TFBiomeDarkForestCenter(TwilightForestMod.idBiomeDarkForestCenter).setColor(8704).func_76735_a("Dark Forest Center").func_150570_a(field_150593_e);
        highlandsCenter = new TFBiomeHighlandsCenter(TwilightForestMod.idBiomeHighlandsCenter).setColor(0x334422).func_76735_a("Highlands Center").func_150570_a(new BiomeGenBase.Height(10.5f, 0.025f));
        thornlands = new TFBiomeThornlands(TwilightForestMod.idBiomeThornlands).setColor(0x223322).func_76735_a("Thornlands").func_150570_a(new BiomeGenBase.Height(6.0f, 0.1f));
    }
}

