/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenVines;
import net.minecraft.world.gen.feature.WorldGenerator;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenLargeRainboak;
import twilightforest.world.TFGenSmallRainboak;
import twilightforest.world.TFWorld;

public class TFBiomeEnchantedForest
extends TFBiomeBase {
    Random colorRNG = new Random();

    public TFBiomeEnchantedForest(int i) {
        super(i);
        this.getTFBiomeDecorator().setGrassPerChunk(12);
        this.getTFBiomeDecorator().setFlowersPerChunk(8);
    }

    public int func_150558_b(int x, int y, int z) {
        return (super.func_150558_b(x, y, z) & 0xFFFF00) + this.getEnchantedColor(x, z);
    }

    public int func_150571_c(int x, int y, int z) {
        return (super.func_150571_c(x, y, z) & 0xFFFF00) + this.getEnchantedColor(x, z);
    }

    private int getEnchantedColor(int x, int z) {
        int randomFlicker;
        int cx = 256 * Math.round((float)(x - 8) / 256.0f) + 8;
        int cz = 256 * Math.round((float)(z - 8) / 256.0f) + 8;
        int dist = (int)MathHelper.func_76129_c((float)((cx - x) * (cx - x) + (cz - z) * (cz - z)));
        int color = dist * 64;
        if ((color %= 512) > 255) {
            color = 511 - color;
        }
        if (0 < (color = 255 - color) + (randomFlicker = this.colorRNG.nextInt(32) - 16) && color + randomFlicker > 255) {
            color += randomFlicker;
        }
        return color;
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(15) == 0) {
            return new TFGenSmallRainboak();
        }
        if (random.nextInt(50) == 0) {
            return new TFGenLargeRainboak();
        }
        if (random.nextInt(5) == 0) {
            return this.birchGen;
        }
        if (random.nextInt(10) == 0) {
            return new WorldGenBigTree(false);
        }
        return this.field_76757_N;
    }

    @Override
    public WorldGenerator func_76730_b(Random par1Random) {
        if (par1Random.nextInt(3) > 0) {
            return new WorldGenTallGrass((Block)Blocks.field_150329_H, 2);
        }
        if (par1Random.nextInt(3) == 0) {
            return new WorldGenTallGrass(TFBlocks.plant, 8);
        }
        return new WorldGenTallGrass((Block)Blocks.field_150329_H, 1);
    }

    public void func_76728_a(World par1World, Random par2Random, int par3, int par4) {
        int i;
        super.func_76728_a(par1World, par2Random, par3, par4);
        WorldGenVines worldgenvines = new WorldGenVines();
        for (i = 0; i < 20; ++i) {
            int j = par3 + par2Random.nextInt(16) + 8;
            byte byte0 = (byte)TFWorld.SEALEVEL;
            int k = par4 + par2Random.nextInt(16) + 8;
            worldgenvines.func_76484_a(par1World, par2Random, j, (int)byte0, k);
        }
        field_150610_ae.func_150548_a(3);
        for (i = 0; i < 20; ++i) {
            int rx = par3 + par2Random.nextInt(16) + 8;
            int rz = par4 + par2Random.nextInt(16) + 8;
            int ry = par2Random.nextInt(par1World.func_72976_f(rx, rz) + 32);
            field_150610_ae.func_76484_a(par1World, par2Random, rx, ry, rz);
        }
        super.func_76728_a(par1World, par2Random, par3, par4);
    }

    public String func_150572_a(Random p_150572_1_, int p_150572_2_, int p_150572_3_, int p_150572_4_) {
        return p_150572_1_.nextInt(3) > 0 ? BlockFlower.field_149859_a[1] : (p_150572_1_.nextBoolean() ? BlockFlower.field_149859_a[2] : BlockFlower.field_149859_a[3]);
    }
}

