/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.api;

import java.util.LinkedList;
import java.util.List;

public class UnitDisplay {
    public Unit unit;
    public double value;
    public boolean useSymbol = false;
    public int decimalPlaces = 2;
    public boolean isSimple = false;

    public UnitDisplay(Unit unit, double value, boolean simple) {
        this.unit = unit;
        this.value = value;
    }

    public UnitDisplay(Unit unit, double value) {
        this(unit, value, false);
    }

    @Deprecated
    public UnitDisplay(double value, Unit unit) {
        this(unit, value);
    }

    public static double roundDecimals(double d, int decimalPlaces) {
        int j = (int)(d * Math.pow(10.0, decimalPlaces));
        return (double)j / Math.pow(10.0, decimalPlaces);
    }

    public static double roundDecimals(double d) {
        return UnitDisplay.roundDecimals(d, 2);
    }

    public UnitDisplay multiply(double value) {
        this.value *= value;
        return this;
    }

    public UnitDisplay simple() {
        this.isSimple = true;
        return this;
    }

    public UnitDisplay symbol() {
        return this.symbol(true);
    }

    public UnitDisplay symbol(boolean useSymbol) {
        this.useSymbol = useSymbol;
        return this;
    }

    public UnitDisplay decimal(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
        return this;
    }

    public String toString() {
        String unitName = this.unit.name;
        String prefix = "";
        if (this.isSimple) {
            if (this.value > 1.0) {
                if (this.decimalPlaces < 1) {
                    return (int)this.value + " " + this.unit.getPlural();
                }
                return UnitDisplay.roundDecimals(this.value, this.decimalPlaces) + " " + this.unit.getPlural();
            }
            if (this.decimalPlaces < 1) {
                return (int)this.value + " " + this.unit.name;
            }
            return UnitDisplay.roundDecimals(this.value, this.decimalPlaces) + " " + this.unit.name;
        }
        if (this.value < 0.0) {
            this.value = Math.abs(this.value);
            prefix = "-";
        }
        if (this.useSymbol) {
            unitName = this.unit.symbol;
        } else if (this.value > 1.0) {
            unitName = this.unit.getPlural();
        }
        if (this.value == 0.0) {
            return this.value + " " + unitName;
        }
        for (int i = 0; i < UnitPrefix.unitPrefixes.size(); ++i) {
            UnitPrefix lowerMeasure = UnitPrefix.unitPrefixes.get(i);
            if (lowerMeasure.isBellow(this.value) && i == 0) {
                return prefix + UnitDisplay.roundDecimals(lowerMeasure.process(this.value), this.decimalPlaces) + " " + lowerMeasure.getName(this.useSymbol) + unitName;
            }
            if (i + 1 >= UnitPrefix.unitPrefixes.size()) {
                return prefix + UnitDisplay.roundDecimals(lowerMeasure.process(this.value), this.decimalPlaces) + " " + lowerMeasure.getName(this.useSymbol) + unitName;
            }
            UnitPrefix upperMeasure = UnitPrefix.unitPrefixes.get(i + 1);
            if ((!lowerMeasure.isAbove(this.value) || !upperMeasure.isBellow(this.value)) && lowerMeasure.value != this.value) continue;
            return prefix + UnitDisplay.roundDecimals(lowerMeasure.process(this.value), this.decimalPlaces) + " " + lowerMeasure.getName(this.useSymbol) + unitName;
        }
        return prefix + UnitDisplay.roundDecimals(this.value, this.decimalPlaces) + " " + unitName;
    }

    public static class UnitPrefix {
        public static final List<UnitPrefix> unitPrefixes = new LinkedList<UnitPrefix>();
        public static final UnitPrefix MICRO = new UnitPrefix("Micro", "u", 1.0E-6);
        public static final UnitPrefix MILLI = new UnitPrefix("Milli", "m", 0.001);
        public static final UnitPrefix BASE = new UnitPrefix("", "", 1.0);
        public static final UnitPrefix KILO = new UnitPrefix("Kilo", "k", 1000.0);
        public static final UnitPrefix MEGA = new UnitPrefix("Mega", "M", 1000000.0);
        public static final UnitPrefix GIGA = new UnitPrefix("Giga", "G", 1.0E9);
        public static final UnitPrefix TERA = new UnitPrefix("Tera", "T", 1.0E12);
        public static final UnitPrefix PETA = new UnitPrefix("Peta", "P", 1.0E15);
        public static final UnitPrefix EXA = new UnitPrefix("Exa", "E", 1.0E18);
        public static final UnitPrefix ZETTA = new UnitPrefix("Zetta", "Z", 1.0E21);
        public static final UnitPrefix YOTTA = new UnitPrefix("Yotta", "Y", 1.0E24);
        public final String name;
        public final String symbol;
        public final double value;

        private UnitPrefix(String name, String symbol, double value) {
            this.name = name;
            this.symbol = symbol;
            this.value = value;
            unitPrefixes.add(this);
        }

        public String getName(boolean getShort) {
            if (getShort) {
                return this.symbol;
            }
            return this.name;
        }

        public double process(double value) {
            return value / this.value;
        }

        public boolean isAbove(double value) {
            return value > this.value;
        }

        public boolean isBellow(double value) {
            return value < this.value;
        }
    }

    public static class Unit {
        public static final Unit AMPERE = new Unit("Amp", "I");
        public static final Unit AMP_HOUR = new Unit("Amp Hour", "Ah");
        public static final Unit VOLTAGE = new Unit("Volt", "V");
        public static final Unit WATT = new Unit("Watt", "W");
        public static final Unit WATT_HOUR = new Unit("Watt Hour", "Wh");
        public static final Unit RESISTANCE = new Unit("Ohm", "R");
        public static final Unit CONDUCTANCE = new Unit("Siemen", "S");
        public static final Unit JOULES = new Unit("Joule", "J");
        public static final Unit LITER = new Unit("Liter", "L");
        public static final Unit NEWTON_METER = new Unit("Newton Meter", "Nm");
        public static final Unit REDFLUX = new Unit("Redstone-Flux", "Rf");
        public static final Unit MINECRAFT_JOULES = new Unit("Minecraft-Joules", "Mj");
        public static final Unit ELECTRICAL_UNITS = new Unit("Electrical-Units", "Eu");
        public final String name;
        public final String symbol;

        private Unit(String name, String symbol) {
            this.name = name;
            this.symbol = symbol;
        }

        public String getPlural() {
            return this.name + "s";
        }
    }
}

