/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.compatibility.asm;

import com.google.common.collect.HashBiMap;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import universalelectricity.api.core.grid.INodeProvider;
import universalelectricity.api.item.IEnergyItem;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.compatibility.asm.ASMHelper;
import universalelectricity.compatibility.asm.TemplateInjectionManager;

public class UniversalTransformer
implements IClassTransformer {
    static LaunchClassLoader cl = (LaunchClassLoader)UniversalTransformer.class.getClassLoader();

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.startsWith("net.minecraft") || TemplateInjectionManager.tileTemplates.isEmpty()) {
            return bytes;
        }
        boolean changed = false;
        ClassNode cnode = ASMHelper.createClassNode(bytes);
        if (cnode != null && cnode.visibleAnnotations != null) {
            for (AnnotationNode nodes : cnode.visibleAnnotations) {
                if (!nodes.desc.equals("Luniversalelectricity/api/UniversalClass;")) continue;
                String flags = null;
                if (nodes.values != null && nodes.values.size() >= 2) {
                    flags = (String)nodes.values.get(1);
                }
                int transformationType = -1;
                if (cnode.interfaces.contains(INodeProvider.class.getName().replace(".", "/"))) {
                    transformationType = 0;
                } else if (cnode.interfaces.contains(IEnergyItem.class.getName().replace(".", "/"))) {
                    transformationType = 1;
                }
                if (transformationType == 0) {
                    changed |= this.injectTemplate(cnode, flags, TemplateInjectionManager.tileTemplates);
                    break;
                }
                if (transformationType == 1) {
                    changed |= this.injectTemplate(cnode, flags, TemplateInjectionManager.itemTemplates);
                    break;
                }
                System.out.println("[Universal Electricity] Failed to inject class " + cnode.name + " due to missing required interfaces.");
                break;
            }
        }
        return changed ? ASMHelper.createBytes(cnode, 2) : bytes;
    }

    private boolean injectTemplate(ClassNode cnode, String flags, HashBiMap<String, TemplateInjectionManager.InjectionTemplate> templates) {
        boolean changed = false;
        if (flags == null || flags.equals("")) {
            for (TemplateInjectionManager.InjectionTemplate template : templates.values()) {
                if (template == null || !Compatibility.getHandler((Object)templates.inverse().get((Object)template), null).isEnabled) continue;
                changed |= template.patch(cnode, false);
                System.out.println("[Universal Electricity] Injected " + template.className + " API into: " + cnode.name);
            }
        } else {
            String[] separatedFlags;
            for (String separated : separatedFlags = flags.split(";")) {
                TemplateInjectionManager.InjectionTemplate template;
                if (Compatibility.getHandler(separated, null) == null || !Compatibility.getHandler((Object)separated, null).isEnabled || (template = (TemplateInjectionManager.InjectionTemplate)templates.get((Object)separated)) == null) continue;
                changed |= template.patch(cnode, false);
                System.out.println("[Universal Electricity] Injected " + template.className + " API into: " + cnode.name);
            }
        }
        return changed;
    }
}

