/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.grid;

import java.util.HashSet;
import java.util.Set;
import universalelectricity.api.core.grid.IGrid;

public class Grid<N>
implements IGrid<N> {
    final Class nodeClass;
    private final Set<N> nodes = new HashSet<N>();

    public Grid(Class node) {
        this.nodeClass = node;
    }

    @Override
    public void deconstruct() {
        this.nodes.clear();
    }

    @Override
    public void reconstruct() {
        for (N node : this.getNodes()) {
            if (this.isValidNode(node)) {
                this.reconstructNode(node);
                continue;
            }
            this.nodes.remove(node);
        }
    }

    protected void reconstructNode(N node) {
    }

    public boolean isValidNode(Object node) {
        return this.nodeClass.isAssignableFrom(node.getClass());
    }

    @Override
    public void add(N node) {
        this.nodes.add(node);
    }

    @Override
    public void remove(N node) {
        this.nodes.remove(node);
    }

    @Override
    public Set<N> getNodes() {
        return this.nodes;
    }

    public N getFirstNode() {
        return (N)this.nodes.toArray()[0];
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.hashCode() + ", Nodes: " + this.nodes.size() + "]";
    }
}

