/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.grid.node;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import universalelectricity.api.core.grid.IConnector;
import universalelectricity.api.core.grid.INode;
import universalelectricity.api.core.grid.INodeProvider;
import universalelectricity.core.grid.Node;

public class NodeConnector
extends Node
implements IConnector {
    protected byte connectionMap = (byte)63;
    protected final WeakHashMap<Object, ForgeDirection> connections = new WeakHashMap();

    public NodeConnector(INodeProvider parent) {
        super(parent);
    }

    @Override
    public Map<Object, ForgeDirection> getConnections() {
        return this.connections;
    }

    @Override
    public boolean canConnect(ForgeDirection direction, Object object) {
        return object != null && this.isValidConnection(object) && this.canConnect(direction);
    }

    public boolean canConnect(ForgeDirection from) {
        return (this.connectionMap & 1 << from.ordinal()) != 0 || from == ForgeDirection.UNKNOWN;
    }

    public boolean isValidConnection(Object object) {
        return object != null && object.getClass().isAssignableFrom(this.getClass());
    }

    @Override
    public void deconstruct() {
        super.deconstruct();
        if (this.connections != null) {
            this.connections.clear();
        }
    }

    @Override
    public void reconstruct() {
        super.reconstruct();
        this.buildConnections();
    }

    protected void buildConnections() {
        this.connections.clear();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile;
            INode node;
            if (!this.canConnect(direction) || (node = this.getNodeFrom(tile = this.position().add(direction).getTileEntity(), direction.getOpposite())) == null) continue;
            this.addConnection(node, direction);
        }
    }

    protected INode getNodeFrom(TileEntity tile, ForgeDirection from) {
        INode node;
        if (tile instanceof INodeProvider && (node = ((INodeProvider)tile).getNode(this.getRelativeClass(), from)) != null) {
            return node;
        }
        return null;
    }

    protected void addConnection(Object obj, ForgeDirection dir) {
        this.connections.put(obj, dir);
    }

    protected Class<? extends INode> getRelativeClass() {
        return this.getClass();
    }
}

