/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.grid.node;

import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import universalelectricity.api.EnergyStorage;
import universalelectricity.api.core.grid.INodeProvider;
import universalelectricity.api.core.grid.ISave;
import universalelectricity.api.core.grid.IUpdate;
import universalelectricity.api.core.grid.electric.IEnergyNode;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.core.grid.node.NodeConnector;

public class NodeEnergy
extends NodeConnector
implements IEnergyNode,
IUpdate,
ISave {
    @Deprecated
    protected EnergyStorage buffer = null;
    protected boolean shareEnergy = false;

    public NodeEnergy(INodeProvider parent) {
        this(parent, 100.0);
    }

    public NodeEnergy(INodeProvider parent, double cap) {
        this(parent, cap, cap);
    }

    public NodeEnergy(INodeProvider parent, double cap, double tran) {
        this(parent, cap, tran, tran);
    }

    public NodeEnergy(INodeProvider parent, double cap, double in, double out) {
        super(parent);
        this.buffer = new EnergyStorage(cap, in, out);
    }

    @Override
    public void update(double deltaTime) {
        if (this.canShareEnergy()) {
            this.shareEnergy();
        }
    }

    public EnergyStorage buffer() {
        return this.buffer;
    }

    @Override
    public double addEnergy(ForgeDirection from, double energy, boolean doAdd) {
        if (this.canConnect(from)) {
            return this.buffer.receiveEnergy(energy, doAdd);
        }
        return 0.0;
    }

    @Override
    public double removeEnergy(ForgeDirection from, double energy, boolean doRemove) {
        if (this.canConnect(from) && this.canShareEnergy()) {
            return this.buffer.extractEnergy(energy, doRemove);
        }
        return 0.0;
    }

    @Override
    public double getEnergy(ForgeDirection from) {
        if (this.canConnect(from.getOpposite())) {
            return this.buffer.getEnergy();
        }
        return -1.0;
    }

    @Override
    public double getEnergyCapacity(ForgeDirection from) {
        if (this.canConnect(from.getOpposite())) {
            return this.buffer.getEnergyCapacity();
        }
        return -1.0;
    }

    public boolean canShareEnergy() {
        return this.shareEnergy;
    }

    public void setCanShareEnergy(boolean share) {
        this.shareEnergy = share;
    }

    public void shareEnergy() {
        if (this.getEnergy(ForgeDirection.UNKNOWN) > 0.0) {
            int handlers = this.connections.size();
            for (Map.Entry entry : this.connections.entrySet()) {
                double energyToGive = Math.min(this.buffer.maxExtract(), this.getEnergy((ForgeDirection)entry.getValue()) / (double)handlers + this.getEnergy(ForgeDirection.UNKNOWN) % (double)handlers);
                if (Compatibility.isHandler(entry.getKey(), (ForgeDirection)entry.getValue()) && Compatibility.canConnect(entry.getKey(), (ForgeDirection)entry.getValue(), this)) {
                    this.buffer.extractEnergy(Compatibility.fill(entry.getKey(), (ForgeDirection)entry.getValue(), this.buffer.extractEnergy(energyToGive, false), true), true);
                }
                --handlers;
            }
        }
    }

    @Override
    public boolean canConnect(ForgeDirection direction, Object object) {
        if (object != null) {
            return this.canConnect(direction) && Compatibility.isHandler(object, direction) && Compatibility.canConnect(object, direction, this);
        }
        return false;
    }

    @Override
    public boolean canUpdate() {
        return this.canShareEnergy() && this.getEnergy(ForgeDirection.UNKNOWN) > 0.0;
    }

    @Override
    public boolean continueUpdate() {
        return true;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("energy")) {
            NBTTagCompound energy = nbt.func_74775_l("energy");
            this.buffer.readFromNBT(energy);
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        NBTTagCompound energy = new NBTTagCompound();
        this.buffer.writeToNBT(energy);
        nbt.func_74782_a("energy", (NBTBase)energy);
    }
}

