/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.transform.region;

import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import universalelectricity.core.transform.AbstractOperation;
import universalelectricity.core.transform.vector.Vector2;

@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u0001-\u0011\u0011BU3di\u0006tw\r\\3\u000b\u0005\r!\u0011A\u0002:fO&|gN\u0003\u0002\u0006\r\u0005IAO]1og\u001a|'/\u001c\u0006\u0003\u000f!\tAaY8sK*\t\u0011\"\u0001\u000bv]&4XM]:bY\u0016dWm\u0019;sS\u000eLG/_\u0002\u0001'\t\u0001A\u0002E\u0002\u000e\u001dAi\u0011\u0001B\u0005\u0003\u001f\u0011\u0011\u0011#\u00112tiJ\f7\r^(qKJ\fG/[8o!\t\t\u0002!D\u0001\u0003\u0011!\u0019\u0002A!a\u0001\n\u0003!\u0012aA7j]V\tQ\u0003\u0005\u0002\u001735\tqC\u0003\u0002\u0019\t\u00051a/Z2u_JL!AG\f\u0003\u000fY+7\r^8se!AA\u0004\u0001BA\u0002\u0013\u0005Q$A\u0004nS:|F%Z9\u0015\u0005y!\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSRDq!J\u000e\u0002\u0002\u0003\u0007Q#A\u0002yIEB\u0001b\n\u0001\u0003\u0002\u0003\u0006K!F\u0001\u0005[&t\u0007\u0005\u0003\u0005*\u0001\t\u0005\r\u0011\"\u0001\u0015\u0003\ri\u0017\r\u001f\u0005\tW\u0001\u0011\t\u0019!C\u0001Y\u00059Q.\u0019=`I\u0015\fHC\u0001\u0010.\u0011\u001d)#&!AA\u0002UA\u0001b\f\u0001\u0003\u0002\u0003\u0006K!F\u0001\u0005[\u0006D\b\u0005C\u00032\u0001\u0011\u0005!'\u0001\u0004=S:LGO\u0010\u000b\u0004!M\"\u0004\"B\n1\u0001\u0004)\u0002\"B\u00151\u0001\u0004)\u0002\"B\u0019\u0001\t\u00031D#\u0001\t\t\u000bE\u0002A\u0011\u0001\u001d\u0015\u0007AI4\bC\u0003;o\u0001\u0007Q#A\u0002wK\u000eDQ\u0001P\u001cA\u0002u\n\u0011\"\u001a=qC:\u001c\u0018n\u001c8\u0011\u0005}q\u0014BA !\u0005\u0019!u.\u001e2mK\")\u0011\u0007\u0001C\u0001\u0003R)\u0001C\u0011#G\u0011\")1\t\u0011a\u0001{\u0005!Q.\u001b8Y\u0011\u0015)\u0005\t1\u0001>\u0003\u0011i\u0017N\\-\t\u000b\u001d\u0003\u0005\u0019A\u001f\u0002\t5\f\u0007\u0010\u0017\u0005\u0006\u0013\u0002\u0003\r!P\u0001\u0005[\u0006D\u0018\fC\u00032\u0001\u0011\u00051\n\u0006\u0002\u0011\u0019\")QJ\u0013a\u0001!\u0005!!/Z2u\u0011\u0015y\u0005\u0001\"\u0011Q\u0003\r\u0019X\r\u001e\u000b\u0003!ECQA\u0015(A\u0002A\tQa\u001c;iKJDQ\u0001\u0016\u0001\u0005BU\u000bQA]8v]\u0012,\u0012\u0001\u0005\u0005\u0006/\u0002!\t%V\u0001\u0005G\u0016LG\u000eC\u0003Z\u0001\u0011\u0005S+A\u0003gY>|'\u000fC\u0003*\u0001\u0011\u00053\f\u0006\u0002\u00119\")!K\u0017a\u0001!!)1\u0003\u0001C!=R\u0011\u0001c\u0018\u0005\u0006%v\u0003\r\u0001\u0005\u0005\u0006C\u0002!\tEN\u0001\u000be\u0016\u001c\u0017\u000e\u001d:pG\u0006d\u0007\"B2\u0001\t\u0003\"\u0017!\u0002\u0013qYV\u001cHC\u0001\tf\u0011\u00151'\r1\u0001>\u0003\u0019\tWn\\;oi\")1\r\u0001C!QR\u0011\u0001#\u001b\u0005\u0006M\u001e\u0004\r\u0001\u0005\u0005\u0006G\u0002!\ta\u001b\u000b\u0003!1DQA\u000f6A\u0002UAQA\u001c\u0001\u0005\u0002=\f\u0001\u0002\n9mkN$S-\u001d\u000b\u0003!ADQAO7A\u0002UAQA\u001d\u0001\u0005\u0002M\fa\u0001J7j]V\u001cHC\u0001\tu\u0011\u0015Q\u0014\u000f1\u0001\u0016\u0011\u00151\b\u0001\"\u0001x\u0003%!S.\u001b8vg\u0012*\u0017\u000f\u0006\u0002\u0011q\")!(\u001ea\u0001+!)!\u0010\u0001C\u0001w\u0006\u0019\u0011\r\u001a3\u0015\u0005Aa\b\"\u0002\u001ez\u0001\u0004)\u0002\"\u0002@\u0001\t\u0003y\u0018AB1eIN+G\u000fF\u0002\u0011\u0003\u0003AQAO?A\u0002UAq!!\u0002\u0001\t\u0003\t9!\u0001\u0005tk\n$(/Y2u)\r\u0001\u0012\u0011\u0002\u0005\u0007u\u0005\r\u0001\u0019A\u000b\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010\u0005Y1/\u001e2ue\u0006\u001cGoU3u)\r\u0001\u0012\u0011\u0003\u0005\u0007u\u0005-\u0001\u0019A\u000b\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018\u00051A\u0005^5nKN$2\u0001EA\r\u0011\u00191\u00171\u0003a\u0001{!9\u0011Q\u0003\u0001\u0005\u0002\u0005uAc\u0001\t\u0002 !1a-a\u0007A\u0002AAq!a\t\u0001\t\u0003\t)#\u0001\u0006j]R,'o]3diN$B!a\n\u0002.A\u0019q$!\u000b\n\u0007\u0005-\u0002EA\u0004C_>dW-\u00198\t\u000f\u0005=\u0012\u0011\u0005a\u0001+\u0005)\u0001o\\5oi\"9\u00111\u0005\u0001\u0005\u0002\u0005MB\u0003BA\u0014\u0003kAaaAA\u0019\u0001\u0004\u0001\u0002bBA\u001d\u0001\u0011\u0005\u00131H\u0001\toJLG/\u001a(C)R!\u0011QHA)!\u0011\ty$!\u0014\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\n1A\u001c2u\u0015\u0011\t9%!\u0013\u0002\u00135Lg.Z2sC\u001a$(BAA&\u0003\rqW\r^\u0005\u0005\u0003\u001f\n\tE\u0001\bO\u0005R#\u0016mZ\"p[B|WO\u001c3\t\u0011\u0005\r\u0013q\u0007a\u0001\u0003{Aq!!\u0016\u0001\t\u0003\n9&\u0001\u0007xe&$XMQ=uK\n+h\r\u0006\u0003\u0002Z\u00055\u0004\u0003BA.\u0003Sj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0007EV4g-\u001a:\u000b\t\u0005\r\u0014QM\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u0003O\n!![8\n\t\u0005-\u0014Q\f\u0002\b\u0005f$XMQ;g\u0011!\ty'a\u0015A\u0002\u0005e\u0013\u0001\u00023bi\u0006Dq!a\u001d\u0001\t\u0003\n)(\u0001\u0005u_N#(/\u001b8h)\t\t9\b\u0005\u0003\u0002z\u0005}dbA\u0010\u0002|%\u0019\u0011Q\u0010\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t)a!\u0003\rM#(/\u001b8h\u0015\r\ti\b\t\u0005\b\u0003\u000f\u0003A\u0011IAE\u0003\u0019)\u0017/^1mgR!\u0011qEAF\u0011!\ti)!\"A\u0002\u0005=\u0015!A8\u0011\u0007}\t\t*C\u0002\u0002\u0014\u0002\u00121!\u00118z\u0011\u0019\t9\n\u0001C!m\u0005)1\r\\8oK\u0002")
public class Rectangle
extends AbstractOperation<Rectangle> {
    private Vector2 min;
    private Vector2 max;

    public Vector2 min() {
        return this.min;
    }

    public void min_$eq(Vector2 x$1) {
        this.min = x$1;
    }

    public Vector2 max() {
        return this.max;
    }

    public void max_$eq(Vector2 x$1) {
        this.max = x$1;
    }

    @Override
    public Rectangle set(Rectangle other) {
        this.min_$eq(other.min().clone());
        this.max_$eq(other.max().clone());
        return this;
    }

    @Override
    public Rectangle round() {
        return new Rectangle(this.min().round(), this.max().round());
    }

    @Override
    public Rectangle ceil() {
        return new Rectangle(this.min().ceil(), this.max().ceil());
    }

    @Override
    public Rectangle floor() {
        return new Rectangle(this.min().floor(), this.max().floor());
    }

    @Override
    public Rectangle max(Rectangle other) {
        return new Rectangle(this.min().max(other.min()), this.max().max(other.max()));
    }

    @Override
    public Rectangle min(Rectangle other) {
        return new Rectangle(this.min().min(other.min()), this.max().min(other.max()));
    }

    @Override
    public Rectangle reciprocal() {
        return new Rectangle(this.min().reciprocal(), this.max().reciprocal());
    }

    @Override
    public Rectangle $plus(double amount) {
        return new Rectangle(this.min().$plus(amount), this.max().$plus(amount));
    }

    @Override
    public Rectangle $plus(Rectangle amount) {
        return new Rectangle(this.min().$plus(amount.min()), this.max().$plus(amount.max()));
    }

    @Override
    public Rectangle $plus(Vector2 vec) {
        return new Rectangle(this.min().$plus(vec), this.max().$plus(vec));
    }

    @Override
    public Rectangle $plus$eq(Vector2 vec) {
        this.min().$plus$eq(vec);
        this.max().$plus$eq(vec);
        return this;
    }

    @Override
    public Rectangle $minus(Vector2 vec) {
        return this.$plus(vec.$times(-1.0));
    }

    @Override
    public Rectangle $minus$eq(Vector2 vec) {
        return this.$plus$eq(vec.$times(-1.0));
    }

    @Override
    public Rectangle add(Vector2 vec) {
        return this.$plus(vec);
    }

    public Rectangle addSet(Vector2 vec) {
        return this.$plus$eq(vec);
    }

    @Override
    public Rectangle subtract(Vector2 vec) {
        return this.$minus(vec);
    }

    public Rectangle subtractSet(Vector2 vec) {
        return this.$minus$eq(vec);
    }

    @Override
    public Rectangle $times(double amount) {
        return new Rectangle(this.min().$times(amount), this.max().$times(amount));
    }

    @Override
    public Rectangle $times(Rectangle amount) {
        return new Rectangle(this.min().$times(amount.min()), this.max().$times(amount.max()));
    }

    public boolean intersects(Vector2 point) {
        return point.x() > this.min().x() && point.x() < this.max().x() && point.y() > this.min().y() && point.y() < this.max().y();
    }

    public boolean intersects(Rectangle region) {
        return region.max().x() > this.min().x() && region.min().x() < this.max().x() ? region.max().y() > this.min().y() && region.min().y() < this.max().y() : false;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("min", (NBTBase)this.min().toNBT());
        nbt.func_74782_a("max", (NBTBase)this.max().toNBT());
        return nbt;
    }

    @Override
    public ByteBuf writeByteBuf(ByteBuf data) {
        this.min().writeByteBuf(data);
        this.max().writeByteBuf(data);
        return data;
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return new StringBuilder().append((Object)"Rectangle[").append((Object)new BigDecimal(this.min().x(), cont)).append((Object)", ").append((Object)new BigDecimal(this.min().y(), cont)).append((Object)"] -> [").append((Object)new BigDecimal(this.max().x(), cont)).append((Object)", ").append((Object)new BigDecimal(this.max().y(), cont)).append((Object)"]").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Rectangle)) return false;
        Vector2 vector2 = this.min();
        Vector2 vector22 = ((Rectangle)o).min();
        if (vector2 == null) {
            if (vector22 != null) {
                return false;
            }
        } else if (!((Object)vector2).equals(vector22)) return false;
        Vector2 vector23 = this.max();
        Vector2 vector24 = ((Rectangle)o).max();
        if (vector23 == null) {
            if (vector24 == null) return true;
            return false;
        } else {
            if (!((Object)vector23).equals(vector24)) return false;
            return true;
        }
    }

    public Rectangle clone() {
        return new Rectangle(this);
    }

    public Rectangle(Vector2 min, Vector2 max) {
        this.min = min;
        this.max = max;
    }

    public Rectangle() {
        this(new Vector2(), new Vector2());
    }

    public Rectangle(Vector2 vec, double expansion) {
        this(vec, vec.$plus(expansion));
    }

    public Rectangle(double minX, double minY, double maxX, double maxY) {
        this(new Vector2(minX, minY), new Vector2(maxX, maxY));
    }

    public Rectangle(Rectangle rect) {
        this(rect.min().clone(), rect.max().clone());
    }
}

