/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.transform.rotation;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import scala.Cloneable;
import scala.reflect.ScalaSignature;
import universalelectricity.core.transform.ITransform;
import universalelectricity.core.transform.matrix.Matrix;
import universalelectricity.core.transform.rotation.AngleAxis$;
import universalelectricity.core.transform.rotation.EulerAngle;
import universalelectricity.core.transform.vector.Vector3;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u0001-\u0011\u0011\"\u00118hY\u0016\f\u00050[:\u000b\u0005\r!\u0011\u0001\u0003:pi\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!\u0003;sC:\u001chm\u001c:n\u0015\t9\u0001\"\u0001\u0003d_J,'\"A\u0005\u0002)Ut\u0017N^3sg\u0006dW\r\\3diJL7-\u001b;z\u0007\u0001\u0019B\u0001\u0001\u0007\u00155A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0005DY>tW-\u00192mKB\u00111\u0004H\u0007\u0002\t%\u0011Q\u0004\u0002\u0002\u000b\u0013R\u0013\u0018M\\:g_Jl\u0007\u0002C\u0010\u0001\u0005\u0003\u0007I\u0011\u0001\u0011\u0002\u000b\u0005tw\r\\3\u0016\u0003\u0005\u0002\"!\u0006\u0012\n\u0005\r2\"A\u0002#pk\ndW\r\u0003\u0005&\u0001\t\u0005\r\u0011\"\u0001'\u0003%\tgn\u001a7f?\u0012*\u0017\u000f\u0006\u0002(UA\u0011Q\u0003K\u0005\u0003SY\u0011A!\u00168ji\"91\u0006JA\u0001\u0002\u0004\t\u0013a\u0001=%c!AQ\u0006\u0001B\u0001B\u0003&\u0011%\u0001\u0004b]\u001edW\r\t\u0005\t_\u0001\u0011\t\u0019!C\u0001a\u0005!\u0011\r_5t+\u0005\t\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0005\u0003\u00191Xm\u0019;pe&\u0011ag\r\u0002\b-\u0016\u001cGo\u001c:4\u0011!A\u0004A!a\u0001\n\u0003I\u0014\u0001C1ySN|F%Z9\u0015\u0005\u001dR\u0004bB\u00168\u0003\u0003\u0005\r!\r\u0005\ty\u0001\u0011\t\u0011)Q\u0005c\u0005)\u0011\r_5tA!)a\b\u0001C\u0001\u007f\u00051A(\u001b8jiz\"2\u0001\u0011\"D!\t\t\u0005!D\u0001\u0003\u0011\u001dyR\b%AA\u0002\u0005BqaL\u001f\u0011\u0002\u0003\u0007\u0011\u0007C\u0003?\u0001\u0011\u0005Q\t\u0006\u0002A\r\")q\t\u0012a\u0001\u0011\u0006\u0019aN\u0019;\u0011\u0005%{U\"\u0001&\u000b\u0005\u001d[%B\u0001'N\u0003%i\u0017N\\3de\u00064GOC\u0001O\u0003\rqW\r^\u0005\u0003!*\u0013aB\u0014\"U)\u0006<7i\\7q_VtG\rC\u0003S\u0001\u0011\u00051+\u0001\u0003dK&dW#\u0001!\t\u000bU\u0003A\u0011A*\u0002\u000b\u0019dwn\u001c:\t\u000b]\u0003A\u0011A*\u0002\u000bI|WO\u001c3\t\u000b\u0015\u0001A\u0011I-\u0015\u0005ER\u0006\"\u0002\u001bY\u0001\u0004\t\u0004\"\u0002/\u0001\t\u0003i\u0016\u0001\u0005;p%>$\u0018\r^5p]6\u000bGO]5y+\u0005q\u0006CA0c\u001b\u0005\u0001'BA1\u0005\u0003\u0019i\u0017\r\u001e:jq&\u00111\r\u0019\u0002\u0007\u001b\u0006$(/\u001b=\t\u000b\u0015\u0004A\u0011\u00014\u0002\u0019Q|W)\u001e7fe\u0006sw\r\\3\u0016\u0003\u001d\u0004\"!\u00115\n\u0005%\u0014!AC#vY\u0016\u0014\u0018I\\4mK\")1\u000e\u0001C\u0001Y\u0006AqO]5uK:\u0013E\u000b\u0006\u0002I[\")qI\u001ba\u0001\u0011\")q\u000e\u0001C\u0001a\u0006aqO]5uK\nKH/\u001a\"vMR\u0011\u0011o\u001f\t\u0003efl\u0011a\u001d\u0006\u0003iV\faAY;gM\u0016\u0014(B\u0001<x\u0003\u0015qW\r\u001e;z\u0015\u0005A\u0018AA5p\u0013\tQ8OA\u0004CsR,')\u001e4\t\u000bqt\u0007\u0019A9\u0002\t\u0011\fG/\u0019\u0005\u0006}\u0002!\te`\u0001\u0006G2|g.\u001a\u000b\u0002\u0001\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u001d\u0001cA\u000b\u0002\n%\u0019\u00111\u0002\f\u0003\u0007%sG\u000fC\u0004\u0002\u0010\u0001!\t%!\u0005\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019\"!\u0007\u0011\u0007U\t)\"C\u0002\u0002\u0018Y\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u001c\u00055\u0001\u0019AA\u000f\u0003\u0005y\u0007cA\u000b\u0002 %\u0019\u0011\u0011\u0005\f\u0003\u0007\u0005s\u0017pB\u0005\u0002&\t\t\t\u0011#\u0001\u0002(\u0005I\u0011I\\4mK\u0006C\u0018n\u001d\t\u0004\u0003\u0006%b\u0001C\u0001\u0003\u0003\u0003E\t!a\u000b\u0014\t\u0005%\u0012Q\u0006\t\u0004+\u0005=\u0012bAA\u0019-\t1\u0011I\\=SK\u001aDqAPA\u0015\t\u0003\t)\u0004\u0006\u0002\u0002(!Q\u0011\u0011HA\u0015#\u0003%\t!a\u000f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tiDK\u0002\"\u0003\u007fY#!!\u0011\u0011\t\u0005\r\u0013QJ\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u00172\u0012AC1o]>$\u0018\r^5p]&!\u0011qJA#\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003'\nI#%A\u0005\u0002\u0005U\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002X)\u001a\u0011'a\u0010")
public class AngleAxis
implements Cloneable,
ITransform {
    private double angle;
    private Vector3 axis;

    public static Vector3 $lessinit$greater$default$2() {
        return AngleAxis$.MODULE$.$lessinit$greater$default$2();
    }

    public static double $lessinit$greater$default$1() {
        return AngleAxis$.MODULE$.$lessinit$greater$default$1();
    }

    public double angle() {
        return this.angle;
    }

    public void angle_$eq(double x$1) {
        this.angle = x$1;
    }

    public Vector3 axis() {
        return this.axis;
    }

    public void axis_$eq(Vector3 x$1) {
        this.axis = x$1;
    }

    public AngleAxis ceil() {
        return new AngleAxis(Math.ceil(this.angle()), this.axis().ceil());
    }

    public AngleAxis floor() {
        return new AngleAxis(Math.floor(this.angle()), this.axis().floor());
    }

    public AngleAxis round() {
        return new AngleAxis(Math.round(this.angle()), this.axis().round());
    }

    @Override
    public Vector3 transform(Vector3 vector) {
        return this.toRotationMatrix().$times(vector);
    }

    public Matrix toRotationMatrix() {
        double x = this.axis().x();
        double y = this.axis().y();
        double z = this.axis().z();
        double cos = Math.cos(this.angle());
        double oneMinusCos = 1.0 - cos;
        double sin = Math.sin(this.angle());
        Matrix matrix = new Matrix(3, 3);
        matrix.apply(0).update(0, x * x * oneMinusCos + cos);
        matrix.apply(0).update(1, y * x * oneMinusCos + z * sin);
        matrix.apply(0).update(2, x * z * oneMinusCos - y * sin);
        matrix.apply(1).update(0, x * y * oneMinusCos - z * sin);
        matrix.apply(1).update(1, y * y * oneMinusCos + cos);
        matrix.apply(1).update(2, y * z * oneMinusCos + x * sin);
        matrix.apply(2).update(0, x * z * oneMinusCos + y * sin);
        matrix.apply(2).update(1, y * z * oneMinusCos - x * sin);
        matrix.apply(2).update(2, z * z * oneMinusCos + cos);
        return matrix;
    }

    public EulerAngle toEulerAngle() {
        double x = this.axis().x();
        double y = this.axis().y();
        double z = this.axis().z();
        double s = Math.sin(this.angle());
        double c = Math.cos(this.angle());
        double t = 1.0 - c;
        double yaw = 0.0;
        double pitch = 0.0;
        double roll = 0.0;
        if (x * y * t + z * s > 0.998) {
            yaw = (double)2 * Math.atan2(x * Math.sin(this.angle() / (double)2), Math.cos(this.angle() / (double)2));
            pitch = 1.5707963267948966;
            roll = 0.0;
            return new EulerAngle(yaw, pitch, roll);
        }
        if (x * y * t + z * s < -0.998) {
            yaw = (double)-2 * Math.atan2(x * Math.sin(this.angle() / (double)2), Math.cos(this.angle() / (double)2));
            pitch = -Math.PI / (double)2;
            roll = 0.0;
            return new EulerAngle(yaw, pitch, roll);
        }
        yaw = Math.atan2(y * s - x * z * t, 1.0 - (y * y + z * z) * t);
        pitch = Math.asin(x * y * t + z * s);
        roll = Math.atan2(x * s - y * z * t, 1.0 - (x * x + z * z) * t);
        return new EulerAngle(yaw, pitch, roll);
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        this.axis().writeNBT(nbt);
        nbt.func_74780_a("angle", this.angle());
        return nbt;
    }

    public ByteBuf writeByteBuf(ByteBuf data) {
        this.axis().writeByteBuf(data);
        data.writeDouble(this.angle());
        return data;
    }

    public AngleAxis clone() {
        return new AngleAxis(this.angle(), this.axis());
    }

    public int hashCode() {
        long angle = Double.doubleToLongBits(this.angle());
        int hash = this.axis().hashCode();
        hash = 31 * hash + (int)(angle ^ angle >>> 32);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof AngleAxis) {
            AngleAxis other = (AngleAxis)o;
            return this.axis().equals(other.axis()) && this.angle() == other.angle();
        }
        return false;
    }

    public AngleAxis(double angle, Vector3 axis) {
        this.angle = angle;
        this.axis = axis;
    }

    public AngleAxis(NBTTagCompound nbt) {
        this(nbt.func_74769_h("angle"), new Vector3(nbt));
    }
}

