/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.transform.rotation;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import scala.Cloneable;
import scala.Function1;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import universalelectricity.core.transform.AbstractOperation;
import universalelectricity.core.transform.ITransform;
import universalelectricity.core.transform.rotation.AngleAxis;
import universalelectricity.core.transform.rotation.EulerAngle$;
import universalelectricity.core.transform.rotation.Quaternion;
import universalelectricity.core.transform.vector.Vector3;

@ScalaSignature(bytes="\u0006\u0001\u0005\rx!B\u0001\u0003\u0011\u0003Y\u0011AC#vY\u0016\u0014\u0018I\\4mK*\u00111\u0001B\u0001\te>$\u0018\r^5p]*\u0011QAB\u0001\niJ\fgn\u001d4pe6T!a\u0002\u0005\u0002\t\r|'/\u001a\u0006\u0002\u0013\u0005!RO\\5wKJ\u001c\u0018\r\\3mK\u000e$(/[2jif\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qB\u0001\u0006Fk2,'/\u00118hY\u0016\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0003\u001b\u001b\u0011\u00051$A\bb]\u001edW\rR5gM\u0016\u0014XM\\2f)\rar$\t\t\u0003#uI!A\b\n\u0003\r\u0011{WO\u00197f\u0011\u0015\u0001\u0013\u00041\u0001\u001d\u0003\u0019\tgn\u001a7f\u0003\")!%\u0007a\u00019\u00051\u0011M\\4mK\nCQ\u0001J\u0007\u0005\u0002\u0015\nqb\u00197b[B\fen\u001a7f)>\u001cd\u0007\r\u000b\u00039\u0019BQaJ\u0012A\u0002q\tQA^1mk\u0016DQ!K\u0007\u0005\u0002)\nqb\u00197b[B\fen\u001a7f)>\f\u0004\b\r\u000b\u00039-BQa\n\u0015A\u0002qAQ!L\u0007\u0005\u00029\n!b\u00197b[B\fen\u001a7f)\u0011ar\u0006\r\u001a\t\u000b\u001db\u0003\u0019\u0001\u000f\t\u000bEb\u0003\u0019\u0001\u000f\u0002\u00075Lg\u000eC\u00034Y\u0001\u0007A$A\u0002nCb4AA\u0004\u0002\u0001kM!AGN\u001e?!\r9\u0004HO\u0007\u0002\t%\u0011\u0011\b\u0002\u0002\u0012\u0003\n\u001cHO]1di>\u0003XM]1uS>t\u0007C\u0001\u00075!\t\tB(\u0003\u0002>%\tI1\t\\8oK\u0006\u0014G.\u001a\t\u0003o}J!\u0001\u0011\u0003\u0003\u0015%#&/\u00198tM>\u0014X\u000e\u0003\u0005Ci\t\u0005\r\u0011\"\u0001D\u0003\rI\u0018m^\u000b\u00029!AQ\t\u000eBA\u0002\u0013\u0005a)A\u0004zC^|F%Z9\u0015\u0005\u001dS\u0005CA\tI\u0013\tI%C\u0001\u0003V]&$\bbB&E\u0003\u0003\u0005\r\u0001H\u0001\u0004q\u0012\n\u0004\u0002C'5\u0005\u0003\u0005\u000b\u0015\u0002\u000f\u0002\te\fw\u000f\t\u0005\t\u001fR\u0012\t\u0019!C\u0001\u0007\u0006)\u0001/\u001b;dQ\"A\u0011\u000b\u000eBA\u0002\u0013\u0005!+A\u0005qSR\u001c\u0007n\u0018\u0013fcR\u0011qi\u0015\u0005\b\u0017B\u000b\t\u00111\u0001\u001d\u0011!)FG!A!B\u0013a\u0012A\u00029ji\u000eD\u0007\u0005\u0003\u0005Xi\t\u0005\r\u0011\"\u0001D\u0003\u0011\u0011x\u000e\u001c7\t\u0011e#$\u00111A\u0005\u0002i\u000b\u0001B]8mY~#S-\u001d\u000b\u0003\u000fnCqa\u0013-\u0002\u0002\u0003\u0007A\u0004\u0003\u0005^i\t\u0005\t\u0015)\u0003\u001d\u0003\u0015\u0011x\u000e\u001c7!\u0011\u00159B\u0007\"\u0001`)\u0011Q\u0004-\u00192\t\u000b\ts\u0006\u0019\u0001\u000f\t\u000b=s\u0006\u0019\u0001\u000f\t\u000b]s\u0006\u0019\u0001\u000f\t\u000b]!D\u0011\u00013\u0015\u0007i*g\rC\u0003CG\u0002\u0007A\u0004C\u0003PG\u0002\u0007A\u0004C\u0003\u0018i\u0011\u0005\u0001\u000e\u0006\u0002;S\")!n\u001aa\u0001W\u0006\u0019A-\u001b:\u0011\u00051,X\"A7\u000b\u00059|\u0017\u0001B;uS2T!\u0001]9\u0002\r\r|W.\\8o\u0015\t\u00118/\u0001\bnS:,7M]1gi\u001a|'oZ3\u000b\u0003Q\f1A\\3u\u0013\t1XN\u0001\bG_J<W\rR5sK\u000e$\u0018n\u001c8\t\u000ba$D\u0011A=\u0002\u0007M,G\u000f\u0006\u0003Hund\b\"\u0002\"x\u0001\u0004a\u0002\"B(x\u0001\u0004a\u0002\"B,x\u0001\u0004a\u0002\"\u0002=5\t\u0003rHC\u0001\u001e\u0000\u0011\u0019\t\t! a\u0001u\u0005)q\u000e\u001e5fe\"9\u0011Q\u0001\u001b\u0005B\u0005\u001d\u0011!\u0002\u0013qYV\u001cHc\u0001\u001e\u0002\n!9\u0011\u0011AA\u0002\u0001\u0004a\u0002bBA\u0003i\u0011\u0005\u0013Q\u0002\u000b\u0004u\u0005=\u0001bBA\u0001\u0003\u0017\u0001\rA\u000f\u0005\b\u0003'!D\u0011IA\u000b\u0003\u0019!C/[7fgR\u0019!(a\u0006\t\u000f\u0005\u0005\u0011\u0011\u0003a\u00019!9\u00111\u0003\u001b\u0005B\u0005mAc\u0001\u001e\u0002\u001e!9\u0011\u0011AA\r\u0001\u0004Q\u0004bBA\u0011i\u0011\u0005\u00131E\u0001\u000be\u0016\u001c\u0017\u000e\u001d:pG\u0006dG#\u0001\u001e\t\u000f\u0005\u001dB\u0007\"\u0001\u0002*\u0005!1-Z5m+\u0005Q\u0004bBA\u0017i\u0011\u0005\u0011\u0011F\u0001\u0006M2|wN\u001d\u0005\b\u0003c!D\u0011AA\u0015\u0003\u0015\u0011x.\u001e8e\u0011\u0019\u0019D\u0007\"\u0001\u00026Q\u0019!(a\u000e\t\u000f\u0005\u0005\u00111\u0007a\u0001u!1\u0011\u0007\u000eC\u0001\u0003w!2AOA\u001f\u0011\u001d\t\t!!\u000fA\u0002iBq!!\u00115\t\u0003\t\u0019%\u0001\nbEN|G.\u001e;f\t&4g-\u001a:f]\u000e,Gc\u0001\u001e\u0002F!9\u0011\u0011AA \u0001\u0004Q\u0004bBA%i\u0011\u0005\u00111J\u0001\tSN<\u0016\u000e\u001e5j]R1\u0011QJA*\u0003+\u00022!EA(\u0013\r\t\tF\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t!a\u0012A\u0002iBq!a\u0016\u0002H\u0001\u0007A$\u0001\u0004nCJ<\u0017N\u001c\u0005\u0007\u000bQ\"\t%a\u0017\u0015\t\u0005u\u0013\u0011\u000e\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111\r\u0003\u0002\rY,7\r^8s\u0013\u0011\t9'!\u0019\u0003\u000fY+7\r^8sg!A\u00111MA-\u0001\u0004\ti\u0006C\u0004\u0002nQ\"\t!a\u001c\u0002\u0011Q|g+Z2u_J,\"!!\u0018\t\u000f\u0005MD\u0007\"\u0001\u0002v\u0005YAo\\!oO2,\u0017\t_5t+\t\t9\bE\u0002\r\u0003sJ1!a\u001f\u0003\u0005%\ten\u001a7f\u0003bL7\u000fC\u0004\u0002\u0000Q\"\t!!!\u0002\u0019Q|\u0017+^1uKJt\u0017n\u001c8\u0016\u0005\u0005\r\u0005c\u0001\u0007\u0002\u0006&\u0019\u0011q\u0011\u0002\u0003\u0015E+\u0018\r^3s]&|g\u000eC\u0004\u0002\fR\"\t!!$\u0002\u000fQ|G+\u001e9mKV\u0011\u0011q\u0012\t\u0007#\u0005EE\u0004\b\u000f\n\u0007\u0005M%C\u0001\u0004UkBdWm\r\u0005\b\u0003/#D\u0011IA\u0012\u0003\u0015\u0019Gn\u001c8f\u0011\u001d\tY\n\u000eC!\u0003;\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003?\u0003B!!)\u0002(:\u0019\u0011#a)\n\u0007\u0005\u0015&#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003S\u000bYK\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003K\u0013\u0002bBAXi\u0011\u0005\u0013\u0011W\u0001\roJLG/\u001a\"zi\u0016\u0014UO\u001a\u000b\u0005\u0003g\u000b9\r\u0005\u0003\u00026\u0006\rWBAA\\\u0015\u0011\tI,a/\u0002\r\t,hMZ3s\u0015\u0011\ti,a0\u0002\u000b9,G\u000f^=\u000b\u0005\u0005\u0005\u0017AA5p\u0013\u0011\t)-a.\u0003\u000f\tKH/\u001a\"vM\"A\u0011\u0011ZAW\u0001\u0004\t\u0019,\u0001\u0003eCR\f\u0007bBAgi\u0011\u0005\u0013qZ\u0001\toJLG/\u001a(C)R!\u0011\u0011[Aq!\u0011\t\u0019.!8\u000e\u0005\u0005U'\u0002BAl\u00033\f1A\u001c2u\u0015\r\tYn]\u0001\n[&tWm\u0019:bMRLA!a8\u0002V\nqaJ\u0011+UC\u001e\u001cu.\u001c9pk:$\u0007\u0002CAl\u0003\u0017\u0004\r!!5")
public class EulerAngle
extends AbstractOperation<EulerAngle>
implements Cloneable,
ITransform {
    private double yaw;
    private double pitch;
    private double roll;

    public static double clampAngle(double d, double d2, double d3) {
        return EulerAngle$.MODULE$.clampAngle(d, d2, d3);
    }

    public static double clampAngleTo180(double d) {
        return EulerAngle$.MODULE$.clampAngleTo180(d);
    }

    public static double clampAngleTo360(double d) {
        return EulerAngle$.MODULE$.clampAngleTo360(d);
    }

    public static double angleDifference(double d, double d2) {
        return EulerAngle$.MODULE$.angleDifference(d, d2);
    }

    public double yaw() {
        return this.yaw;
    }

    public void yaw_$eq(double x$1) {
        this.yaw = x$1;
    }

    public double pitch() {
        return this.pitch;
    }

    public void pitch_$eq(double x$1) {
        this.pitch = x$1;
    }

    public double roll() {
        return this.roll;
    }

    public void roll_$eq(double x$1) {
        this.roll = x$1;
    }

    public void set(double yaw, double pitch, double roll) {
        this.yaw_$eq(yaw);
        this.pitch_$eq(pitch);
        this.roll_$eq(roll);
    }

    @Override
    public EulerAngle set(EulerAngle other) {
        this.yaw_$eq(other.yaw());
        this.pitch_$eq(other.pitch());
        this.roll_$eq(other.roll());
        return this;
    }

    @Override
    public EulerAngle $plus(double other) {
        return new EulerAngle(this.yaw() + other, this.pitch() + other, this.roll() + other);
    }

    @Override
    public EulerAngle $plus(EulerAngle other) {
        return new EulerAngle(this.yaw() + other.yaw(), this.pitch() + other.pitch(), this.roll() + other.roll());
    }

    @Override
    public EulerAngle $times(double other) {
        return new EulerAngle(this.yaw() * other, this.pitch() * other, this.roll() * other);
    }

    @Override
    public EulerAngle $times(EulerAngle other) {
        return new EulerAngle(this.yaw() * other.yaw(), this.pitch() * other.pitch(), this.roll() * other.roll());
    }

    @Override
    public EulerAngle reciprocal() {
        return new EulerAngle(1.0 / this.yaw(), 1.0 / this.pitch(), 1.0 / this.roll());
    }

    @Override
    public EulerAngle ceil() {
        return new EulerAngle(Math.ceil(this.yaw()), Math.ceil(this.pitch()), Math.ceil(this.roll()));
    }

    @Override
    public EulerAngle floor() {
        return new EulerAngle(Math.floor(this.yaw()), Math.floor(this.pitch()), Math.floor(this.roll()));
    }

    @Override
    public EulerAngle round() {
        return new EulerAngle(Math.round(this.yaw()), Math.round(this.pitch()), Math.round(this.roll()));
    }

    @Override
    public EulerAngle max(EulerAngle other) {
        return new EulerAngle(Math.max(this.yaw(), other.yaw()), Math.max(this.pitch(), other.pitch()), Math.max(this.roll(), other.roll()));
    }

    @Override
    public EulerAngle min(EulerAngle other) {
        return new EulerAngle(Math.min(this.yaw(), other.yaw()), Math.min(this.pitch(), other.pitch()), Math.min(this.roll(), other.roll()));
    }

    public EulerAngle absoluteDifference(EulerAngle other) {
        return new EulerAngle(EulerAngle$.MODULE$.angleDifference(this.yaw(), other.yaw()), EulerAngle$.MODULE$.angleDifference(this.pitch(), other.pitch()), EulerAngle$.MODULE$.angleDifference(this.roll(), other.roll()));
    }

    public boolean isWithin(EulerAngle other, double margin) {
        return this.absoluteDifference(other).toTuple().productIterator().exists((Function1)new Serializable(this, margin){
            private final double margin$1;

            public final boolean apply(Object i) {
                return BoxesRunTime.unboxToDouble((Object)i) > this.margin$1;
            }
            {
                this.margin$1 = margin$1;
            }
        });
    }

    @Override
    public Vector3 transform(Vector3 vector) {
        return vector.transform(this.toQuaternion());
    }

    public Vector3 toVector() {
        return new Vector3(-Math.sin(this.yaw()) * Math.cos(this.pitch()), Math.sin(this.pitch()), -Math.cos(this.yaw()) * Math.cos(this.pitch()));
    }

    public AngleAxis toAngleAxis() {
        double c1 = Math.cos(this.yaw() / (double)2);
        double s1 = Math.sin(this.yaw() / (double)2);
        double c2 = Math.cos(this.pitch() / (double)2);
        double s2 = Math.sin(this.pitch() / (double)2);
        double c3 = Math.cos(this.roll() / (double)2);
        double s3 = Math.sin(this.roll() / (double)2);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        double w = c1c2 * c3 - s1s2 * s3;
        double x = c1c2 * s3 + s1s2 * c3;
        double y = s1 * c2 * c3 + c1 * s2 * s3;
        double z = c1 * s2 * c3 - s1 * c2 * s3;
        double angle = (double)2 * Math.acos(w);
        Vector3 axis = new Vector3(x, y, z);
        axis = axis.magnitudeSquared() < 0.001 ? new Vector3(0.0, 0.0, -1.0) : (Vector3)axis.normalize();
        return new AngleAxis(angle, axis);
    }

    public Quaternion toQuaternion() {
        double c1 = Math.cos(Math.toRadians(this.yaw()) / (double)2);
        double s1 = Math.sin(Math.toRadians(this.yaw()) / (double)2);
        double c2 = Math.cos(Math.toRadians(this.pitch()) / (double)2);
        double s2 = Math.sin(Math.toRadians(this.pitch()) / (double)2);
        double c3 = Math.cos(Math.toRadians(this.roll()) / (double)2);
        double s3 = Math.sin(Math.toRadians(this.roll()) / (double)2);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        double w = c1c2 * c3 - s1s2 * s3;
        double x = c1c2 * s3 + s1s2 * c3;
        double y = s1 * c2 * c3 + c1 * s2 * s3;
        double z = c1 * s2 * c3 - s1 * c2 * s3;
        return new Quaternion(w, x, y, z);
    }

    public Tuple3<Object, Object, Object> toTuple() {
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)this.yaw()), (Object)BoxesRunTime.boxToDouble((double)this.pitch()), (Object)BoxesRunTime.boxToDouble((double)this.roll()));
    }

    public EulerAngle clone() {
        return new EulerAngle(this.yaw(), this.pitch(), this.roll());
    }

    public String toString() {
        return new StringBuilder().append((Object)"EulerAngle[").append((Object)BoxesRunTime.boxToDouble((double)this.yaw())).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)this.pitch())).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)this.roll())).append((Object)"]").toString();
    }

    @Override
    public ByteBuf writeByteBuf(ByteBuf data) {
        data.writeDouble(this.yaw());
        data.writeDouble(this.pitch());
        return data.writeDouble(this.roll());
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("yaw", this.yaw());
        nbt.func_74780_a("pitch", this.pitch());
        nbt.func_74780_a("roll", this.roll());
        return nbt;
    }

    public EulerAngle(double yaw, double pitch, double roll) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
    }

    public EulerAngle(double yaw, double pitch) {
        this(yaw, pitch, 0.0);
    }

    public EulerAngle(ForgeDirection dir) {
        this(0.0, 0.0, 0.0);
        ForgeDirection forgeDirection = dir;
        if (ForgeDirection.DOWN.equals(forgeDirection)) {
            this.set(0.0, -90.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.UP.equals(forgeDirection)) {
            this.set(0.0, 90.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.NORTH.equals(forgeDirection)) {
            this.set(0.0, 0.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.SOUTH.equals(forgeDirection)) {
            this.set(180.0, 0.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.WEST.equals(forgeDirection)) {
            this.set(90.0, 0.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.EAST.equals(forgeDirection)) {
            this.set(-90.0, 0.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }
}

