/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.transform.rotation;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Cloneable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import universalelectricity.core.transform.ITransform;
import universalelectricity.core.transform.vector.Vector3;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001-\u0011!\"U;bi\u0016\u0014h.[8o\u0015\t\u0019A!\u0001\u0005s_R\fG/[8o\u0015\t)a!A\u0005ue\u0006t7OZ8s[*\u0011q\u0001C\u0001\u0005G>\u0014XMC\u0001\n\u0003Q)h.\u001b<feN\fG.\u001a7fGR\u0014\u0018nY5us\u000e\u00011\u0003\u0002\u0001\r)i\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\n\u00072|g.Z1cY\u0016\u0004\"a\u0007\u000f\u000e\u0003\u0011I!!\b\u0003\u0003\u0015%#&/\u00198tM>\u0014X\u000eC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u0005!9A\u0005\u0001a\u0001\n\u0003)\u0013!\u0001=\u0016\u0003\u0019\u0002\"!F\u0014\n\u0005!2\"A\u0002#pk\ndW\rC\u0004+\u0001\u0001\u0007I\u0011A\u0016\u0002\u000ba|F%Z9\u0015\u00051z\u0003CA\u000b.\u0013\tqcC\u0001\u0003V]&$\bb\u0002\u0019*\u0003\u0003\u0005\rAJ\u0001\u0004q\u0012\n\u0004B\u0002\u001a\u0001A\u0003&a%\u0001\u0002yA!9A\u0007\u0001a\u0001\n\u0003)\u0013!A=\t\u000fY\u0002\u0001\u0019!C\u0001o\u0005)\u0011p\u0018\u0013fcR\u0011A\u0006\u000f\u0005\baU\n\t\u00111\u0001'\u0011\u0019Q\u0004\u0001)Q\u0005M\u0005\u0011\u0011\u0010\t\u0005\by\u0001\u0001\r\u0011\"\u0001&\u0003\u0005Q\bb\u0002 \u0001\u0001\u0004%\taP\u0001\u0006u~#S-\u001d\u000b\u0003Y\u0001Cq\u0001M\u001f\u0002\u0002\u0003\u0007a\u0005\u0003\u0004C\u0001\u0001\u0006KAJ\u0001\u0003u\u0002Bq\u0001\u0012\u0001A\u0002\u0013\u0005Q%A\u0001x\u0011\u001d1\u0005\u00011A\u0005\u0002\u001d\u000bQa^0%KF$\"\u0001\f%\t\u000fA*\u0015\u0011!a\u0001M!1!\n\u0001Q!\n\u0019\n!a\u001e\u0011\t\u000b}\u0001A\u0011\u0001'\u0015\u0005\u0005j\u0005\"\u0002(L\u0001\u0004\t\u0013AC)vCR,'O\\5p]\")q\u0004\u0001C\u0001!R\u0019\u0011%U*\t\u000bI{\u0005\u0019\u0001\u0014\u0002\u000b\u0005tw\r\\3\t\u000bQ{\u0005\u0019A+\u0002\t\u0005D\u0018n\u001d\t\u0003-fk\u0011a\u0016\u0006\u00031\u0012\taA^3di>\u0014\u0018B\u0001.X\u0005\u001d1Vm\u0019;peNBQa\b\u0001\u0005\u0002q#R!I/`C\u000eDQAX.A\u0002\u0019\n\u0011\u0001\u001a\u0005\u0006An\u0003\rAJ\u0001\u0003IFBQAY.A\u0002\u0019\n!\u0001\u001a\u001a\t\u000b\u0011\\\u0006\u0019\u0001\u0014\u0002\u0005\u0011\u001c\u0004\"\u00024\u0001\t\u00039\u0017aA:fiR\u0011\u0011\u0005\u001b\u0005\u0006S\u0016\u0004\r!I\u0001\u0002c\")a\r\u0001C\u0001WR)\u0011\u0005\\7o_\")aL\u001ba\u0001M!)\u0001M\u001ba\u0001M!)!M\u001ba\u0001M!)AM\u001ba\u0001M!)\u0011\u000f\u0001C\u0001e\u0006i1/\u001a;Be>,h\u000eZ!ySN$R!I:vofDQ\u0001\u001e9A\u0002\u0019\n!!\u0019=\t\u000bY\u0004\b\u0019\u0001\u0014\u0002\u0005\u0005L\b\"\u0002=q\u0001\u00041\u0013AA1{\u0011\u0015Q\b\u000f1\u0001'\u00035y'/[4j]\u0006d\u0017I\\4mK\")\u0011\u000f\u0001C\u0001yR\u0019\u0011% @\t\u000bQ[\b\u0019A+\t\u000bI[\b\u0019\u0001\u0014\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004\u0005AQ.\u001e7uSBd\u0017\u0010F\u0002\"\u0003\u000bAQAT@A\u0002\u0005Bq!!\u0003\u0001\t\u0003\tY!A\u0007sS\u001eDG/T;mi&\u0004H.\u001f\u000b\u0004C\u00055\u0001B\u0002(\u0002\b\u0001\u0007\u0011\u0005\u0003\u0004\u0002\u0012\u0001!\t!J\u0001\n[\u0006<g.\u001b;vI\u0016Dq!!\u0006\u0001\t\u0003\t9\"A\u0005o_Jl\u0017\r\\5{KV\t\u0011\u0005\u0003\u0004\u0002\u001c\u0001!\t\u0005I\u0001\u0006G2|g.\u001a\u0005\u0007\u000b\u0001!\t%a\b\u0015\u0007U\u000b\t\u0003\u0003\u0004Y\u0003;\u0001\r!\u0016\u0005\b\u0003K\u0001A\u0011IA\u0014\u0003!!xn\u0015;sS:<GCAA\u0015!\u0011\tY#!\r\u000f\u0007U\ti#C\u0002\u00020Y\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u001a\u0003k\u0011aa\u0015;sS:<'bAA\u0018-\u0001")
public class Quaternion
implements Cloneable,
ITransform {
    private double x = 1.0;
    private double y = 0.0;
    private double z = 0.0;
    private double w = 0.0;

    public double x() {
        return this.x;
    }

    public void x_$eq(double x$1) {
        this.x = x$1;
    }

    public double y() {
        return this.y;
    }

    public void y_$eq(double x$1) {
        this.y = x$1;
    }

    public double z() {
        return this.z;
    }

    public void z_$eq(double x$1) {
        this.z = x$1;
    }

    public double w() {
        return this.w;
    }

    public void w_$eq(double x$1) {
        this.w = x$1;
    }

    public Quaternion set(Quaternion q) {
        this.x_$eq(q.x());
        this.y_$eq(q.y());
        this.z_$eq(q.z());
        this.w_$eq(q.w());
        return this;
    }

    public Quaternion set(double d, double d1, double d2, double d3) {
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        this.w_$eq(d);
        return this;
    }

    public Quaternion setAroundAxis(double ax, double ay, double az, double originalAngle) {
        double angle = originalAngle;
        double d4 = Math.sin(angle *= 0.5);
        return this.set(Math.cos(angle), ax * d4, ay * d4, az * d4);
    }

    public Quaternion setAroundAxis(Vector3 axis, double angle) {
        return this.setAroundAxis(axis.x(), axis.y(), axis.z(), angle);
    }

    public Quaternion multiply(Quaternion Quaternion2) {
        double d = this.w() * Quaternion2.w() - this.x() * Quaternion2.x() - this.y() * Quaternion2.y() - this.z() * Quaternion2.z();
        double d1 = this.w() * Quaternion2.x() + this.x() * Quaternion2.w() - this.y() * Quaternion2.z() + this.z() * Quaternion2.y();
        double d2 = this.w() * Quaternion2.y() + this.x() * Quaternion2.z() + this.y() * Quaternion2.w() - this.z() * Quaternion2.x();
        double d3 = this.w() * Quaternion2.z() - this.x() * Quaternion2.y() + this.y() * Quaternion2.x() + this.z() * Quaternion2.w();
        this.w_$eq(d);
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        return this;
    }

    public Quaternion rightMultiply(Quaternion Quaternion2) {
        double d = this.w() * Quaternion2.w() - this.x() * Quaternion2.x() - this.y() * Quaternion2.y() - this.z() * Quaternion2.z();
        double d1 = this.w() * Quaternion2.x() + this.x() * Quaternion2.w() + this.y() * Quaternion2.z() - this.z() * Quaternion2.y();
        double d2 = this.w() * Quaternion2.y() - this.x() * Quaternion2.z() + this.y() * Quaternion2.w() + this.z() * Quaternion2.x();
        double d3 = this.w() * Quaternion2.z() + this.x() * Quaternion2.y() - this.y() * Quaternion2.x() + this.z() * Quaternion2.w();
        this.w_$eq(d);
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        return this;
    }

    public double magnitude() {
        return Math.sqrt(this.x() * this.x() + this.y() * this.y() + this.z() * this.z() + this.w() * this.w());
    }

    public Quaternion normalize() {
        double d = this.magnitude();
        if (d != 0.0) {
            d = 1.0 / d;
            this.x_$eq(this.x() * d);
            this.y_$eq(this.y() * d);
            this.z_$eq(this.z() * d);
            this.w_$eq(this.w() * d);
        }
        return this;
    }

    public Quaternion clone() {
        return new Quaternion(this);
    }

    @Override
    public Vector3 transform(Vector3 vector) {
        double d = -this.x() * vector.x() - this.y() * vector.y() - this.z() * vector.z();
        double d1 = this.w() * vector.x() + this.y() * vector.z() - this.z() * vector.y();
        double d2 = this.w() * vector.y() - this.x() * vector.z() + this.z() * vector.x();
        double d3 = this.w() * vector.z() + this.x() * vector.y() - this.y() * vector.x();
        return new Vector3(d1 * this.w() - d * this.x() - d2 * this.z() + d3 * this.y(), d2 * this.w() - d * this.y() + d1 * this.z() - d3 * this.x(), d3 * this.w() - d * this.z() - d1 * this.y() + d2 * this.x());
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return new StringBuilder().append((Object)"Quaternion[").append((Object)new BigDecimal(this.w(), cont)).append((Object)", ").append((Object)new BigDecimal(this.x(), cont)).append((Object)", ").append((Object)new BigDecimal(this.y(), cont)).append((Object)", ").append((Object)new BigDecimal(this.z(), cont)).append((Object)"]").toString();
    }

    public Quaternion() {
    }

    public Quaternion(Quaternion Quaternion2) {
        this();
        this.x_$eq(Quaternion2.x());
        this.y_$eq(Quaternion2.y());
        this.z_$eq(Quaternion2.z());
        this.w_$eq(Quaternion2.w());
    }

    public Quaternion(double angle, Vector3 axis) {
        this();
        this.setAroundAxis(axis.x(), axis.y(), axis.z(), angle);
    }

    public Quaternion(double d, double d1, double d2, double d3) {
        this();
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        this.w_$eq(d);
    }
}

