/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.transform.vector;

import com.google.common.io.ByteArrayDataInput;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import scala.Cloneable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import universalelectricity.core.transform.AbstractVector;
import universalelectricity.core.transform.ITransform;
import universalelectricity.core.transform.rotation.EulerAngle;
import universalelectricity.core.transform.vector.IVector3;
import universalelectricity.core.transform.vector.Vector2;
import universalelectricity.core.transform.vector.Vector3$;
import universalelectricity.core.transform.vector.Vector3$$anonfun$getAround$1$;

@ScalaSignature(bytes="\u0006\u0001\u0011\rs!B\u0001\u0003\u0011\u0003Y\u0011a\u0002,fGR|'o\r\u0006\u0003\u0007\u0011\taA^3di>\u0014(BA\u0003\u0007\u0003%!(/\u00198tM>\u0014XN\u0003\u0002\b\u0011\u0005!1m\u001c:f\u0015\u0005I\u0011\u0001F;oSZ,'o]1mK2,7\r\u001e:jG&$\u0018p\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003\u000fY+7\r^8sgM\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001\"\u0002\u000e\u000e\t\u0003Y\u0012aB4fi2{wn\u001b\u000b\u00069\u0011mAQ\u0004\t\u0003\u0019u1AA\u0004\u0002\u0001=M!QdH\u0012'!\r\u0001\u0013\u0005H\u0007\u0002\t%\u0011!\u0005\u0002\u0002\u000f\u0003\n\u001cHO]1diZ+7\r^8s!\t\tB%\u0003\u0002&%\tI1\t\\8oK\u0006\u0014G.\u001a\t\u0003\u0019\u001dJ!\u0001\u000b\u0002\u0003\u0011%3Vm\u0019;peNB\u0001BK\u000f\u0003\u0002\u0004%\taK\u0001\u0002qV\tA\u0006\u0005\u0002\u0012[%\u0011aF\u0005\u0002\u0007\t>,(\r\\3\t\u0011Aj\"\u00111A\u0005\u0002E\nQ\u0001_0%KF$\"AM\u001b\u0011\u0005E\u0019\u0014B\u0001\u001b\u0013\u0005\u0011)f.\u001b;\t\u000fYz\u0013\u0011!a\u0001Y\u0005\u0019\u0001\u0010J\u0019\t\u0011aj\"\u0011!Q!\n1\n!\u0001\u001f\u0011\t\u0011ij\"\u00111A\u0005\u0002-\n\u0011!\u001f\u0005\tyu\u0011\t\u0019!C\u0001{\u0005)\u0011p\u0018\u0013fcR\u0011!G\u0010\u0005\bmm\n\t\u00111\u0001-\u0011!\u0001UD!A!B\u0013a\u0013AA=!\u0011!\u0011UD!a\u0001\n\u0003Y\u0013!\u0001>\t\u0011\u0011k\"\u00111A\u0005\u0002\u0015\u000bQA_0%KF$\"A\r$\t\u000fY\u001a\u0015\u0011!a\u0001Y!A\u0001*\bB\u0001B\u0003&A&\u0001\u0002{A!)q#\bC\u0001\u0015R!Ad\u0013'N\u0011\u0015Q\u0013\n1\u0001-\u0011\u0015Q\u0014\n1\u0001-\u0011\u0015\u0011\u0015\n1\u0001-\u0011\u00159R\u0004\"\u0001P)\u0005a\u0002\"B\f\u001e\t\u0003\tFC\u0001\u000fS\u0011\u0015\u0019\u0006\u000b1\u0001-\u0003\u0019\tWn\\;oi\")q#\bC\u0001+R\u0019AD\u0016-\t\u000b]#\u0006\u0019\u0001\u0017\u0002\u0007e\fw\u000fC\u0003Z)\u0002\u0007A&A\u0003qSR\u001c\u0007\u000eC\u0003\u0018;\u0011\u00051\f\u0006\u0002\u001d9\")QL\u0017a\u0001=\u0006!A/\u001b7f!\tyf-D\u0001a\u0015\t\t'-\u0001\u0006uS2,WM\u001c;jifT!a\u00193\u0002\u00135Lg.Z2sC\u001a$(\"A3\u0002\u00079,G/\u0003\u0002hA\nQA+\u001b7f\u000b:$\u0018\u000e^=\t\u000b]iB\u0011A5\u0015\u0005qQ\u0007\"B6i\u0001\u0004a\u0017AB3oi&$\u0018\u0010\u0005\u0002n_6\taN\u0003\u0002lE&\u0011\u0001O\u001c\u0002\u0007\u000b:$\u0018\u000e^=\t\u000b]iB\u0011\u0001:\u0015\u0005q\u0019\b\"\u0002;r\u0001\u00041\u0013a\u0001<fG\")q#\bC\u0001mR\u0011Ad\u001e\u0005\u0006iV\u0004\r\u0001\u001f\t\u0003srl\u0011A\u001f\u0006\u0003w\n\fA!\u001e;jY&\u0011QP\u001f\u0002\u0005-\u0016\u001c7\u0007C\u0003\u0018;\u0011\u0005q\u0010F\u0002\u001d\u0003\u0003Aq!a\u0001\u007f\u0001\u0004\t)!A\u0002oER\u0004B!a\u0002\u0002\f5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0007\u0011\u0017\u0002BA\u0007\u0003\u0013\u0011aB\u0014\"U)\u0006<7i\\7q_VtG\r\u0003\u0004\u0018;\u0011\u0005\u0011\u0011\u0003\u000b\u00049\u0005M\u0001\u0002CA\u000b\u0003\u001f\u0001\r!a\u0006\u0002\t\u0011\fG/\u0019\t\u0005\u00033\t9#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0019\u0011WO\u001a4fe*!\u0011\u0011EA\u0012\u0003\u0015qW\r\u001e;z\u0015\t\t)#\u0001\u0002j_&!\u0011\u0011FA\u000e\u0005\u001d\u0011\u0015\u0010^3Ck\u001aDaaF\u000f\u0005\u0002\u00055Bc\u0001\u000f\u00020!A\u0011\u0011GA\u0016\u0001\u0004\t\u0019$A\u0002eSJ\u0004B!!\u000e\u0002B5\u0011\u0011q\u0007\u0006\u0004w\u0006e\"\u0002BA\u001e\u0003{\taaY8n[>t'bAA I\u0006qQ.\u001b8fGJ\fg\r\u001e4pe\u001e,\u0017\u0002BA\"\u0003o\u0011aBR8sO\u0016$\u0015N]3di&|g\u000e\u0003\u0004\u0018;\u0011\u0005\u0011q\t\u000b\u00049\u0005%\u0003\u0002CA&\u0003\u000b\u0002\r!!\u0014\u0002\tA\f'/\r\t\u0004s\u0006=\u0013bAA)u\n!Rj\u001c<j]\u001e|%M[3diB{7/\u001b;j_:DaaF\u000f\u0005\u0002\u0005UCc\u0001\u000f\u0002X!A\u00111JA*\u0001\u0004\tI\u0006E\u0002z\u00037J1!!\u0018{\u0005A\u0019\u0005.\u001e8l\u0007>|'\u000fZ5oCR,7\u000f\u0003\u0004\u0018;\u0011\u0005\u0011\u0011\r\u000b\u00049\u0005\r\u0004\u0002CA3\u0003?\u0002\r!a\u001a\u0002\u0007A\f'\u000fE\u0003\u0002j\u0005eDF\u0004\u0003\u0002l\u0005Ud\u0002BA7\u0003gj!!a\u001c\u000b\u0007\u0005E$\"\u0001\u0004=e>|GOP\u0005\u0002'%\u0019\u0011q\u000f\n\u0002\u000fA\f7m[1hK&!\u00111PA?\u0005\r\u0019V-\u001d\u0006\u0004\u0003o\u0012\u0002BB\f\u001e\t\u0003\t\t\tF\u0002\u001d\u0003\u0007C\u0001\"!\u001a\u0002\u0000\u0001\u0007\u0011Q\u0011\t\u0007#\u0005\u001dE\u0006\f\u0017\n\u0007\u0005%%C\u0001\u0004UkBdWm\r\u0005\u0007/u!\t!!$\u0015\u0007q\ty\t\u0003\u0005\u0002\u0016\u0005-\u0005\u0019AAI!\u0011\t\u0019*!)\u000e\u0005\u0005U%\u0002BA\u0013\u0003/SA!a\u000f\u0002\u001a*!\u00111TAO\u0003\u00199wn\\4mK*\u0011\u0011qT\u0001\u0004G>l\u0017\u0002BAR\u0003+\u0013!CQ=uK\u0006\u0013(/Y=ECR\f\u0017J\u001c9vi\"1!&\bC\u0001\u0003O#2AMAU\u0011\u0019\u0019\u0016Q\u0015a\u0001Y!1!(\bC\u0001\u0003[#2AMAX\u0011\u0019\u0019\u00161\u0016a\u0001Y!1!)\bC\u0001\u0003g#2AMA[\u0011\u0019\u0019\u0016\u0011\u0017a\u0001Y!9\u0011\u0011X\u000f\u0005B\u0005m\u0016aA:fiR\u0019A$!0\t\rQ\f9\f1\u0001\u001d\u0011\u001d\t\t-\bC\u0001\u0003\u0007\fa\u0001^8WK\u000e\u001cT#\u0001=\t\u000f\u0005\u001dW\u0004\"\u0001\u0002J\u0006IAo\u001c,fGR|'OM\u000b\u0003\u0003\u0017\u00042\u0001DAg\u0013\r\tyM\u0001\u0002\b-\u0016\u001cGo\u001c:3\u0011\u001d\t\u0019.\bC\u0001\u0003+\fq\u0001^8BeJ\f\u00170\u0006\u0002\u0002XB!\u0011#!7-\u0013\r\tYN\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003?lB\u0011AAq\u0003\u0019!x\u000eT5tiV\u0011\u00111\u001d\t\u0006\u0003K\fy\u000fL\u0007\u0003\u0003OTA!!;\u0002l\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003[\u0014\u0012AC2pY2,7\r^5p]&!\u0011\u0011_At\u0005\u0011a\u0015n\u001d;\t\u000f\u0005UX\u0004\"\u0001\u0002x\u0006IAo\\%oi2K7\u000f^\u000b\u0003\u0003s\u0004b!!:\u0002p\u0006m\bcA\t\u0002~&\u0019\u0011q \n\u0003\u0007%sG\u000fC\u0004\u0003\u0004u!\tA!\u0002\u0002\u000fQ|G+\u001e9mKV\u0011\u0011Q\u0011\u0005\b\u0005\u0013iB\u0011\u0001B\u0006\u0003A!xNR8sO\u0016$\u0015N]3di&|g.\u0006\u0002\u00024!9!qB\u000f\u0005B\tE\u0011\u0001C<sSR,gJ\u0011+\u0015\t\u0005\u0015!1\u0003\u0005\t\u0003\u0007\u0011i\u00011\u0001\u0002\u0006!9!qC\u000f\u0005\u0002\te\u0011\u0001\u0003;p\u0013:$hJ\u0011+\u0016\u0005\u0005\u0015\u0001b\u0002B\u000f;\u0011\u0005!qD\u0001\foJLG/Z%oi:\u0013E\u000b\u0006\u0003\u0002\u0006\t\u0005\u0002\u0002CA\u0002\u00057\u0001\r!!\u0002\t\u000f\t\u0015R\u0004\"\u0011\u0003(\u0005aqO]5uK\nKH/\u001a\"vMR!\u0011q\u0003B\u0015\u0011!\t)Ba\tA\u0002\u0005]\u0001b\u0002B\u0017;\u0011\u0005!qF\u0001\ri>,U\u000f\\3s\u0003:<G.Z\u000b\u0003\u0005c\u0001BAa\r\u0003:5\u0011!Q\u0007\u0006\u0004\u0005o!\u0011\u0001\u0003:pi\u0006$\u0018n\u001c8\n\t\tm\"Q\u0007\u0002\u000b\u000bVdWM]!oO2,\u0007b\u0002B\u0017;\u0011\u0005!q\b\u000b\u0005\u0005c\u0011\t\u0005C\u0004\u0003D\tu\u0002\u0019\u0001\u000f\u0002\rQ\f'oZ3u\u0011\u001d\u00119%\bC\u0001\u0005\u0013\n!\u0001_5\u0016\u0005\u0005m\bb\u0002B';\u0011\u0005!\u0011J\u0001\u0003s&DqA!\u0015\u001e\t\u0003\u0011I%\u0001\u0002{S\"9!QK\u000f\u0005\u0002\t]\u0013A\u0001=g+\t\u0011I\u0006E\u0002\u0012\u00057J1A!\u0018\u0013\u0005\u00151En\\1u\u0011\u001d\u0011\t'\bC\u0001\u0005/\n!!\u001f4\t\u000f\t\u0015T\u0004\"\u0001\u0003X\u0005\u0011!P\u001a\u0005\b\u0005SjB\u0011\tB6\u0003\u0015\u0011x.\u001e8e+\u0005a\u0002b\u0002B8;\u0011\u0005#1N\u0001\u0005G\u0016LG\u000eC\u0004\u0003tu!\tEa\u001b\u0002\u000b\u0019dwn\u001c:\t\u000f\t]T\u0004\"\u0001\u0003z\u0005\u0019Q.\u0019=\u0015\u0007q\u0011Y\bC\u0004\u0003~\tU\u0004\u0019\u0001\u000f\u0002\u000b=$\b.\u001a:\t\u000f\t\u0005U\u0004\"\u0001\u0003\u0004\u0006\u0019Q.\u001b8\u0015\u0007q\u0011)\tC\u0004\u0003~\t}\u0004\u0019\u0001\u000f\t\r\t%U\u0004\"\u0011P\u0003)\u0011XmY5qe>\u001c\u0017\r\u001c\u0005\b\u0005\u001bkB\u0011\tBH\u0003\u0015!\u0003\u000f\\;t)\ra\"\u0011\u0013\u0005\u0007'\n-\u0005\u0019\u0001\u0017\t\u000f\t5U\u0004\"\u0011\u0003\u0016R\u0019ADa&\t\rM\u0013\u0019\n1\u0001\u001d\u0011\u001d\u0011i)\bC\u0001\u00057#r\u0001\bBO\u0005?\u0013\t\u000b\u0003\u0004+\u00053\u0003\r\u0001\f\u0005\u0007u\te\u0005\u0019\u0001\u0017\t\r\t\u0013I\n1\u0001-\u0011\u001d\u0011)+\bC\u0001\u0005O\u000b\u0001\u0002\n9mkN$S-\u001d\u000b\b9\t%&1\u0016BW\u0011\u0019Q#1\u0015a\u0001Y!1!Ha)A\u00021BaA\u0011BR\u0001\u0004a\u0003b\u0002BY;\u0011\u0005!1W\u0001\u0004C\u0012$Gc\u0002\u000f\u00036\n]&\u0011\u0018\u0005\u0007U\t=\u0006\u0019\u0001\u0017\t\ri\u0012y\u000b1\u0001-\u0011\u0019\u0011%q\u0016a\u0001Y!9!QX\u000f\u0005\u0002\t}\u0016!C1eI\u0016\u000bX/\u00197t)\u001da\"\u0011\u0019Bb\u0005\u000bDaA\u000bB^\u0001\u0004a\u0003B\u0002\u001e\u0003<\u0002\u0007A\u0006\u0003\u0004C\u0005w\u0003\r\u0001\f\u0005\b\u0005\u001bkB\u0011\u0001Be)\ra\"1\u001a\u0005\b'\n\u001d\u0007\u0019AA\u001a\u0011\u001d\u0011)+\bC\u0001\u0005\u001f$2\u0001\bBi\u0011\u001d\u0019&Q\u001aa\u0001\u0003gAqA!-\u001e\t\u0003\u0011)\u000eF\u0002\u001d\u0005/Dqa\u0015Bj\u0001\u0004\t\u0019\u0004C\u0004\u0003>v!\tAa7\u0015\u0007q\u0011i\u000eC\u0004T\u00053\u0004\r!a\r\t\u000f\t\u0005X\u0004\"\u0011\u0003d\u00061A\u0005^5nKN$2\u0001\bBs\u0011\u0019\u0019&q\u001ca\u0001Y!9!\u0011]\u000f\u0005B\t%Hc\u0001\u000f\u0003l\"11Ka:A\u0002qAqAa<\u001e\t\u0003\u0012\t0A\u0001%)\ra#1\u001f\u0005\b\u0005{\u0012i\u000f1\u0001\u001d\u0011\u001d\u001190\bC\u0001\u0005s\fQa\u0019:pgN$2\u0001\bB~\u0011\u001d\u0011iH!>A\u0002qAqAa@\u001e\t\u0003\u0019\t!\u0001\u0005%a\u0016\u00148-\u001a8u)\ra21\u0001\u0005\b\u0005{\u0012i\u00101\u0001\u001d\u0011\u001d\u00199!\bC\u0001\u0005W\na\u0001_\"s_N\u001c\bbBB\u0006;\u0011\u0005!1N\u0001\u0007u\u000e\u0013xn]:\t\u000f\r=Q\u0004\"\u0001\u0004\u0012\u0005AQ.\u001b3Q_&tG\u000fF\u0002\u001d\u0007'Aqa!\u0006\u0004\u000e\u0001\u0007A$A\u0002q_NDqa!\u0007\u001e\t\u0003\u0011Y'A\u0007qKJ\u0004XM\u001c3jGVd\u0017M\u001d\u0005\b\u0007;iB\u0011AB\u0010\u0003\u0019I7OW3s_V\u00111\u0011\u0005\t\u0004#\r\r\u0012bAB\u0013%\t9!i\\8mK\u0006t\u0007BB\u0003\u001e\t\u0003\u0019I\u0003F\u0002\u001d\u0007WA\u0001b!\f\u0004(\u0001\u00071qF\u0001\fiJ\fgn\u001d4pe6,'\u000fE\u0002!\u0007cI1aa\r\u0005\u0005)IEK]1og\u001a|'/\u001c\u0005\b\u0007oiB\u0011AB\u001d\u0003\u0015\tgn\u001a7f)\ra31\b\u0005\b\u0005{\u001a)\u00041\u0001\u001d\u0011\u001d\u0019y$\bC\u0001\u0007\u0003\nA\"\u00198hY\u0016\u0004&/\u001a(pe6$2\u0001LB\"\u0011\u001d\u0011ih!\u0010A\u0002qAqaa\u0012\u001e\t\u0003\u0019I%A\u0005hKR\f%o\\;oIRA11JB,\u0007K\u001aI\u0007E\u0003\u0004N\rUC$\u0004\u0002\u0004P)\u00191p!\u0015\u000b\u0005\rM\u0013\u0001\u00026bm\u0006LA!!=\u0004P!A1\u0011LB#\u0001\u0004\u0019Y&A\u0003x_JdG\r\u0005\u0003\u0004^\r\u0005TBAB0\u0015\r\u0019IFY\u0005\u0005\u0007G\u001ayFA\u0003X_JdG\r\u0003\u0005\u0004h\r\u0015\u0003\u0019AA\u001a\u0003\u0011\u0019\u0018\u000eZ3\t\u0011\r-4Q\ta\u0001\u0003w\fQA]1oO\u0016Dqaa\u001c\u001e\t\u0003\u0019\t(\u0001\u0005sCf$&/Y2f)!\tiea\u001d\u0004v\r]\u0004\u0002CB-\u0007[\u0002\raa\u0017\t\u000f\u0005E2Q\u000ea\u00019!91\u0011PB7\u0001\u0004a\u0013\u0001\u00023jgRDqaa\u001c\u001e\t\u0003\u0019i\b\u0006\u0004\u0002N\r}4\u0011\u0011\u0005\t\u00073\u001aY\b1\u0001\u0004\\!911QB>\u0001\u0004a\u0012aA3oI\"91qQ\u000f\u0005\u0002\r%\u0015A\u0004:bsR\u0013\u0018mY3CY>\u001c7n\u001d\u000b\u0007\u0003\u001b\u001aYi!$\t\u0011\re3Q\u0011a\u0001\u00077Bqaa!\u0004\u0006\u0002\u0007A\u0004C\u0004\u0004\u0012v!\taa%\u0002!I\f\u0017\u0010\u0016:bG\u0016,e\u000e^5uS\u0016\u001cHCBA'\u0007+\u001b9\n\u0003\u0005\u0004Z\r=\u0005\u0019AB.\u0011\u001d\u0019\u0019ia$A\u0002qAqaa'\u001e\t\u0003\u0019i*\u0001\u0005hKR\u0014En\\2l)\u0011\u0019yja+\u0011\t\r\u00056qU\u0007\u0003\u0007GS1a!*c\u0003\u0015\u0011Gn\\2l\u0013\u0011\u0019Ika)\u0003\u000b\tcwnY6\t\u0011\re3\u0011\u0014a\u0001\u0007[\u0003Ba!\u0018\u00040&!1\u0011WB0\u00051I%\t\\8dW\u0006\u001b7-Z:t\u0011\u001d\u0019),\bC\u0001\u0007o\u000b\u0001cZ3u\u00052|7m['fi\u0006$\u0017\r^1\u0015\t\u0005m8\u0011\u0018\u0005\t\u00073\u001a\u0019\f1\u0001\u0004.\"91QX\u000f\u0005\u0002\r}\u0016!D4fiRKG.Z#oi&$\u0018\u0010F\u0002_\u0007\u0003D\u0001b!\u0017\u0004<\u0002\u00071Q\u0016\u0005\b\u0007\u000blB\u0011ABd\u0003!\u0019X\r\u001e\"m_\u000e\\GCCB\u0011\u0007\u0013\u001cYm!4\u0004R\"A1\u0011LBb\u0001\u0004\u0019Y\u0006\u0003\u0005\u0004&\u000e\r\u0007\u0019ABP\u0011!\u0019yma1A\u0002\u0005m\u0018\u0001C7fi\u0006$\u0017\r^1\t\u0011\rM71\u0019a\u0001\u0003w\faA\\8uS\u001aL\bbBBc;\u0011\u00051q\u001b\u000b\t\u0007C\u0019Ina7\u0004^\"A1\u0011LBk\u0001\u0004\u0019Y\u0006\u0003\u0005\u0004&\u000eU\u0007\u0019ABP\u0011!\u0019ym!6A\u0002\u0005m\bbBBc;\u0011\u00051\u0011\u001d\u000b\u0007\u0007C\u0019\u0019o!:\t\u0011\re3q\u001ca\u0001\u00077B\u0001b!*\u0004`\u0002\u00071q\u0014\u0005\b\u0007SlB\u0011ABv\u00035\u0019X\r\u001e\"m_\u000e\\Gk\\!jeR!1\u0011EBw\u0011!\u0019Ifa:A\u0002\rm\u0003bBBy;\u0011\u000531_\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111 \u0005\b\u0007olB\u0011IB}\u0003\u0019)\u0017/^1mgR!1\u0011EB~\u0011!\u0019ip!>A\u0002\r}\u0018!A8\u0011\u0007E!\t!C\u0002\u0005\u0004I\u00111!\u00118z\u0011\u0019!9!\bC!\u001f\u0006)1\r\\8oK\"9A1B\u000f\u0005B\u00115\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0011=\u0001\u0003\u0002C\t\t/i!\u0001b\u0005\u000b\t\u0011U1\u0011K\u0001\u0005Y\u0006tw-\u0003\u0003\u0005\u001a\u0011M!AB*ue&tw\rC\u0003l3\u0001\u0007A\u000e\u0003\u0004\u0005 e\u0001\r\u0001L\u0001\tI&\u001cH/\u00198dK\"1!$\u0004C\u0001\tG!r\u0001\bC\u0013\tO!I\u0003\u0003\u0004X\tC\u0001\r\u0001\f\u0005\u00073\u0012\u0005\u0002\u0019\u0001\u0017\t\u000f\u0011}A\u0011\u0005a\u0001Y!9AQF\u0007\u0005\u0002\t-\u0014AA;q\u0011\u001d!\t$\u0004C\u0001\u0005W\nA\u0001Z8x]\"9AQG\u0007\u0005\u0002\t-\u0014!\u00028peRD\u0007b\u0002C\u001d\u001b\u0011\u0005!1N\u0001\u0006g>,H\u000f\u001b\u0005\b\t{iA\u0011\u0001B6\u0003\u0011)\u0017m\u001d;\t\u000f\u0011\u0005S\u0002\"\u0001\u0003l\u0005!q/Z:u\u0001")
public class Vector3
extends AbstractVector<Vector3>
implements Cloneable,
IVector3 {
    private double x;
    private double y;
    private double z;

    public static Vector3 west() {
        return Vector3$.MODULE$.west();
    }

    public static Vector3 east() {
        return Vector3$.MODULE$.east();
    }

    public static Vector3 south() {
        return Vector3$.MODULE$.south();
    }

    public static Vector3 north() {
        return Vector3$.MODULE$.north();
    }

    public static Vector3 down() {
        return Vector3$.MODULE$.down();
    }

    public static Vector3 up() {
        return Vector3$.MODULE$.up();
    }

    public static Vector3 getLook(double d, double d2, double d3) {
        return Vector3$.MODULE$.getLook(d, d2, d3);
    }

    public static Vector3 getLook(Entity entity, double d) {
        return Vector3$.MODULE$.getLook(entity, d);
    }

    @Override
    public double x() {
        return this.x;
    }

    public void x_$eq(double x$1) {
        this.x = x$1;
    }

    @Override
    public double y() {
        return this.y;
    }

    public void y_$eq(double x$1) {
        this.y = x$1;
    }

    @Override
    public double z() {
        return this.z;
    }

    public void z_$eq(double x$1) {
        this.z = x$1;
    }

    public void x(double amount) {
        this.x_$eq(amount);
    }

    public void y(double amount) {
        this.y_$eq(amount);
    }

    public void z(double amount) {
        this.z_$eq(amount);
    }

    @Override
    public Vector3 set(Vector3 vec) {
        this.x_$eq(vec.x());
        this.y_$eq(vec.y());
        this.z_$eq(vec.z());
        return this;
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x(), (double)this.y(), (double)this.z());
    }

    public Vector2 toVector2() {
        return new Vector2(this.x(), this.z());
    }

    public double[] toArray() {
        return new double[]{this.x(), this.y(), this.z()};
    }

    public List<Object> toList() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{this.x(), this.y(), this.z()}));
    }

    public List<Object> toIntList() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{(int)this.x(), (int)this.y(), (int)this.z()}));
    }

    public Tuple3<Object, Object, Object> toTuple() {
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)this.x()), (Object)BoxesRunTime.boxToDouble((double)this.y()), (Object)BoxesRunTime.boxToDouble((double)this.z()));
    }

    public ForgeDirection toForgeDirection() {
        Option option = Predef$.MODULE$.refArrayOps((Object[])ForgeDirection.VALID_DIRECTIONS).find((Function1)new $anonfun$1(this));
        if (option instanceof Some) {
            Some some = (Some)option;
            ForgeDirection entry = (ForgeDirection)some.x();
            return entry;
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("x", this.x());
        nbt.func_74780_a("y", this.y());
        nbt.func_74780_a("z", this.z());
        return nbt;
    }

    public NBTTagCompound toIntNBT() {
        return this.writeIntNBT(new NBTTagCompound());
    }

    public NBTTagCompound writeIntNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("x", (int)this.x());
        nbt.func_74768_a("y", (int)this.y());
        nbt.func_74768_a("z", (int)this.z());
        return nbt;
    }

    @Override
    public ByteBuf writeByteBuf(ByteBuf data) {
        data.writeDouble(this.x());
        data.writeDouble(this.y());
        data.writeDouble(this.z());
        return data;
    }

    public EulerAngle toEulerAngle() {
        return new EulerAngle(Math.toDegrees(Math.atan2(this.x(), this.z())), Math.toDegrees(-Math.atan2(this.y(), Math.hypot(this.z(), this.x()))));
    }

    public EulerAngle toEulerAngle(Vector3 target) {
        return this.clone().$minus(target).toEulerAngle();
    }

    public int xi() {
        return (int)this.x();
    }

    public int yi() {
        return (int)this.y();
    }

    public int zi() {
        return (int)this.z();
    }

    public float xf() {
        return (float)this.x();
    }

    public float yf() {
        return (float)this.y();
    }

    public float zf() {
        return (float)this.z();
    }

    @Override
    public Vector3 round() {
        return new Vector3(Math.round(this.x()), Math.round(this.y()), Math.round(this.z()));
    }

    @Override
    public Vector3 ceil() {
        return new Vector3(Math.ceil(this.x()), Math.ceil(this.y()), Math.ceil(this.z()));
    }

    @Override
    public Vector3 floor() {
        return new Vector3(Math.floor(this.x()), Math.floor(this.y()), Math.floor(this.z()));
    }

    @Override
    public Vector3 max(Vector3 other) {
        return new Vector3(Math.max(this.x(), other.x()), Math.max(this.y(), other.y()), Math.max(this.z(), other.z()));
    }

    @Override
    public Vector3 min(Vector3 other) {
        return new Vector3(Math.min(this.x(), other.x()), Math.min(this.y(), other.y()), Math.min(this.z(), other.z()));
    }

    @Override
    public Vector3 reciprocal() {
        return new Vector3(1.0 / this.x(), 1.0 / this.y(), 1.0 / this.z());
    }

    @Override
    public Vector3 $plus(double amount) {
        return new Vector3(this.x() + amount, this.y() + amount, this.z() + amount);
    }

    @Override
    public Vector3 $plus(Vector3 amount) {
        return new Vector3(this.x() + amount.x(), this.y() + amount.y(), this.z() + amount.z());
    }

    public Vector3 $plus(double x, double y, double z) {
        return new Vector3(this.x() + x, this.y() + y, this.z() + z);
    }

    public Vector3 $plus$eq(double x, double y, double z) {
        return this.set(new Vector3(this.x() + x, this.y() + y, this.z() + z));
    }

    public Vector3 add(double x, double y, double z) {
        return this.$plus(x, y, z);
    }

    public Vector3 addEquals(double x, double y, double z) {
        return this.$plus$eq(x, y, z);
    }

    @Override
    public Vector3 $plus(ForgeDirection amount) {
        return this.$plus(new Vector3(amount));
    }

    @Override
    public Vector3 $plus$eq(ForgeDirection amount) {
        return this.set(this.$plus(new Vector3(amount)));
    }

    @Override
    public Vector3 add(ForgeDirection amount) {
        return this.$plus(amount);
    }

    @Override
    public Vector3 addEquals(ForgeDirection amount) {
        return this.$plus$eq(amount);
    }

    @Override
    public Vector3 $times(double amount) {
        return new Vector3(this.x() * amount, this.y() * amount, this.z() * amount);
    }

    @Override
    public Vector3 $times(Vector3 amount) {
        return new Vector3(this.x() * amount.x(), this.y() * amount.y(), this.z() * amount.z());
    }

    @Override
    public double $(Vector3 other) {
        return this.x() * other.x() + this.y() * other.y() + this.z() * other.z();
    }

    public Vector3 cross(Vector3 other) {
        return this.$percent(other);
    }

    public Vector3 $percent(Vector3 other) {
        return new Vector3(this.y() * other.z() - this.z() * other.y(), this.z() * other.x() - this.x() * other.z(), this.x() * other.y() - this.y() * other.x());
    }

    public Vector3 xCross() {
        return new Vector3(0.0, this.z(), -this.y());
    }

    public Vector3 zCross() {
        return new Vector3(-this.y(), this.x(), 0.0);
    }

    public Vector3 midPoint(Vector3 pos) {
        return new Vector3((this.x() + pos.x()) / (double)2, (this.y() + pos.y()) / (double)2, (this.z() + pos.z()) / (double)2);
    }

    public Vector3 perpendicular() {
        if (this.z() == 0.0) {
            return this.zCross();
        }
        return this.xCross();
    }

    public boolean isZero() {
        return this.x() == 0.0 && this.y() == 0.0 && this.z() == 0.0;
    }

    public Vector3 transform(ITransform transformer) {
        return transformer.transform(this);
    }

    public double angle(Vector3 other) {
        return Math.acos(this.$(other) / (this.magnitude() * other.magnitude()));
    }

    public double anglePreNorm(Vector3 other) {
        return Math.acos(this.$(other));
    }

    public java.util.List<Vector3> getAround(World world, ForgeDirection side, int range) {
        ArrayList<Vector3> list = new ArrayList<Vector3>();
        ForgeDirection forgeDirection = side;
        int n = ForgeDirection.EAST.equals(forgeDirection) ? 0 : (ForgeDirection.WEST.equals(forgeDirection) ? 0 : range);
        int dx = n;
        ForgeDirection forgeDirection2 = side;
        int n2 = ForgeDirection.DOWN.equals(forgeDirection2) ? 0 : (ForgeDirection.UP.equals(forgeDirection2) ? 0 : range);
        int dy = n2;
        ForgeDirection forgeDirection3 = side;
        int n3 = ForgeDirection.NORTH.equals(forgeDirection3) ? 0 : (ForgeDirection.SOUTH.equals(forgeDirection3) ? 0 : range);
        int dz = n3;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.xi() - dx), this.xi() + dx).foreach$mVc$sp((Function1)new Serializable(this, list, dx, dy, dz){
            private final /* synthetic */ Vector3 $outer;
            public final java.util.List list$1;
            private final int dx$1;
            private final int dy$1;
            public final int dz$1;

            public final void apply(int x) {
                this.apply$mcVI$sp(x);
            }

            public void apply$mcVI$sp(int x) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.$outer.yi() - this.dy$1), this.$outer.yi() + this.dx$1).foreach$mVc$sp((Function1)new Serializable(this, x){
                    private final /* synthetic */ $anonfun$getAround$1 $outer;
                    public final int x$2;

                    public final void apply(int y) {
                        this.apply$mcVI$sp(y);
                    }

                    public void apply$mcVI$sp(int y) {
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.$outer.universalelectricity$core$transform$vector$Vector3$$anonfun$$$outer().zi() - this.$outer.dz$1), this.$outer.universalelectricity$core$transform$vector$Vector3$$anonfun$$$outer().zi() + this.$outer.dz$1).foreach((Function1)new Serializable(this, y){
                            private final /* synthetic */ $anonfun$getAround$1$$anonfun$apply$mcVI$sp$1 $outer;
                            private final int y$1;

                            public final boolean apply(int z) {
                                return this.apply$mcZI$sp(z);
                            }

                            public boolean apply$mcZI$sp(int z) {
                                return this.$outer.universalelectricity$core$transform$vector$Vector3$$anonfun$$anonfun$$$outer().list$1.add(new Vector3(this.$outer.x$2, this.y$1, z));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.y$1 = y$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$getAround$1 universalelectricity$core$transform$vector$Vector3$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x$2 = x$2;
                    }
                });
            }

            public /* synthetic */ Vector3 universalelectricity$core$transform$vector$Vector3$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.list$1 = list$1;
                this.dx$1 = dx$1;
                this.dy$1 = dy$1;
                this.dz$1 = dz$1;
            }
        });
        return list;
    }

    public MovingObjectPosition rayTrace(World world, Vector3 dir, double dist) {
        return this.rayTrace(world, this.$plus(dir.$times(dist)));
    }

    public MovingObjectPosition rayTrace(World world, Vector3 end) {
        MovingObjectPosition block = this.rayTraceBlocks(world, end);
        MovingObjectPosition entity = this.rayTraceEntities(world, end);
        if (block == null) {
            return entity;
        }
        if (entity == null) {
            return block;
        }
        Vector3 vector3 = new Vector3(block.field_72307_f);
        Vector3 vector32 = new Vector3(entity.field_72307_f);
        if (this.distance(vector3) < this.distance(vector32)) {
            return block;
        }
        return entity;
    }

    public MovingObjectPosition rayTraceBlocks(World world, Vector3 end) {
        return world.func_72933_a(this.toVec3(), end.toVec3());
    }

    public MovingObjectPosition rayTraceEntities(World world, Vector3 end) {
        ObjectRef closestEntityMOP = ObjectRef.create(null);
        DoubleRef closetDistance = DoubleRef.create((double)0.0);
        double checkDistance = this.distance(end);
        AxisAlignedBB scanRegion = AxisAlignedBB.func_72330_a((double)(-checkDistance), (double)(-checkDistance), (double)(-checkDistance), (double)checkDistance, (double)checkDistance, (double)checkDistance).func_72317_d(this.x(), this.y(), this.z());
        Buffer checkEntities = (Buffer)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(world.func_72872_a(Entity.class, scanRegion)).map((Function1)new Serializable(this){

            public final Entity apply(Object x$1) {
                return (Entity)x$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        checkEntities.foreach((Function1)new Serializable(this, end, closestEntityMOP, closetDistance){
            private final /* synthetic */ Vector3 $outer;
            private final Vector3 end$1;
            private final ObjectRef closestEntityMOP$1;
            private final DoubleRef closetDistance$1;

            public final void apply(Entity entity) {
                float border;
                AxisAlignedBB bounds;
                MovingObjectPosition hit;
                if (entity != null && entity.func_70067_L() && entity.field_70121_D != null && (hit = (bounds = entity.field_70121_D.func_72314_b((double)(border = entity.func_70111_Y()), (double)border, (double)border)).func_72327_a(this.$outer.toVec3(), this.end$1.toVec3())) != null) {
                    if (bounds.func_72318_a(this.$outer.toVec3())) {
                        if (0.0 < this.closetDistance$1.elem || this.closetDistance$1.elem == 0.0) {
                            this.closestEntityMOP$1.elem = new MovingObjectPosition(entity);
                            ((MovingObjectPosition)this.closestEntityMOP$1.elem).field_72307_f = hit.field_72307_f;
                            this.closetDistance$1.elem = 0.0;
                        }
                    } else {
                        double dist = this.$outer.distance(new Vector3(hit.field_72307_f));
                        if (dist < this.closetDistance$1.elem || this.closetDistance$1.elem == 0.0) {
                            this.closestEntityMOP$1.elem = new MovingObjectPosition(entity);
                            ((MovingObjectPosition)this.closestEntityMOP$1.elem).field_72307_f = hit.field_72307_f;
                            this.closetDistance$1.elem = dist;
                        }
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.end$1 = end$1;
                this.closestEntityMOP$1 = closestEntityMOP$1;
                this.closetDistance$1 = closetDistance$1;
            }
        });
        return (MovingObjectPosition)closestEntityMOP.elem;
    }

    public Block getBlock(IBlockAccess world) {
        return world == null ? null : world.func_147439_a(this.xi(), this.yi(), this.zi());
    }

    public int getBlockMetadata(IBlockAccess world) {
        return world == null ? 0 : world.func_72805_g(this.xi(), this.yi(), this.zi());
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world == null ? null : world.func_147438_o(this.xi(), this.yi(), this.zi());
    }

    public boolean setBlock(World world, Block block, int metadata, int notify) {
        return world == null || block == null ? false : world.func_147465_d(this.xi(), this.yi(), this.zi(), block, metadata, notify);
    }

    public boolean setBlock(World world, Block block, int metadata) {
        return this.setBlock(world, block, metadata, 3);
    }

    public boolean setBlock(World world, Block block) {
        return this.setBlock(world, block, 0);
    }

    public boolean setBlockToAir(World world) {
        return world.func_147468_f(this.xi(), this.yi(), this.zi());
    }

    public int hashCode() {
        long x = Double.doubleToLongBits(this.x());
        long y = Double.doubleToLongBits(this.y());
        long z = Double.doubleToLongBits(this.z());
        long hash = x ^ x >>> 32;
        hash = 31L * hash + y ^ y >>> 32;
        hash = 31L * hash + z ^ z >>> 32;
        return (int)hash;
    }

    public boolean equals(Object o) {
        if (o instanceof IVector3) {
            IVector3 other = (IVector3)o;
            return other.x() == this.x() && other.y() == this.y() && other.z() == this.z();
        }
        return false;
    }

    public Vector3 clone() {
        return new Vector3(this.x(), this.y(), this.z());
    }

    public String toString() {
        return new StringBuilder().append((Object)"Vector3[").append((Object)BoxesRunTime.boxToDouble((double)this.x())).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)this.y())).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)this.z())).append((Object)"]").toString();
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3(double amount) {
        this(amount, amount, amount);
    }

    public Vector3(double yaw, double pitch) {
        this(-Math.sin(Math.toRadians(yaw)), Math.sin(Math.toRadians(pitch)), -Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)));
    }

    public Vector3(TileEntity tile) {
        this(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public Vector3(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public Vector3(IVector3 vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public Vector3(Vec3 vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vector3(NBTTagCompound nbt) {
        this(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public Vector3(ByteBuf data) {
        this(data.readDouble(), data.readDouble(), data.readDouble());
    }

    public Vector3(ForgeDirection dir) {
        this(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Vector3(MovingObjectPosition par1) {
        this(par1.field_72311_b, par1.field_72312_c, par1.field_72309_d);
    }

    public Vector3(ChunkCoordinates par1) {
        this(par1.field_71574_a, par1.field_71572_b, par1.field_71573_c);
    }

    public Vector3(Seq<Object> par) {
        this(BoxesRunTime.unboxToDouble((Object)par.apply(0)), BoxesRunTime.unboxToDouble((Object)par.apply(1)), BoxesRunTime.unboxToDouble((Object)par.apply(2)));
    }

    public Vector3(Tuple3<Object, Object, Object> par) {
        this(BoxesRunTime.unboxToDouble((Object)par._1()), BoxesRunTime.unboxToDouble((Object)par._2()), BoxesRunTime.unboxToDouble((Object)par._3()));
    }

    public Vector3(ByteArrayDataInput data) {
        this(data.readInt(), data.readInt(), data.readInt());
    }
}

