/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.simulator.grid;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import universalelectricity.api.core.grid.INode;
import universalelectricity.api.core.grid.INodeProvider;
import universalelectricity.api.core.grid.sim.ISimNode;
import universalelectricity.simulator.grid.SimulatedGrid;
import universalelectricity.simulator.grid.component.NetworkPart;
import universalelectricity.simulator.grid.component.SimNode;
import universalelectricity.simulator.grid.component.WireJunction;
import universalelectricity.simulator.grid.component.WirePath;

public class GridPathfinder {
    private SimulatedGrid grid;
    private List<NetworkPart> parts = new LinkedList<NetworkPart>();
    private List<ISimNode> pathNodes = new LinkedList<ISimNode>();

    public GridPathfinder(SimulatedGrid grid) {
        this.grid = grid;
    }

    public List<NetworkPart> generateParts() {
        ISimNode firstNode = (ISimNode)this.grid.getFirstNode();
        if (firstNode != null) {
            this.path(null, firstNode, null);
        }
        return this.parts;
    }

    public void path(NetworkPart part, ISimNode currentNode, ForgeDirection side) {
        Map<Object, ForgeDirection> connections = currentNode.getConnections();
        NetworkPart nextPart = null;
        this.pathNodes.add(currentNode);
        if (connections.size() > 2) {
            nextPart = new WireJunction(this.grid, currentNode);
            if (part instanceof WirePath) {
                ((WirePath)part).setConnectionB(nextPart);
            } else if (part instanceof WireJunction) {
                ((WireJunction)part).add(nextPart, side);
            }
        } else if (part instanceof WirePath) {
            ((WirePath)part).add(currentNode);
            nextPart = part;
        } else {
            nextPart = new WirePath(this.grid, currentNode);
            if (part != null) {
                ((WirePath)nextPart).setConnectionA(part);
            }
            if (part instanceof WireJunction) {
                ((WireJunction)part).add(nextPart, side);
            }
        }
        for (Map.Entry<Object, ForgeDirection> entry : connections.entrySet()) {
            INode providerNode;
            if (entry.getKey() instanceof SimNode) {
                if (this.pathNodes.contains(entry.getKey())) continue;
                this.path(nextPart, (SimNode)entry.getKey(), entry.getValue());
                continue;
            }
            if (!(entry.getKey() instanceof INodeProvider) || !((providerNode = ((INodeProvider)entry.getKey()).getNode(SimNode.class, entry.getValue().getOpposite())) instanceof SimNode) || this.pathNodes.contains(entry.getKey())) continue;
            this.path(nextPart, (SimNode)entry.getKey(), entry.getValue());
        }
    }

    public void reset() {
        this.parts.clear();
        this.pathNodes.clear();
    }
}

