/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.simulator.grid;

import java.util.List;
import universalelectricity.api.core.grid.IUpdate;
import universalelectricity.api.core.grid.sim.ISimNode;
import universalelectricity.core.grid.Grid;
import universalelectricity.core.grid.UpdateTicker;
import universalelectricity.simulator.grid.GridPathfinder;
import universalelectricity.simulator.grid.component.IComponent;
import universalelectricity.simulator.grid.component.NetworkPart;

public class SimulatedGrid
extends Grid<ISimNode>
implements IUpdate {
    protected boolean hasChanged = false;
    protected long ticks = 0L;
    List<NetworkPart> parts;

    public SimulatedGrid(ISimNode ... nodes) {
        super(ISimNode.class);
        for (ISimNode node : nodes) {
            this.add(node);
        }
        UpdateTicker.addUpdater(this);
    }

    @Override
    public void add(ISimNode node) {
        this.hasChanged = true;
        super.add(node);
    }

    @Override
    public void remove(ISimNode node) {
        this.hasChanged = true;
        super.remove(node);
    }

    @Override
    public void update(double deltaTime) {
        ++this.ticks;
        if (this.ticks == 1L) {
            this.buildEntireNetwork();
        } else if (this.ticks + 1L >= Long.MAX_VALUE) {
            this.ticks = 2L;
        }
        if (this.hasChanged) {
            this.hasChanged = false;
            this.buildEntireNetwork();
        }
        this.updateSimulation();
    }

    public void buildEntireNetwork() {
        if (this.parts != null) {
            for (IComponent iComponent : this.parts) {
                iComponent.destroy();
            }
            this.parts = null;
        }
        for (ISimNode iSimNode : this.getNodes()) {
            iSimNode.reconstruct();
        }
        GridPathfinder networkPathFinder = new GridPathfinder(this);
        this.parts = networkPathFinder.generateParts();
        for (IComponent iComponent : this.parts) {
            iComponent.build();
        }
        this.calculateDeltaPoints();
        this.updateSimulation();
    }

    public void updateSimulation() {
    }

    public void calculateDeltaPoints() {
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean continueUpdate() {
        return this.getNodes().size() > 0;
    }
}

