/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.simulator.grid.component;

import java.util.ArrayList;
import java.util.List;
import universalelectricity.api.core.grid.sim.ISimNode;
import universalelectricity.core.transform.vector.VectorWorld;
import universalelectricity.simulator.grid.SimulatedGrid;
import universalelectricity.simulator.grid.component.IComponent;

public class NetworkPart
implements IComponent {
    private SimulatedGrid sim;
    private List<IComponent> connections;
    private List<ISimNode> nodes;

    public NetworkPart(SimulatedGrid sim, ISimNode ... nodes) {
        this.sim = sim;
        this.connections = new ArrayList<IComponent>();
        this.nodes = new ArrayList<ISimNode>();
        for (ISimNode node : nodes) {
            this.nodes.add(node);
        }
    }

    @Override
    public SimulatedGrid getSimulator() {
        return this.sim;
    }

    @Override
    public List<IComponent> connections() {
        return this.connections;
    }

    @Override
    public boolean doesExistAt(VectorWorld vec) {
        for (ISimNode node : this.nodes) {
            if (!vec.equals(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getPressureChange(IComponent from, IComponent to) {
        int c;
        if (this.connections.contains(from) && this.connections.contains(to) && (c = this.connections.size() - 1) > 0) {
            return 1.0 / (double)c;
        }
        return 1.0;
    }

    @Override
    public double getFlowChange(IComponent from, IComponent to) {
        int c;
        if (this.connections.contains(from) && this.connections.contains(to) && (c = this.connections.size() - 1) > 0) {
            return 1 / c;
        }
        return 1.0;
    }

    @Override
    public void destroy() {
        this.sim = null;
        this.connections = null;
        this.nodes = null;
    }

    @Override
    public void build() {
    }
}

