/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.data.science;

import com.builtbroken.jlib.data.science.HeatingData;
import com.builtbroken.jlib.data.science.MatterPhase;

public enum ChemicalCompound {
    BUTANE("Butane", "C4H10", MatterPhase.GAS, 58.12f, 2.48f, new HeatingData(133.0f, 274.0f, 1379.23f, 6634.23f, 88.0f)),
    METHANE("Methane", "CH4", MatterPhase.GAS, 16.043f, 1.819f, new HeatingData(90.65f, 111.55f, 3656.67f, 31789.56f, 27.0f)),
    WATER("Water", "H20", MatterPhase.LIQUID, 18.01528f, 1000.0f, new HeatingData(274.15f, 373.13f, 18539.816f, 126004.15f, 4.24f)),
    AIR("Air", "", MatterPhase.GAS, 29.0f, 0.125f, null);

    public final String formula;
    public final String compoundName;
    public final float molarMass;
    public final float density;
    public final MatterPhase defaultPhase;
    public final HeatingData heatingData;

    private ChemicalCompound(String name, String formula, MatterPhase phase, float molarMass, float density, HeatingData data) {
        this.compoundName = name;
        this.formula = formula;
        this.molarMass = molarMass;
        this.density = density;
        this.defaultPhase = phase;
        this.heatingData = data;
    }
}

