/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.lang;

import java.text.DecimalFormat;

public final class StringHelpers {
    public static final DecimalFormat NUMBER_FORMATTER_NO_DECIMALS = new DecimalFormat("#,###");
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#,###.00");

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String padLeft(String s, int n) {
        return String.format("%1$" + n + "s", s);
    }

    public static String fitIntoSpaces(long num, int spaces) {
        return StringHelpers.padLeft(NUMBER_FORMATTER_NO_DECIMALS.format(num), spaces);
    }

    public static String formatTimeDifference(long start, long end) {
        return StringHelpers.formatNanoTime(end - start);
    }

    public static String formatNanoTime(long nano) {
        long s = nano / 1000000000L;
        long ms = nano % 1000000000L / 1000000L;
        long us = nano % 1000000000L % 1000000L / 1000L;
        long ns = nano % 1000000000L % 1000000L % 1000L;
        String string = "";
        string = string + StringHelpers.fitIntoSpaces(s, 3) + "s  ";
        string = string + StringHelpers.fitIntoSpaces(ms, 3) + "ms  ";
        string = string + StringHelpers.fitIntoSpaces(us, 3) + "us  ";
        string = string + StringHelpers.fitIntoSpaces(ns, 3) + "ns  ";
        return string;
    }
}

