/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.math.dice;

import com.builtbroken.jlib.math.dice.Dice;
import java.util.ArrayList;
import java.util.Random;

public class DiceRoller
extends ArrayList<Dice> {
    public static DiceRoller COIL_FLIP_TAILS = new DiceRoller(1, 2, 1, 1, 1);
    public static DiceRoller COIL_FLIP_HEADS = new DiceRoller(1, 2, 2, 2, 1);
    protected static Random rand = new Random();
    int minValueForTrue = 0;
    int maxValueForTrue = 0;
    int numDiceToMeetValue = 0;

    public DiceRoller(int valueToHit) {
        this(valueToHit, -1);
    }

    public DiceRoller(int valueToHit, int numDiceToMeetValue) {
        this(valueToHit, valueToHit, numDiceToMeetValue);
    }

    public DiceRoller(int minValueForTrue, int maxValueForTrue, int numDiceToMeetValue) {
        this.minValueForTrue = minValueForTrue;
        this.maxValueForTrue = maxValueForTrue;
        this.numDiceToMeetValue = numDiceToMeetValue;
    }

    public DiceRoller(int minValueForTrue, int maxValueForTrue, int numDiceToMeetValue, Dice ... dice) {
        this(minValueForTrue, maxValueForTrue, numDiceToMeetValue);
        for (Dice di : dice) {
            this.add(di);
        }
    }

    public DiceRoller(int numOfDice, int sidesPerDice, int minValueForTrue, int maxValueForTrue, int numDiceToMeetValue) {
        this(minValueForTrue, maxValueForTrue, numDiceToMeetValue);
        if (sidesPerDice <= 0) {
            throw new IllegalArgumentException("DiceRoller: Dice must have at least one side");
        }
        if (numOfDice <= 0) {
            throw new IllegalArgumentException("DiceRoller: Must have at least one dice to roll");
        }
        for (int i = 0; i < numOfDice; ++i) {
            this.add(new Dice(sidesPerDice));
        }
    }

    public boolean roll() {
        int trueDice = 0;
        if (this.size() > 0) {
            for (Dice dice : this) {
                int roll = dice.roll();
                if (roll < this.minValueForTrue || roll > this.maxValueForTrue || ++trueDice < this.numDiceToMeetValue) continue;
                return true;
            }
        }
        return trueDice >= this.numDiceToMeetValue || this.numDiceToMeetValue == -1 && trueDice == this.size();
    }
}

