/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.api.recipe;

import com.builtbroken.mc.api.recipe.IMachineRecipe;
import com.builtbroken.mc.api.recipe.IMachineRecipeHandler;
import com.builtbroken.mc.api.recipe.RecipeRegisterResult;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum MachineRecipeType {
    ITEM_SMELTER,
    ITEM_GRINDER,
    ITEM_CRUSHER,
    ITEM_WASHER,
    ITEM_SAWMILL,
    ITEM_SALVAGER,
    FLUID_MIXER,
    FLUID_SMELTER,
    FLUID_SOLIDIFIER;

    private IMachineRecipeHandler handler;

    public IMachineRecipeHandler getHandler() {
        return this.handler;
    }

    public void setHandler(IMachineRecipeHandler handler) {
        this.handler = handler;
    }

    public RecipeRegisterResult registerRecipe(IMachineRecipe recipe) {
        if (this.handler != null) {
            return this.handler.registerRecipe(recipe);
        }
        return RecipeRegisterResult.NO_HANDLER;
    }

    public Object getRecipe(Object ... items) {
        return this.getRecipe(0.0f, 0.0f, items);
    }

    public Object getRecipe(float extra_chance, float fail_chance, Object ... items) {
        if (this.getHandler() != null) {
            return this.getHandler().getRecipe(items, extra_chance, fail_chance);
        }
        return null;
    }

    public ItemStack getItemStackRecipe(float extra_chance, float fail_chance, Object ... items) {
        return MachineRecipeType.toItemStack(this.getRecipe(extra_chance, fail_chance, items));
    }

    public static ItemStack toItemStack(Object result) {
        if (result instanceof ItemStack) {
            return (ItemStack)result;
        }
        if (result instanceof Block) {
            return new ItemStack((Block)result);
        }
        if (result instanceof Item) {
            return new ItemStack((Item)result);
        }
        return null;
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

