/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core;

import com.builtbroken.mc.api.recipe.MachineRecipeType;
import com.builtbroken.mc.core.CommonProxy;
import com.builtbroken.mc.core.References;
import com.builtbroken.mc.core.content.BlockOre;
import com.builtbroken.mc.core.content.ItemBlockOre;
import com.builtbroken.mc.core.content.ItemInstaHole;
import com.builtbroken.mc.core.content.resources.Ores;
import com.builtbroken.mc.core.content.resources.load.CrusherRecipeLoad;
import com.builtbroken.mc.core.content.resources.load.GrinderRecipeLoad;
import com.builtbroken.mc.core.content.tool.ItemScrewdriver;
import com.builtbroken.mc.core.content.tool.ToolMode;
import com.builtbroken.mc.core.content.tool.ToolModeGeneral;
import com.builtbroken.mc.core.content.tool.ToolModeRotation;
import com.builtbroken.mc.core.handler.InteractionHandler;
import com.builtbroken.mc.core.handler.SaveManager;
import com.builtbroken.mc.core.network.netty.PacketManager;
import com.builtbroken.mc.core.registry.ModManager;
import com.builtbroken.mc.lib.helper.PotionUtility;
import com.builtbroken.mc.lib.mod.config.ConfigHandler;
import com.builtbroken.mc.lib.mod.config.ConfigScanner;
import com.builtbroken.mc.lib.mod.loadable.LoadableHandler;
import com.builtbroken.mc.prefab.recipe.MRHandlerItemStack;
import com.builtbroken.mc.prefab.recipe.MRSmelterHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="VoltzEngine", name="Voltz Engine", version="0.0.0")
public class Engine {
    public static final ModManager contentRegistry = new ModManager().setPrefix("voltzengine:").setTab(CreativeTabs.field_78040_i);
    public static final boolean runningAsDev = System.getProperty("development") != null && System.getProperty("development").equalsIgnoreCase("true");
    @SidedProxy(clientSide="com.builtbroken.mc.core.ClientProxy", serverSide="com.builtbroken.mc.core.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Metadata(value="VoltzEngine")
    public static ModMetadata metadata;
    @Mod.Instance(value="VoltzEngine")
    public static Engine instance;
    public static Block ore;
    public static Item itemWrench;
    public static Item instaHole;
    private static boolean oresRequested;
    public final PacketManager packetHandler = new PacketManager("voltzengine");
    private LoadableHandler loadables = new LoadableHandler();

    public static void requestOres() {
        oresRequested = true;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        ConfigScanner.instance().generateSets(evt.getAsmData());
        ConfigHandler.sync(References.CONFIGURATION, "voltzengine");
        References.CONFIGURATION.load();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        this.loadables.applyModule(proxy);
        this.loadables.applyModule(this.packetHandler);
        this.loadables.applyModule(CrusherRecipeLoad.class);
        this.loadables.applyModule(GrinderRecipeLoad.class);
        PotionUtility.resizePotionArray();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)SaveManager.instance());
        MinecraftForge.EVENT_BUS.register((Object)new InteractionHandler());
        MachineRecipeType.ITEM_SMELTER.setHandler(new MRSmelterHandler());
        MachineRecipeType.ITEM_GRINDER.setHandler(new MRHandlerItemStack(MachineRecipeType.ITEM_GRINDER));
        MachineRecipeType.ITEM_CRUSHER.setHandler(new MRHandlerItemStack(MachineRecipeType.ITEM_CRUSHER));
        MachineRecipeType.ITEM_WASHER.setHandler(new MRHandlerItemStack(MachineRecipeType.ITEM_WASHER));
        MachineRecipeType.ITEM_SAWMILL.setHandler(new MRHandlerItemStack(MachineRecipeType.ITEM_SAWMILL));
        ToolMode.REGISTRY.add(new ToolModeGeneral());
        ToolMode.REGISTRY.add(new ToolModeRotation());
        if (runningAsDev) {
            instaHole = contentRegistry.newItem(new ItemInstaHole());
        }
        if (References.CONFIGURATION.get("Content", "LoadScrewDriver", true).getBoolean(true)) {
            itemWrench = new ItemScrewdriver();
            GameRegistry.registerItem((Item)itemWrench, (String)"screwdriver", (String)"VoltzEngine");
        }
        this.loadables.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        Engine.metadata.modId = "Voltz Engine";
        Engine.metadata.name = "Voltz Engine";
        Engine.metadata.description = "Voltz Engine is a mod developement framework designed to assist in creation of mods. It provided basic classes for packet handling, tile creation, inventory handling, saving/loading of NBT, and general all around prefabs.";
        Engine.metadata.url = "https://github.com/Universal-Electricity/Resonant-Engine";
        Engine.metadata.version = "0.0.08";
        Engine.metadata.authorList = Arrays.asList("Calclavia", "DarkCow", "tgame14", "Maxwolf");
        Engine.metadata.autogenerated = false;
        if (oresRequested) {
            ore = contentRegistry.newBlock("VoltzEngineStoneOre", new BlockOre("stone"), ItemBlockOre.class);
            Ores.registerSet(ore, References.CONFIGURATION);
        }
        this.loadables.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        this.loadables.postInit();
        OreDictionary.registerOre((String)"ingotGold", (Item)Items.field_151043_k);
        OreDictionary.registerOre((String)"ingotIron", (Item)Items.field_151042_j);
        OreDictionary.registerOre((String)"oreGold", (Block)Blocks.field_150352_o);
        OreDictionary.registerOre((String)"oreIron", (Block)Blocks.field_150366_p);
        OreDictionary.registerOre((String)"oreLapis", (Block)Blocks.field_150369_x);
        References.CONFIGURATION.save();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent evt) {
        SaveManager.saveAll();
    }

    static {
        ore = null;
        oresRequested = false;
    }
}

