/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.netty;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.core.network.netty.ResonantChannelHandler;
import com.builtbroken.mc.core.network.netty.ResonantPacketHandler;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.lib.helper.wrapper.ByteBufWrapper;
import com.builtbroken.mc.lib.mod.loadable.ILoadable;
import com.builtbroken.mc.lib.transform.vector.Pos;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketManager
implements ILoadable {
    public final String channel;
    protected EnumMap<Side, FMLEmbeddedChannel> channelEnumMap;

    public PacketManager(String channel) {
        this.channel = channel;
    }

    @Deprecated
    public static void writeData(ByteBuf data, Object ... sendData) {
        new ByteBufWrapper.ByteBufWrapper(data).$less$less$less(sendData);
    }

    public Packet toMCPacket(AbstractPacket packet) {
        return this.channelEnumMap.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packet);
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        this.channelEnumMap = NetworkRegistry.INSTANCE.newChannel(this.channel, new ChannelHandler[]{new ResonantChannelHandler(), new ResonantPacketHandler()});
    }

    @Override
    public void postInit() {
    }

    public void sendToPlayer(AbstractPacket packet, EntityPlayerMP player) {
        this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToAllInDimension(AbstractPacket packet, int dimId) {
        this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimId);
        this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToAllInDimension(AbstractPacket packet, World world) {
        this.sendToAllInDimension(packet, world.field_73011_w.field_76574_g);
    }

    public void sendToAll(AbstractPacket packet) {
        this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToAllAround(AbstractPacket message, NetworkRegistry.TargetPoint point) {
        this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToAllAround(AbstractPacket message, IWorldPosition point, double range) {
        this.sendToAllAround(message, point.world(), point.x(), point.y(), point.z(), range);
    }

    public void sendToAllAround(AbstractPacket message, World world, IPos3D point, double range) {
        this.sendToAllAround(message, world, point.x(), point.y(), point.z(), range);
    }

    public void sendToAllAround(AbstractPacket message, World world, Pos point, double range) {
        this.sendToAllAround(message, world, point.x(), point.y(), point.z(), range);
    }

    public void sendToAllAround(AbstractPacket message, TileEntity tile) {
        this.sendToAllAround(message, tile, 64.0);
    }

    public void sendToAllAround(AbstractPacket message, TileEntity tile, double range) {
        this.sendToAllAround(message, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, range);
    }

    public void sendToAllAround(AbstractPacket message, World world, double x, double y, double z, double range) {
        this.sendToAllAround(message, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, range));
    }

    @SideOnly(value=Side.CLIENT)
    public void sendToServer(AbstractPacket packet) {
        this.channelEnumMap.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channelEnumMap.get(Side.CLIENT).writeAndFlush((Object)packet);
    }
}

