/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet;

import com.builtbroken.mc.api.ISave;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.References;
import com.builtbroken.mc.core.network.IByteBufWriter;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AbstractPacket {
    public ByteBuf data;
    public int id = 0;
    protected ArrayList<Object> load = new ArrayList();

    public AbstractPacket() {
    }

    public AbstractPacket(int id, Object ... args) {
        this.id = id;
        if (args != null) {
            for (Object obj : args) {
                this.load.add(obj);
            }
        }
    }

    public static void write(Object object, ByteBuf data) {
        if (object == null) {
            if (Engine.runningAsDev) {
                References.LOGGER.error("Attempted to write a null object to packet");
                IllegalArgumentException e = new IllegalArgumentException();
                e.printStackTrace();
            }
        } else if (object instanceof Object[]) {
            for (Object obj : (Object[])object) {
                AbstractPacket.write(obj, data);
            }
        } else if (object instanceof Collection) {
            for (Object obj : (Collection)object) {
                AbstractPacket.write(obj, data);
            }
        } else if (object instanceof Integer) {
            data.writeInt(((Integer)object).intValue());
        } else if (object instanceof Float) {
            data.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            data.writeDouble(((Double)object).doubleValue());
        } else if (object instanceof Byte) {
            data.writeByte((int)((Byte)object).byteValue());
        } else if (object instanceof Boolean) {
            data.writeBoolean(((Boolean)object).booleanValue());
        } else if (object instanceof String) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)((String)object));
        } else if (object instanceof Short) {
            data.writeShort((int)((Short)object).shortValue());
        } else if (object instanceof Long) {
            data.writeLong(((Long)object).longValue());
        } else if (object instanceof IByteBufWriter) {
            ((IByteBufWriter)object).writeBytes(data);
        } else if (object instanceof IPosition) {
            data.writeInt(((Integer)object).intValue());
        } else if (object instanceof NBTTagCompound) {
            ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)((NBTTagCompound)object));
        } else if (object instanceof ISave) {
            ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)((ISave)object).save(new NBTTagCompound()));
        } else if (Engine.runningAsDev) {
            References.LOGGER.error("Attempt to write an invalid object [" + data + "] of class [" + data.getClass() + "]");
        }
    }

    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.id);
        for (Object obj : this.load) {
            AbstractPacket.write(obj, buffer);
        }
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.data = buffer.slice();
    }

    public void handleClientSide(EntityPlayer player) {
    }

    public void handleServerSide(EntityPlayer player) {
    }

    public void send() {
        Engine.instance.packetHandler.sendToAll(this);
    }
}

