/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet;

import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.IPacketReceiver;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.lib.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketTile
extends AbstractPacket {
    public int x;
    public int y;
    public int z;

    public PacketTile() {
    }

    public PacketTile(TileEntity tile, int id, Object ... args) {
        super(id, args);
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        super.encodeInto(ctx, buffer);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        super.decodeInto(ctx, buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        this.handle(player);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        this.handle(player);
    }

    public void handle(EntityPlayer player) {
        TileEntity tile = player.func_130014_f_().func_147438_o(this.x, this.y, this.z);
        if (tile instanceof IPacketIDReceiver) {
            try {
                int id;
                IPacketIDReceiver receiver = (IPacketIDReceiver)player.func_130014_f_().func_147438_o(this.x, this.y, this.z);
                ByteBuf buf = this.data.slice();
                try {
                    id = buf.readInt();
                }
                catch (IndexOutOfBoundsException ex) {
                    System.out.println("Packet sent to a Tile[" + tile + "] failed to provide a packet ID");
                    System.out.println("Location: " + new Pos(this.x, this.y, this.z));
                    return;
                }
                receiver.read(buf, id, player, this);
            }
            catch (Exception e) {
                System.out.println("Packet sent to a TileEntity failed to be received [" + tile + "] in " + new Pos(this.x, this.y, this.z));
                e.printStackTrace();
            }
        } else if (tile instanceof IPacketReceiver) {
            try {
                IPacketReceiver receiver = (IPacketReceiver)player.func_130014_f_().func_147438_o(this.x, this.y, this.z);
                receiver.read(player, this);
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println("Packet sent to a TileEntity was read out side its bounds [" + tile + "] in " + new Pos(this.x, this.y, this.z));
            }
            catch (Exception e) {
                System.out.println("Packet sent to a TileEntity failed to be received [" + tile + "] in " + new Pos(this.x, this.y, this.z));
                e.printStackTrace();
            }
        } else {
            System.out.println("Packet was sent to a tile not implementing IPacketReceiver, this is a coding error [" + tile + "] in " + new Pos(this.x, this.y, this.z));
        }
    }
}

