/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.access;

import com.builtbroken.jlib.type.Group;
import com.builtbroken.mc.api.ISave;
import com.builtbroken.mc.lib.access.AccessUser;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class AccessGroup
extends Group<AccessUser>
implements ISave,
Cloneable {
    protected Set<String> nodes = new LinkedHashSet<String>();
    protected AccessGroup extendGroup;
    protected String extendGroup_name;
    protected long creation_time = System.currentTimeMillis();

    public AccessGroup(String group_name, AccessUser ... users) {
        super(group_name, users);
    }

    public AccessUser getMember(String username) {
        for (AccessUser user : this.members) {
            if (!user.getName().equalsIgnoreCase(username)) continue;
            return user;
        }
        return null;
    }

    @Override
    public boolean addMemeber(AccessUser obj) {
        if (super.addMemeber(obj)) {
            obj.setGroup(this);
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        nbt.func_74778_a("groupName", this.getName());
        if (this.extendGroup_name != null) {
            nbt.func_74778_a("extendGroup", this.extendGroup_name);
        }
        NBTTagList usersTag = new NBTTagList();
        for (AccessUser user : this.members) {
            NBTTagCompound accessData = new NBTTagCompound();
            user.save(accessData);
            usersTag.func_74742_a((NBTBase)accessData);
        }
        nbt.func_74782_a("users", (NBTBase)usersTag);
        NBTTagList nodesTag = new NBTTagList();
        for (String str : this.nodes) {
            NBTTagCompound accessData = new NBTTagCompound();
            accessData.func_74778_a("name", str);
            nodesTag.func_74742_a((NBTBase)accessData);
        }
        nbt.func_74782_a("permissions", (NBTBase)nodesTag);
        nbt.func_74772_a("creationDate", this.creation_time);
        return nbt;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.setName(nbt.func_74779_i("groupName"));
        if (nbt.func_74764_b("extendGroup")) {
            this.extendGroup_name = nbt.func_74779_i("extendGroup");
        }
        NBTTagList userList = nbt.func_150295_c("users", 0);
        this.getMembers().clear();
        for (int i = 0; i < userList.func_74745_c(); ++i) {
            AccessUser user = AccessUser.loadFromNBT(userList.func_150305_b(i));
            this.addMemeber(user);
        }
        NBTTagList nodeList = nbt.func_150295_c("permissions", 0);
        this.nodes.clear();
        for (int i = 0; i < nodeList.func_74745_c(); ++i) {
            this.nodes.add(nodeList.func_150305_b(i).func_74779_i("name"));
        }
        this.creation_time = nbt.func_74764_b("creationDate") ? nbt.func_74763_f("creationDate") : System.currentTimeMillis();
    }

    public boolean hasNode(String node) {
        if (node.contains(".*")) {
            String tempNode = node.replaceAll(".*", "");
            for (String headNode : this.nodes) {
                if (!tempNode.contains(headNode)) continue;
                return true;
            }
        }
        return this.nodes.contains(node) || this.getExtendGroup() != null && this.getExtendGroup().hasNode(node);
    }

    public void addNode(String node) {
        this.nodes.add(node);
    }

    public void removeNode(String node) {
        if (this.nodes.contains(node)) {
            this.nodes.remove(node);
        }
    }

    @Override
    public boolean isMemeber(String string) {
        return this.members.contains(new AccessUser(string));
    }

    public void setToExtend(AccessGroup group) {
        this.extendGroup = group;
        if (this.extendGroup != null) {
            this.extendGroup_name = this.extendGroup.getName();
        }
    }

    public AccessGroup getExtendGroup() {
        return this.extendGroup;
    }

    public String getExtendGroupName() {
        return this.extendGroup_name;
    }

    public Set<String> getNodes() {
        return this.nodes;
    }

    public AccessGroup clone() {
        AccessGroup group = new AccessGroup(this.getName(), new AccessUser[0]);
        for (String node : this.getNodes()) {
            group.getNodes().add(node);
        }
        return group;
    }
}

