/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.helper;

import com.builtbroken.mc.lib.transform.vector.Pos;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class MathUtility {
    public static final Random rand = new Random();

    public static double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }

    public static float lerp(float a, float b, float f) {
        return a + f * (b - a);
    }

    public static double absCap(double value, double bounds) {
        return Math.min(Math.max(value, -bounds), bounds);
    }

    public static float absCap(float value, float bounds) {
        return Math.min(Math.max(value, -bounds), bounds);
    }

    public static int[] generateRandomIntArray(Random random, int maxNumber, int arraySize) {
        return MathUtility.generateRandomIntArray(random, 0, maxNumber, arraySize);
    }

    public static int[] generateSqeuncedArray(int start, int size) {
        int[] array = new int[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = start + i;
        }
        return array;
    }

    public static List<Integer> getSquencedList(int start, int end, int ... ignore) {
        int i;
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList<Integer> remove = new ArrayList<Integer>();
        if (ignore != null & ignore.length > 0) {
            for (i = 0; i <= ignore.length; ++i) {
                remove.add(ignore[i]);
            }
        }
        for (i = 0; i <= end; ++i) {
            if (remove.contains(start + i)) continue;
            list.add(start + i);
        }
        return list;
    }

    public static int[] generateRandomIntArray(Random random, int minNumber, int maxNumber, int arraySize) {
        int[] array = new int[arraySize];
        for (int i = 0; i < array.length; ++i) {
            int number = random.nextInt(maxNumber);
            if (minNumber != 0) {
                while (number < minNumber) {
                    number = random.nextInt(maxNumber);
                }
            }
            array[i] = number;
        }
        return array;
    }

    public static Pos vecToSphereAngles(Pos vec) {
        double radius = Math.sqrt(vec.x() * vec.x() + vec.y() * vec.y() + vec.z() * vec.z());
        double inclination = Math.acos(vec.z() / radius);
        double azimuth = Math.atan(vec.y() / vec.z());
        return new Pos(radius, inclination, azimuth);
    }

    public static Pos sphereAnglesToVec(Double radius, Double inclination, Double azimuth) {
        double x = radius * Math.sin(inclination) * Math.cos(azimuth);
        double y = radius * Math.sin(inclination) * Math.sin(azimuth);
        double z = radius * Math.cos(inclination);
        return new Pos(x, y, z);
    }

    public static float clampAngle(float var, float min, float max) {
        while (var < min) {
            var += 360.0f;
        }
        while (var > max) {
            var -= 360.0f;
        }
        return var;
    }

    public static double clampAngle(double var, double min, float max) {
        while (var < min) {
            var += (double)max;
        }
        while (var > (double)max) {
            var -= (double)max;
        }
        return var;
    }

    public static float clamp(float var, float min, float max) {
        if (var < min) {
            return min;
        }
        if (var > max) {
            return max;
        }
        return var;
    }

    public static float clampAngleTo360(float var) {
        return MathUtility.clampAngle(var, 0.0f, 360.0f);
    }

    public static double clampAngleTo360(double var) {
        return MathUtility.clampAngle(var, 0.0, 360.0f);
    }

    public static float clampAngleTo180(float var) {
        return MathUtility.clampAngle(var, -180.0f, 180.0f);
    }

    public static double clampAngleTo180(double var) {
        return MathUtility.clampAngle(var, -180.0, 180.0f);
    }

    public static float shortestAngleTo360(float angle, float angleGoal) {
        if ((angle = MathUtility.clampAngleTo360(angle)) == (angleGoal = MathUtility.clampAngleTo360(angleGoal))) {
            return 0.0f;
        }
        if (angle > angleGoal) {
            return angleGoal - angle;
        }
        return angle - angleGoal;
    }

    public static double updateRotation(double from, double to, double speed) {
        double delta = Math.abs((from = MathHelper.func_76138_g((double)from)) - (to = MathHelper.func_76138_g((double)to)));
        if (delta > (double)0.001f) {
            from = from > to ? (from += delta >= 0.0 ? speed : -speed) : (from += delta >= 0.0 ? -speed : speed);
            if (delta < speed + (double)0.1f) {
                from = to;
            }
        }
        return from;
    }

    public static double updateRotation(float from, float to, float speed) {
        double delta = Math.abs((from = MathHelper.func_76142_g((float)from)) - (to = MathHelper.func_76142_g((float)to)));
        if (delta > (double)0.001f) {
            from = from > to ? (from += delta >= 0.0 ? speed : -speed) : (from += delta >= 0.0 ? -speed : speed);
            if (delta < (double)(speed + 0.1f)) {
                from = to;
            }
        }
        return from;
    }

    public static ForgeDirection getFacingDirectionFromAngle(float yaw) {
        float angle = MathHelper.func_76142_g((float)yaw);
        if (angle >= -45.0f && angle <= 45.0f) {
            return ForgeDirection.SOUTH;
        }
        if (angle >= 45.0f && angle <= 135.0f) {
            return ForgeDirection.WEST;
        }
        if (angle >= 135.0f && angle <= -135.0f) {
            return ForgeDirection.NORTH;
        }
        return ForgeDirection.EAST;
    }

    public static ForgeDirection getFacingDirectionFromAngle(double yaw) {
        return MathUtility.getFacingDirectionFromAngle((float)yaw);
    }

    public static double getSphereVolume(double radius) {
        return Math.PI * 4 * (radius * radius * radius) / 3.0;
    }
}

