/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.helper;

import com.builtbroken.mc.core.References;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.Level;

public class ReflectionUtility
extends ReflectionHelper {
    public static <e> Constructor<e> getConstructorWithArgs(Class<e> clazz, Object ... args) {
        if (clazz != null) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                if (constructor.getParameterTypes().length != args.length) continue;
                Class<?>[] pType = constructor.getParameterTypes();
                for (int i = 0; i < pType.length; ++i) {
                    if (!pType[i].equals(args[i].getClass()) || i != pType.length - 1) continue;
                    try {
                        Constructor<?> con = constructor;
                        return con;
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public static void setMCFieldWithCatch(Class clazz, Object instance, String fieldName, Object newValue) {
        try {
            ReflectionUtility.setMCField(clazz, instance, fieldName, newValue);
        }
        catch (NoSuchFieldException e) {
            References.LOGGER.catching(Level.ERROR, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            References.LOGGER.catching(Level.ERROR, (Throwable)e);
        }
    }

    public static void setMCField(Class clazz, Object instance, String fieldName, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        int m = -1;
        String fieldName_ = ReflectionUtility.getMCFieldName(clazz, fieldName);
        Field field = clazz.getField(fieldName_);
        field.setAccessible(true);
        if (Modifier.isFinal(field.getModifiers())) {
            m = ReflectionUtility.removeFinalFromField(field);
        }
        field.set(instance, newValue);
        if (m != -1) {
            ReflectionUtility.setModifiers(field, m);
        }
    }

    public static void printFields(Class clazz) {
        System.out.println("==== Outputting Fields Names ====");
        System.out.println("\tClass: " + clazz);
        for (String name : ReflectionUtility.getFieldNames(clazz)) {
            System.out.println("\t" + name);
        }
        System.out.println("==== Done Listing Field Names ====");
    }

    public static List<String> getFieldNames(Class clazz) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field f : ReflectionUtility.getAllFields(clazz)) {
            String name = f.getName();
            if (fieldNames.contains(name)) continue;
            fieldNames.add(name);
        }
        return fieldNames;
    }

    public static List<Field> getAllFields(Class clazz) {
        List<Field> fields = ReflectionUtility.getFields(clazz);
        fields.addAll(ReflectionUtility.getDeclaredFields(clazz));
        return fields;
    }

    public static List<Field> getFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getFields()));
        return fields;
    }

    public static List<Field> getDeclaredFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return fields;
    }

    public static Method getMethod(Class clazz, String name, Class<?> ... args) {
        Method method = null;
        try {
            method = clazz.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            try {
                method = clazz.getDeclaredMethod(name, args);
            }
            catch (NoSuchMethodException e2) {
                // empty catch block
            }
        }
        return method;
    }

    public static List<Method> getAllMethods(Class clazz) throws ClassNotFoundException {
        List<Method> fields = ReflectionUtility.getMethods(clazz);
        fields.addAll(ReflectionUtility.getDeclaredMethods(clazz));
        return fields;
    }

    public static List<Method> getAllMethods(Class clazz, Class<? extends Annotation> ... annotations) throws ClassNotFoundException {
        List<Method> fields = ReflectionUtility.getAllMethods(clazz);
        ArrayList<Method> returns = new ArrayList<Method>();
        for (Method m : fields) {
            for (Class<? extends Annotation> an : annotations) {
                if (!m.isAnnotationPresent(an)) continue;
                returns.add(m);
            }
        }
        return fields;
    }

    public static List<Method> getMethods(Class clazz) throws ClassNotFoundException {
        ArrayList<Method> fields = new ArrayList<Method>();
        fields.addAll(Arrays.asList(clazz.getMethods()));
        return fields;
    }

    public static List<Method> getDeclaredMethods(Class clazz) throws ClassNotFoundException {
        ArrayList<Method> fields = new ArrayList<Method>();
        fields.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        return fields;
    }

    public static Field getMCField(Class clazz, String fieldName) {
        Field f;
        try {
            f = clazz.getField(ReflectionUtility.getMCFieldName(clazz, fieldName));
        }
        catch (NoSuchFieldException e) {
            try {
                f = clazz.getDeclaredField(ReflectionUtility.getMCFieldName(clazz, fieldName));
            }
            catch (NoSuchFieldException e2) {
                return null;
            }
        }
        f.setAccessible(true);
        return f;
    }

    public static String getMCFieldName(Class clazz, String fieldName) {
        String[] fields = ObfuscationReflectionHelper.remapFieldNames((String)clazz.getName(), (String[])new String[]{fieldName});
        if (fields != null && fields.length > 0) {
            return fields[0];
        }
        return fieldName;
    }

    public static void setFinalStaticMCField(Class clazz, String fieldname, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        ReflectionUtility.setFinalStaticField(clazz.getField(ReflectionUtility.getMCFieldName(clazz, fieldname)), newValue);
    }

    public static void setFinalStaticField(Field field, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        ReflectionUtility.setFinalField(null, field, newValue);
    }

    public static void setFinalField(Object instance, Field field, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        field.set(instance, newValue);
    }

    public static int removeFinalFromField(Field field) throws NoSuchFieldException, IllegalAccessException {
        return ReflectionUtility.setModifiers(field, field.getModifiers() & 0xFFFFFFEF);
    }

    public static int setModifiers(Field field, int modifier) throws NoSuchFieldException, IllegalAccessException {
        int m = field.getModifiers();
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, modifier);
        return m;
    }
}

